### Name: gibbsSampler
### Title: Estimate posterior parameters in Bayesian Association Model
### Aliases: gibbsSampler
### Keywords: models

### ** Examples

# Load example matrices and write to csv files.
data(Y, X, Z, R, Zprob)
write.csv(cbind(Y,X,Z,R), file="generatedData.csv", quote=FALSE, row.names=FALSE)
write.csv(Zprob, file="Zprob.csv", quote=FALSE, row.names=FALSE)
        
# Run the gibbs sampler with 100 iterations, keeping the last 800
gibbsSampler(fname="generatedData.csv", fprob="Zprob.csv", n=8, p=3, s=5, nsim=1000, keep=800)

#remove all generated csv files
unlink("*.txt")
unlink("*.csv")



