### Name: binogcp
### Title: Binomial sampling with a general continuous prior
### Aliases: binogcp
### Keywords: misc

### ** Examples

## simplest call with 6 successes observed in 8 trials and a continuous 
## uniform prior
binogcp(6,8)

## 6 successes, 8 trials and a Beta(2,2) prior
binogcp(6,8,density="beta",params=c(2,2))

## 5 successes, 10 trials and a N(0.5,0.25) prior
binogcp(5,10,density="normal",params=c(0.5,0.25))

## 4 successes, 12 trials with a user specified triangular continuous prior
pi<-seq(0,1,by=0.001)
pi.prior<-rep(0,length(pi))
pi.prior[pi<=0.5]<-4*pi[pi<=0.5]
pi.prior[pi>0.5]<-4-4*pi[pi>0.5]
results<-binogcp(4,12,"user",pi=pi,pi.prior=pi.prior,ret=TRUE)

## find the posterior CDF using the previous example and Simpson's rule
cdf<-sintegral(pi,results$posterior,n.pts=length(pi),ret=TRUE)
plot(cdf,type="l",xlab=expression(pi[0])
        ,ylab=expression(Pr(pi<=pi[0])))

## use the cdf to find the 95% credible region. Thanks to John Wilkinson for this simplified code.
lcb<-cdf$x[with(cdf,which.max(x[y<=0.025]))]
ucb<-cdf$x[with(cdf,which.max(x[y<=0.975]))]
cat(paste("Approximate 95% credible interval : ["
        ,round(lcb,4)," ",round(ucb,4),"]\n",sep=""))

## find the posterior mean, variance and std. deviation
## using Simpson's rule and the output from the previous example
dens<-pi*results$posterior # calculate pi*f(pi | x, n)
post.mean<-sintegral(pi,dens)

dens<-(pi-post.mean)^2*results$posterior
post.var<-sintegral(pi,dens)
post.sd<-sqrt(post.var)

# calculate an approximate 95% credible region using the posterior mean and 
# std. deviation
lb<-post.mean-qnorm(0.975)*post.sd
ub<-post.mean+qnorm(0.975)*post.sd

cat(paste("Approximate 95% credible interval : ["
        ,round(lb,4)," ",round(ub,4),"]\n",sep=""))



