### Name: disgam
### Title: Fitting Discrete Generalized Additive Models with Model
###   Selection Criterion
### Aliases: disgam
### Keywords: smooth models regression

### ** Examples

## Poisson Response
set.seed(11)
n <- 200
x1 <- runif(n, 0, 1)

eta0 <- f0(x1)/4 - 0.5
mu0 <- exp(eta0)

y <- rpois(rep(1,n), mu0) # generating non-zero-inflated data

res.gam <- disgam(y~s(x1), family=poisson) # fit a regular GAM
res.zigam <- zigam(y~s(x1), maxiter=10, family=poisson) # fit a ZIGAM

res.gam$logE > res.zigam$logE # compare the model selction criterion

# Another example
set.seed(11)
n <- 200
x1 <- runif(n, 0, 1)
eta0 <- f0(x1)/4 - 0.5
mu0 <- exp(eta0)

alpha0 <- 0.4
delta0 <- 0.8
p0 <- .Call("logit_linkinv", alpha0 + delta0 * eta0, PACKAGE = "stats")

# Generating zero-inflated Poisson count data
z <- rbinom(rep(1,n), 1, p0)
y <- rpois(rep(1,n), mu0)
y[z==0] <- 0

res.gam <- disgam(y~s(x1), family=poisson) # fit a regular GAM
res.zigam <- zigam(y~s(x1), family=poisson) # fit a ZIGAM

res.gam$logE < res.zigam$logE # compare the model selction criterion




