### Name: summary.cozigam
### Title: Summary for a COZIGAM fit
### Aliases: summary.cozigam print.summary.cozigam
### Keywords: models smooth regression

### ** Examples

set.seed(1)
n <- 600
x1 <- runif(n, 0, 1)
x2 <- runif(n, 0, 1)
x3 <- runif(n, 0, 1)

f <- test(x1, x2)*2 + f0(x3)/5
eta0 <- f/1.1
mu0 <- exp(eta0)  

eta.p10 <- (test(x1,x2) - mean(test(x1,x2)))*2/1.1
eta.p20 <- (f0(x3) - mean(f0(x3)))/5/1.1

alpha0 <- 0.5
delta10 <- 1
delta20 <- 0
eta.p0 <- delta10*eta.p10 + delta20*eta.p20 
p0 <- .Call("logit_linkinv", alpha0 + eta.p0, PACKAGE = "stats")

z <- rbinom(rep(1,n), 1, p0)
y <- rpois(rep(1,n), mu0)
y[z==0] <- 0; rm(z)

res <- cozigam(y~s(x1,x2)+s(x3), constraint="component", zero.delta=c(NA, 0), family=poisson)
summary(res)




