### Name: zigam
### Title: Fitting (Unconstrained) Zero-Inflated Generalized Additive
###   Models
### Aliases: zigam
### Keywords: smooth models regression

### ** Examples

## Gaussian Response 
set.seed(11)
n <- 200
x1 <- runif(n, 0, 1)
f <- (f0(x1)-mean(f0(x1)))/2
sig <- 0.3
mu0 <- f + 1.5
y <- mu0 + rnorm(n, 0, sig)

eta.p0 <- f1(x1)*2 - 1 # true function used in zero-infation process
p0 <- .Call("logit_linkinv", eta.p0, PACKAGE = "stats")

z <- rbinom(rep(1,n), 1, p0)
y[z==0] <- 0

# Fit a ZIGAM
res.un <- zigam(y~s(x1), family=gaussian)

# Compare with a COZIGAM
res <- cozigam(y~s(x1), family=gaussian)
res.un$logE > res$logE

## Poisson Response
set.seed(11)
n <- 400
x1 <- runif(n, 0, 1)
x2 <- runif(n, 0, 1)

eta0 <- test(x1,x2)*3
mu0 <- exp(eta0)  

alpha0 <- -0.2
delta0 <- 1.0
p0 <- .Call("logit_linkinv", alpha0 + delta0 * eta0, PACKAGE = "stats")

z <- rbinom(rep(1,n), 1, p0)
y <- rpois(rep(1,n), mu0)
y[z==0] <- 0

res.un <- zigam(y~s(x1,x2), maxiter=30, family=poisson) # fit a ZIGAM
res <- cozigam(y~s(x1,x2), maxiter=30, family=poisson) # fit a COZIGAM
res.un$logE < res$logE # compare the model selction criterion




