### Name: hypergeo
### Title: The hypergeometric function
### Aliases: hypergeo hypergeo2 genhypergeo conhypergeo
### Keywords: math

### ** Examples


## Not run: 
##D #  equation 15.1.3, page 556:
##D f1 <- function(x){-log(1-x)/x}
##D f2 <- function(x){hypergeo(1,1,2,x)}
##D f3 <- function(x){hypergeo(1,1,2,x,tol=1e-10)}
##D x <- seq(from = -0.6,to=0.6,len=14)
##D f1(x)-f2(x)
##D f1(x)-f3(x)  # Note tighter tolerance
##D 
##D # equation 15.1.7, p556:
##D g1 <- function(x){log(x + sqrt(1+x^2))/x}
##D g2 <- function(x){hypergeo(1/2,1/2,3/2,-x^2)}
##D g1(x)-g2(x)  # should be small 
##D abs(g1(x+0.1i) - g2(x+0.1i))  # should have small modulus.
##D 
##D # Just a random call, verified by Maple [ Hypergeom([],[1.22],0.9087) ]:
##D genhypergeo(NULL,1.22,0.9087)
## End(Not run)



