### Name: as.dierckx
### Title: Convert a spline object to class 'dierckx'
### Aliases: as.dierckx as.dierckx.fd
### Keywords: smooth manip

### ** Examples

x <- 0:24
y <- c(1.0,1.0,1.4,1.1,1.0,1.0,4.0,9.0,13.0,
       13.4,12.8,13.1,13.0,14.0,13.0,13.5,
       10.0,2.0,3.0,2.5,2.5,2.5,3.0,4.0,3.5)
curfit.xy <- curfit(x, y, s=0)

if(require(fda)) {
  curfit.fd <- as.fd(curfit.xy)
  plot(curfit.fd) # as an 'fd' object
  points(x, y) # Curve goes through the points.

  x. <- seq(0, 24, length=241)
  pred.y <- predict(curfit.xy, x.)
  lines(x., pred.y, lty="dashed", lwd=3, col="blue")
# dierckx and fd objects match.

## Don't show: 
stopifnot(
## End Don't show
  all.equal(knots(curfit.xy, FALSE), knots(curfit.fd, FALSE))
## Don't show: 
)
## End Don't show
## Don't show: 
stopifnot(
## End Don't show
  all.equal(coef(curfit.xy), as.vector(coef(curfit.fd)))
## Don't show: 
)
## End Don't show

  curfit2 <- as.dierckx(curfit.fd)
  pred.y2 <- predict(curfit2, x.)
  sum(abs(pred.y-pred.y2))/(sum(abs(pred.y)+abs(pred.y2))/2)
# 1.3e-7

## Don't show: 
stopifnot(
## End Don't show
  all.equal(knots(curfit.xy, FALSE), knots(curfit2, FALSE))
## Don't show: 
)
## End Don't show
# TRUE
  all.equal(coef(curfit.xy), coef(curfit2))
# "Mean relative  difference: 4.5e-7

  preserved <- c("from", "to", "n", "g", "periodic", "xlim","ylim")
  all.equal(curfit.xy[preserved], curfit2[preserved])
# TRUE
# Other components are NOT preserved in translation
# and so can NOT be restored.
}




