### Name: controlPolygon
### Title: Control polygon of a spline
### Aliases: controlPolygon
### Keywords: smooth

### ** Examples

# spline object of Figure 1.2  
knots1.2 <- c(0,0,0,0, 2, 4, 7, 8, 10,10,10,10)
wts <- c(1, 2, 5, -5, 5, -1, 3, 3)

library(fda) 
fig1.2basis <- create.bspline.basis(c(0, 10),
                                    breaks=c(0, 2, 4, 7, 8, 10))
fig1.2a.fda <- fd(c(1, 2, 5, -5, 5, -1, 3, 3), fig1.2basis)
plot(fig1.2a.fda, ylim=c(-5, 5))

# NOTE:
# An attempt to create this Figure using 'curfit'
# failed, because 'curfit' dropped the knots at 2 and 8.

cP <- controlPolygon(fig1.2a.fda)
lines(cP[, 1], cP[, 2], lty="dotted")

fig1.2a.dierckx <- fd2dierckx(fig1.2a.fda)
cPdierckx <- controlPolygon(fig1.2a.dierckx)
all.equal(cP, cPdierckx)
#  "Mean relative  difference: 5.745888e-07"




