### Name: deriv.dierckx
### Title: Spline Differentiation
### Aliases: deriv deriv.dierckx
### Keywords: smooth math

### ** Examples


x <- seq(0, 1, 0.1)
y <- (1 - x)^3
z <- curfit(x, y, method = "ls", knots = seq(0, 1, 0.2), k = 3)

plot(x, y, type = "p")
lines(x, fitted(z), col = "blue")

D1 <- deriv(z, order = 1)
D2 <- deriv(~(1 - x)^3, "x", func = TRUE)(z$x)
D3 <- numericDeriv(quote((1 - x)^3), "x")
D4 <- -3 * (1 - z$x)^2
cbind(D1 = D1,
     D2 = attr(D2, "gradient")[, 1],
     D3 = diag(attr(D3, "gradient")),
     D4 = D4)



