### Name: insert.dierckx
### Title: Spline Knot Insertion
### Aliases: insert insert.dierckx
### Keywords: smooth math

### ** Examples

xi <- 1:10
yi <- sin(xi) 
spli <- curfit(xi, yi, s=10)
plot(xi, yi) 
lines(spli)

spli2 <- insert(spli)
lines(spli2, col="red")
kni <- knots(spli, FALSE) # 1 1 1 1 10 10 10 10 
all.equal(c(kni[1:4], 5.5, kni[5:8]), knots(spli2, FALSE))
# add 1 knot at 5.5  
ci <- coef(spli)
ci2 <- coef(spli2)
all.equal(c(ci[1], 0.5*(ci[-1]+ci[-4]), ci[4]), ci2)
# "Mean relative  difference: 2.700131e-08"



