### Name: integral.dierckx
### Title: Spline Integration
### Aliases: integral.dierckx
### Keywords: smooth math

### ** Examples

x <- seq(0, 1, 0.1)
y <- (1 - x)^3
z <- curfit(x, y, knots = seq(0, 1, 0.2))

plot(x, y, type = "p")
lines(x, fitted(z), col = "blue")

(answer <- integrate(function(x) (1 - x)^3, 0, 1))
#0.25 with absolute error < 2.8e-15
integral(z)-answer$value
# 0

(ans2 <- integrate(function(x) (1 - x)^3, 0.5, 0.6))
#0.009225 with absolute error < 1.0e-16
integral(z, 0.5, 0.6)-ans2$value
# 6e-9



