###################################################
### chunk number 1: 
###################################################
library(ISA)
library(car)
prova<-function(ridotto,esteso,displayridotto=TRUE,displayesteso=TRUE,displaytest=TRUE,alpha=0.05){
if(displayridotto){
cat("\nMODELLO RIDOTTO:")
print(matrix(ridotto$beta[,1],nrow=length(ridotto$beta),dimnames=list(rownames(ridotto$beta),character(1))))
cat("\nVarianza stimata: ",ridotto$varianzaStimata,"\n")
cat("Devianza residua: ",ridotto$varianzaStimata*(length(vY)-length(ridotto$beta)),"\n")
cat("gradi di libert: ",length(vY)-length(ridotto$beta),"\n")
}
if(displayesteso){
cat("\nMODELLO ESTESO:")
print(matrix(esteso$beta[,1],nrow=length(esteso$beta),dimnames=list(rownames(esteso$beta),character(1))))
cat("\nVarianza stimata: ",esteso$varianzaStimata,"\n")
cat("Devianza residua: ",esteso$varianzaStimata*(length(vY)-length(esteso$beta)),"\n")
cat("gradi di libert: ",length(vY)-length(esteso$beta),"\n")
}
devResRidotto <- sum(ridotto$residui^2)
devResEsteso <- sum(esteso$residui^2)
parzialeDeltaRes <- devResRidotto-devResEsteso
Fempirico <- (parzialeDeltaRes/(length(esteso$beta)-length(ridotto$beta))) / (esteso$varianzaStimata)
GDLNUM <- length(esteso$beta)-length(ridotto$beta)
GDLDEN <- length(esteso$Y)-length(esteso$beta)
Fcrit <- qf(1-alpha,df1=GDLNUM,df2=GDLDEN)
if(displaytest){
cat("\nTEST DI IPOTESI:\n")
cat("Contributo parziale: ",parzialeDeltaRes,"\n")
cat("Fempirico: ",Fempirico,"\n")
cat("Fteorico: ",Fcrit,"\n")
cat("gradi di libert: (",GDLNUM,",",GDLDEN,")\n")
if(Fempirico>Fcrit) cat("\nRifiutare H0 con ampiezza",alpha,"\n") else cat("\nNon rifiutare H0 con ampiezza",alpha,"\n")
}
}    


###################################################
### chunk number 2: 
###################################################
data(esercizio.5.3.1)
names(esercizio.5.3.1) <- c("T","V","P")
dataDF <- esercizio.5.3.1


###################################################
### chunk number 3: 5-3-1-risposta1a
###################################################
options(contrasts=c("contr.treatment","contr.poly"))
dataDF$T <- as.factor(dataDF$T) 
dataDF$V <- as.factor(dataDF$V)
vY <- dataDF$P
m1 <- aov(formula=P ~ T * V, data=dataDF)
cat("aov(formula = P ~ T + V + T : V)\n")


###################################################
### chunk number 4: 5-3-1-risposta1b
###################################################
tmp <- model.matrix(m1)
dimnames(tmp)[[2]][1] <- "beta0"
tmp


###################################################
### chunk number 5: 5-3-1-risposta2
###################################################
matrix(coef(m1),ncol=1,dimnames=list(names(coef(m1)),character(1)))
matX <- as.matrix(tmp)
res <- FLinearMod(vY,matX)
cat("Stima della Varianza: ",res$varianzaStimata,"\n")


###################################################
### chunk number 6: 5-3-1-risposta3
###################################################
anova(m1)
cat("Fteorico con gradi di libert (",3,",",11,"): ",qf(0.99,3,11),"\n")
cat("Fteorico con gradi di libert (",1,",",11,"): ",qf(0.99,1,11),"\n")


###################################################
### chunk number 7: 5-3-1-risposta4
###################################################
qqnorm(res$residui)
qqline(res$residui,col=2)


###################################################
### chunk number 8: 5-3-2-risposta0
###################################################
dataDF <- esercizio.5.3.1
plot(dataDF)


###################################################
### chunk number 9: 5-3-2-risposta1
###################################################
vY <- dataDF$P
matX <- cbind(beta0=1,T = dataDF$T)
modT <- FLinearMod(vY,matX)
matrix(modT$beta[,1],nrow=length(modT$beta[,1]),dimnames=list(rownames(modT$beta),character(1)))
cat("Varianza stimata: ",modT$varianzaStimata,"\n")


###################################################
### chunk number 10: 5-3-2-risposta2
###################################################
matX <- cbind(beta0=1,V = dataDF$V)
modV <- FLinearMod(vY,matX)
matrix(c(modV$beta[1,1],modV$beta[2,1]),nrow=2,dimnames=list(c("beta0","V"),character(1)))
cat("Varianza stimata: ",modV$varianzaStimata,"\n")


###################################################
### chunk number 11: 5-3-2-risposta3
###################################################
matR <- cbind(beta0=1,T = dataDF$T,V = dataDF$V)
matE <- cbind(beta0=1,T=dataDF$T,V=dataDF$V,TV=dataDF$T*dataDF$V)
ridotto <- FLinearMod(vY,matR)
esteso <- FLinearMod(vY,matE)
prova(ridotto,esteso,displayridotto=F,displayesteso=T,displaytest=F,alpha=0.05)


###################################################
### chunk number 12: 5-3-2-risposta4
###################################################
alpha <- 1-0.97
estrattore <-2
cat("1-alpha: ",1-alpha,"\n")
elle1 <- ridotto$beta[estrattore, ]-qt(1-alpha/2,df=16-3)*sqrt(ridotto$varianzaStimata*ridotto$inversaXTX[estrattore,estrattore])
elle2 <- ridotto$beta[estrattore, ]+qt(1-alpha/2,df=16-3)*sqrt(ridotto$varianzaStimata*ridotto$inversaXTX[estrattore,estrattore])
cat("Intervallo di confidenza per beta1: (",elle1,",",elle2,")\n")
estrattore <-3
elle1 <- ridotto$beta[estrattore, ]-qt(1-alpha/2,df=16-3)*sqrt(ridotto$varianzaStimata*ridotto$inversaXTX[estrattore,estrattore])
elle2 <- ridotto$beta[estrattore, ]+qt(1-alpha/2,df=16-3)*sqrt(ridotto$varianzaStimata*ridotto$inversaXTX[estrattore,estrattore])
cat("Intervallo di confidenza per beta2: (",elle1,",",elle2,")\n")


###################################################
### chunk number 13: 5-3-2-risposta5
###################################################
m1 <- lm(P ~ T+V, data=dataDF)
previsione <- predict(m1,data.frame(T=27,V=2))
cat("E[P | T = 27, V = 2] = ",previsione,"\n")


###################################################
### chunk number 14: 5-3-2-risposta6
###################################################
xfuturo <- cbind(1,27,2)
attesa <- xfuturo%*%ridotto$beta
alpha <- 1-0.95
cat("1-alpha: ",1-alpha,"\n")
elle1 <- attesa-qt(1-alpha/2,df=16-3)*sqrt(ridotto$varianzaStimata)*sqrt(1 + xfuturo %*% ridotto$inversaXTX %*%t(xfuturo))
elle2 <- attesa+qt(1-alpha/2,df=16-3)*sqrt(ridotto$varianzaStimata)*sqrt(1 + xfuturo %*% ridotto$inversaXTX %*%t(xfuturo))
cat("Intervallo di previsione per la media condizionata: (",elle1,",",elle2,")\n")


###################################################
### chunk number 15: 
###################################################
data(esercizio.5.3.3)
dataDF  <- esercizio.5.3.3


###################################################
### chunk number 16: 5-3-3-risposta1
###################################################
vY <- dataDF$Y
matR <- cbind(beta0=1,X1 = dataDF$X1,X2 = dataDF$X2)
matE <- matX <- cbind(beta0=1,X1 = dataDF$X1,X2 = dataDF$X2,X12=dataDF$X1 * dataDF$X2)
ridotto <- FLinearMod(vY,matR)
esteso <- FLinearMod(vY,matE)
prova(ridotto,esteso,displayridotto=F,displayesteso=T,displaytest=F,alpha=0.05)


###################################################
### chunk number 17: 5-3-3-risposta2
###################################################
prova(ridotto,esteso,displayridotto=T,displayesteso=F,displaytest=T,alpha=0.05)


###################################################
### chunk number 18: 5-3-3-risposta2
###################################################
par(mfrow=c(2,2))
qqnorm(esteso$residui)
qqline(esteso$residui,col=2)
plot(matX[,2],esteso$residui)
plot(matX[,3],esteso$residui)
plot(esteso$attesa,esteso$residui)


###################################################
### chunk number 19: 
###################################################
enne <- 10000
minimo <- 1
massimo <- 10
x <- runif(enne,minimo,massimo)
epsilon <- rnorm(enne)
dataDF  <- data.frame(x,epsilon)


###################################################
### chunk number 20: 
###################################################
dataDF$Y <- 10 + 2*dataDF$x + dataDF$epsilon


###################################################
### chunk number 21: 5-3-4-risposta2
###################################################
plot(dataDF$x, dataDF$Y,pch=".")


###################################################
### chunk number 22: 5-3-4-risposta3
###################################################
plot(dataDF$x, dataDF$Y,pch=".")
abline(9.989,2.002,col=2,lwd=2 )


###################################################
### chunk number 23: 5-3-4-risposta4
###################################################
esteso <- lm(dataDF$Y ~ dataDF$x,dataDF)
residui <- residuals(esteso)
attesa <- fitted(esteso)
par(mfrow=c(2,1))
plot(attesa,residui)
plot(dataDF$x,residui)


###################################################
### chunk number 24: 5-3-4-risposta5
###################################################
devSTD <- sqrt(sum(residui^2)/(10000 - 2)) 
hist(residui,prob=T,main="Istogramma dei residui",ylab="Densit")
lines(seq(-5,5,0.05),dnorm(seq(-5,5,0.05),0,devSTD),col=2,lwd=2)


###################################################
### chunk number 25: 5-3-4-risposta6
###################################################
qqnorm(residui)
qqline(residui,col=2)


###################################################
### chunk number 26: 
###################################################
data(esercizio.5.3.5)
dataDF <- esercizio.5.3.5


###################################################
### chunk number 27: 5-3-5-risposta1
###################################################
vY <- cbind(esercizio.5.3.5$y)
matX <- cbind(beta0=1,x = esercizio.5.3.5$x)
esteso <- FLinearMod(vY,matX)
matrix(c(esteso$beta[1,1],esteso$beta[2,1]),nrow=2,dimnames=list(c("beta0","x"),character(1)))


###################################################
### chunk number 28: 5-3-5-risposta2
###################################################
xfuturo <- cbind(1,114.5)
attesa <- xfuturo %*% esteso$beta
alpha <- 1-0.95
cat("E[Y | x = 114.5] = ",attesa[1,1],"\n")
elle1 <- attesa - qt(1-alpha/2,df=3)*sqrt(esteso$varianzaStimata)*sqrt( xfuturo %*% esteso$inversaXTX %*%t(xfuturo))
elle2 <- attesa + qt(1-alpha/2,df=3)*sqrt(esteso$varianzaStimata)*sqrt( xfuturo %*% esteso$inversaXTX %*%t(xfuturo))
cat("1-alpha: ",1-alpha,"\n")
cat("Intervallo di confidenza per la media condizionata: (",elle1,",",elle2,")\n")


###################################################
### chunk number 29: 
###################################################
data(esercizio.5.3.6)
dataDF <- esercizio.5.3.6


###################################################
### chunk number 30: 5-3-6-risposta1
###################################################
vY <- cbind(dataDF$titolo)
matX <- cbind(beta0=1,x = dataDF$tempera)
esteso <- FLinearMod(vY,matX)
alpha <- 1-0.9
estrattore <-2
elle1 <- esteso$beta[estrattore, ] - qt(1-alpha/2,df=7-2 )*sqrt(esteso$varianzaStimata*esteso$inversaXTX[estrattore,estrattore])
elle2 <- esteso$beta[estrattore, ] + qt(1-alpha/2,df=7-2 )*sqrt(esteso$varianzaStimata*esteso$inversaXTX[estrattore,estrattore])
cat("1-alpha: ",1-alpha,"\n")
cat("Intervallo di confidenza per beta1: (",elle1,",",elle2,")\n")


###################################################
### chunk number 31: 5-3-6-risposta2
###################################################
xfuturo <- cbind(1,77)
attesa <- xfuturo %*% esteso$beta
cat("E[Y | x = 77] = ",attesa[1,1],"\n")
elle1 <- attesa - qt(1-alpha/2,df=5)*sqrt(esteso$varianzaStimata)*sqrt(xfuturo %*% esteso$inversaXTX %*%t(xfuturo))
elle2 <- attesa + qt(1-alpha/2,df=5)*sqrt(esteso$varianzaStimata)*sqrt(xfuturo %*% esteso$inversaXTX %*%t(xfuturo))
cat("1-alpha: ",1-alpha,"\n")
cat("Intervallo di confidenza per la media condizionata: (",elle1,",",elle2,")\n")


###################################################
### chunk number 32: 5-3-6-risposta3
###################################################
cat("Varianza stimata: ",esteso$varianzaStimata,"\n")


###################################################
### chunk number 33: 5-3-6-risposta4
###################################################
matR <- cbind(beta0=1,x = dataDF$tempera)
matE <- cbind(beta0=1,x = dataDF$tempera, x2= dataDF$tempera^2)
ridotto <- FLinearMod(vY,matR)
esteso <- FLinearMod(vY,matE)
prova(ridotto,esteso,displayridotto=T,displayesteso=T,displaytest=T,alpha=0.05)


###################################################
### chunk number 34: 
###################################################
data(esercizio.5.3.7)
dataDF <- esercizio.5.3.7


###################################################
### chunk number 35: 5-3-7-risposta1
###################################################
plot(dataDF$X,dataDF$Y,xlab="X",ylab="Y",main="Diagramma di dispersione")


###################################################
### chunk number 36: 5-3-7-risposta2
###################################################
cat("Y = beta0 + beta1 * x + epsilon\n")


###################################################
### chunk number 37: 5-3-7-risposta3
###################################################
vY <- cbind(dataDF$Y)
matX <- cbind(beta0=1,x = dataDF$X)
ridotto <- FLinearMod(vY,matX)
matrix(c(ridotto$beta[1,1],ridotto$beta[2,1]),nrow=2,dimnames=list(c("beta0","x"),character(1)))
cat("Varianza stimata: ",ridotto$varianzaStimata,"\n")


###################################################
### chunk number 38: 5-3-7-risposta4
###################################################
plot(dataDF$X,dataDF$Y,xlab="X",ylab="Y",main="Diagramma di dispersione")
abline(ridotto$beta[1,1],ridotto$beta[2,1],col=2,lwd=2)


###################################################
### chunk number 39: 5-3-7-risposta5a
###################################################
vY <- cbind(dataDF$Y)
matR <- cbind(beta0=1,x = dataDF$X,x2 = dataDF$X^2)
matE <- cbind(beta0=1,x = dataDF$X,x2 = dataDF$X^2,x3 = dataDF$X^3)
ridotto <- FLinearMod(vY,matR)
esteso <- FLinearMod(vY,matE)
prova(ridotto,esteso,displayridotto=T,displayesteso=T,displaytest=T,alpha=0.05)


###################################################
### chunk number 40: 5-3-7-risposta5b
###################################################
vY <- cbind(dataDF$Y)
matR <- cbind(beta0=1,x = dataDF$X)
matE <- cbind(beta0=1,x = dataDF$X,x2 = dataDF$X^2)
ridotto <- FLinearMod(vY,matR)
esteso <- FLinearMod(vY,matE)
prova(ridotto,esteso,displayridotto=T,displayesteso=T,displaytest=T,alpha=0.05)


###################################################
### chunk number 41: 5-3-7-risposta6
###################################################
par(mfrow=c(2,2))
qqnorm(esteso$residui)
qqline(esteso$residui,col=2,lwd=2)
plot(esteso$X[,2],esteso$residui)
plot(esteso$X[,3],esteso$residui)
plot(esteso$attesa,esteso$residui)


###################################################
### chunk number 42: 
###################################################
data(esercizio.5.3.8)
dataDF <- esercizio.5.3.8


###################################################
### chunk number 43: 5-3-8-risposta1
###################################################
cat("aov(formula = Y ~ dose)\n")
vY <- dataDF$Y
matE <- model.matrix(lm(Y ~ dose,dataDF))
esteso <- FLinearMod(vY,matE)
matR <-  model.matrix(lm(Y ~ 1,dataDF))
ridotto <- FLinearMod(vY,matR)
prova(ridotto,esteso,displayridotto=F,displayesteso=F,displaytest=T,alpha=0.05)


###################################################
### chunk number 44: 5-3-8-risposta2
###################################################
prova(ridotto,esteso,displayridotto=F,displayesteso=F,displaytest=T,alpha=0.01)


###################################################
### chunk number 45: 5-3-8-risposta3a
###################################################
matX <-  model.matrix(lm(Y ~ dose,dataDF))
esteso <- FLinearMod(vY,matX)
QME <- esteso$varianzaStimata
matX <-  cbind(rep(1,9),c(0,0,0,1,1,1,1,1,1))
ridotto <- FLinearMod(vY,matX)
prova(ridotto,esteso,displayridotto=F,displayesteso=F,displaytest=T,alpha=0.05)


###################################################
### chunk number 46: 5-3-8-risposta3b
###################################################
vY <- ridotto$Y
matX <- cbind(rep(1,9))
ridottissimo <- FLinearMod(vY,matX)
prova(ridottissimo,ridotto,displayridotto=F,displayesteso=F,displaytest=T,alpha=0.05)


###################################################
### chunk number 47: 5-3-8-risposta4
###################################################
X <- as.numeric(dataDF$dose)-1
matX <- model.matrix(lm(Y ~ X,data=dataDF))
colnames(matX)<-c("beta0","X")
regSem <- FLinearMod(vY,matX)
matrix(regSem$beta[,1],nrow=length(regSem$beta),dimnames=list(colnames(matX),character(1)))


###################################################
### chunk number 48: 5-3-8-risposta5
###################################################
plot(matX[,2],vY)
abline(regSem$beta[1,1],regSem$beta[2,1],col=2,lwd=2)


###################################################
### chunk number 49: 
###################################################
data(esercizio.5.3.9)
dataDF <- esercizio.5.3.9


###################################################
### chunk number 50: 5-3-9-risposta1a
###################################################
options(digits=7)
summary(dataDF$X)
cat("Varianza stimata: ",var(dataDF$X),"\n")


###################################################
### chunk number 51: 5-3-9-risposta1b
###################################################
summary(dataDF$X[dataDF$tempo=="1"])
cat("Varianza stimata: ",var(dataDF$X[dataDF$tempo=="1"]),"\n")


###################################################
### chunk number 52: 5-3-9-risposta1c
###################################################
summary(dataDF$X[dataDF$tempo=="2"])
cat("Varianza stimata: ",var(dataDF$X[dataDF$tempo=="2"]),"\n")


###################################################
### chunk number 53: 5-3-9-risposta1d
###################################################
summary(dataDF$X[dataDF$tempo=="3"])
cat("Varianza stimata: ",var(dataDF$X[dataDF$tempo=="3"]),"\n")
options(digits=5)


###################################################
### chunk number 54: 5-3-9-risposta2
###################################################
par(mfrow=c(1,3))
qqnorm(dataDF$X[dataDF$tempo=="1"])
qqline(dataDF$X[dataDF$tempo=="1"])
qqnorm(dataDF$X[dataDF$tempo=="2"])
qqline(dataDF$X[dataDF$tempo=="2"])
qqnorm(dataDF$X[dataDF$tempo=="3"])
qqline(dataDF$X[dataDF$tempo=="3"])


###################################################
### chunk number 55: 5-3-9-risposta3a
###################################################
par(mfrow=c(1,3))
dataDF$Y <- sqrt(dataDF$X)
qqnorm(dataDF$Y[dataDF$tempo=="1"])
qqline(dataDF$Y[dataDF$tempo=="1"])
qqnorm(dataDF$Y[dataDF$tempo=="2"])
qqline(dataDF$Y[dataDF$tempo=="2"])
qqnorm(dataDF$Y[dataDF$tempo=="3"])
qqline(dataDF$Y[dataDF$tempo=="3"])


###################################################
### chunk number 56: 5-3-9-risposta3b
###################################################
par(mfrow=c(1,3))
dataDF$Z <- log(dataDF$X)
qqnorm(dataDF$Z[dataDF$tempo=="1"])
qqline(dataDF$Z[dataDF$tempo=="1"])
qqnorm(dataDF$Z[dataDF$tempo=="2"])
qqline(dataDF$Z[dataDF$tempo=="2"])
qqnorm(dataDF$Z[dataDF$tempo=="3"])
qqline(dataDF$Z[dataDF$tempo=="3"])


###################################################
### chunk number 57: 5-3-9-risposta4
###################################################
vY <- dataDF$Z
matE <- model.matrix(lm(Z ~ factor(tempo),dataDF))
matR <- matE[,-c(2,3)]
ridotto <- FLinearMod(vY,matR)
esteso <- FLinearMod(vY,matE)
prova(ridotto,esteso,displayridotto=F,displayesteso=F,displaytest=T,alpha=0.01)


###################################################
### chunk number 58: 
###################################################
data(esercizio.5.3.10)
dataDF <- esercizio.5.3.10


###################################################
### chunk number 59: 5-3-10-risposta1
###################################################
vY <- dataDF$tempera
matR <- cbind(beta0 = 1, secondi =dataDF$secondi)
ridotto <- FLinearMod(vY,matR)
matrix(ridotto$beta[,1],nrow=length(ridotto$beta),dimnames=list(colnames(matR),character(1)))


###################################################
### chunk number 60: 5-3-10-risposta2
###################################################
par(mfrow=c(2,2))
qqnorm(ridotto$residui)
qqline(ridotto$residui,col=2,lwd=2)
plot(ridotto$X[,2],ridotto$residui)
abline(0,0,col=3,lwd=2)
plot(ridotto$attesa,ridotto$residui)
abline(0,0,col=3,lwd=2)


###################################################
### chunk number 61: 5-3-10-risposta3
###################################################
dataDF$secondi2 <- dataDF$secondi**2
matE <- cbind(beta0=1, secondi=dataDF$secondi, secondi2=dataDF$secondi2)
esteso <- FLinearMod(vY,matE)
prova(ridotto,esteso,displayridotto=T,displayesteso=T,displaytest=T,alpha=0.01)


###################################################
### chunk number 62: 5-3-10-risposta4
###################################################
vY <- dataDF$tempera
matE <- model.matrix(lm(tempera ~ factor(dispensatore),dataDF))
names(matE)<-c("beta0","dispensatore2","dispensatore3","dispensatore4")
matR <- matE[,1]
ridotto <- FLinearMod(vY,matR)
esteso <- FLinearMod(vY,matE)
prova(ridotto,esteso,displayridotto=F,displayesteso=F,displaytest=T,alpha=0.05)


###################################################
### chunk number 63: 5-3-10-risposta5
###################################################
matE <- cbind(beta0=1, secondi=dataDF$secondi, secondi2=dataDF$secondi2)
esteso <- FLinearMod(vY,matE)
attesa <- cbind(1,250,250^2) %*% esteso$beta
cat("E[tempera | secondi = 250, secondi2 = 250^2] = ",attesa,"\n")


###################################################
### chunk number 64: 5-3-10-risposta6
###################################################
xfuturo <- cbind(1, 17.7,17.7^2)
attesa <- cbind(1,17.7,17.7^2) %*% esteso$beta
alpha <- 1-0.95
cat("1-alpha: ",1-alpha,"\n")
elle1 <- attesa - qt(1-alpha/2,df=length(vY)-length(esteso$beta))*sqrt(esteso$varianzaStimata)*sqrt(1 + xfuturo %*% esteso$inversaXTX %*%t(xfuturo))
elle2 <- attesa + qt(1-alpha/2,df=length(vY)-length(esteso$beta))*sqrt(esteso$varianzaStimata)*sqrt(1 + xfuturo %*% esteso$inversaXTX %*%t(xfuturo))
cat("Intervallo di previsione per la media condizionata: (",elle1,",",elle2,")\n")


###################################################
### chunk number 65: 
###################################################
data(esercizio.5.3.11)
dataDF <-  esercizio.5.3.11


###################################################
### chunk number 66: 5-3-11-risposta1
###################################################
summary(dataDF)


###################################################
### chunk number 67: 5-3-11-risposta2
###################################################
vY <- dataDF$polifenoli
matX <- cbind(beta0 = 1, X =dataDF$flavo)
esteso <- FLinearMod(vY,matX)
matrix(esteso$beta[,1],nrow=length(esteso$beta),dimnames=list(colnames(matX),character(1)))


###################################################
### chunk number 68: 5-3-11-risposta3
###################################################
plot(dataDF$flavo,dataDF$polifenoli)
abline(esteso$beta,col=2,lwd=2)


###################################################
### chunk number 69: 5-3-11-risposta4a
###################################################
cooks.distance(lm(polifenoli~flavo,data=dataDF))


###################################################
### chunk number 70: 5-3-11-risposta4b
###################################################
plot(cooks.distance(lm(polifenoli~flavo,data=dataDF)),type="b",ylab="Distanza di Cook")


###################################################
### chunk number 71: 5-3-11-risposta5
###################################################
par(mfrow=c(2,2))
qqnorm(esteso$residui)
qqline(esteso$residui,col=2,lwd=2)
plot(esteso$X[,2],esteso$residui)
abline(0,0,col=3,lwd=2)
plot(esteso$attesa,esteso$residui)
abline(0,0,col=3,lwd=2)


###################################################
### chunk number 72: 
###################################################
data(esercizio.4.4.13)
dataDF <- esercizio.4.4.13


###################################################
### chunk number 73: 5-3-13-risposta1
###################################################
cat("Parametrizzazione a trattamento (corner):\n")
matXt <- model.matrix(~A*S,dataDF,contrasts=list(A="contr.treatment",S="contr.treatment"))
matXt
matXs <- model.matrix(~A*S,dataDF,contrasts=list(A="contr.sum",S="contr.sum"))
cat("Parametrizzazione a media a somma nulla:\n")
matXs
cat("Parametrizzazione a media di cella:\n")
matXm <- model.matrix(~-1+code,dataDF,contrasts=list(code="contr.treatment"))
matXm


###################################################
### chunk number 74: 5-3-13-risposta2
###################################################
vY <- dataDF$Y
matE <- matXt
esteso <- FLinearMod(vY,matE)
matR <- matE[,-c(5,6)]
ridotto <- FLinearMod(vY,matR)
prova(ridotto,esteso,displayridotto=T,displayesteso=T,displaytest=T,alpha=0.01)


###################################################
### chunk number 75: 5-3-13-risposta3
###################################################
xfuturo <- cbind(1, 1,0,0)
attesa <- xfuturo %*% ridotto$beta
cat("Attesa: ",attesa,"\n")
alpha <- 1-0.95
cat("1-alpha: ",1-alpha,"\n")
elle1 <- attesa - qt(1-alpha/2,df=14)*sqrt(ridotto$varianzaStimata)*sqrt(xfuturo %*% ridotto$inversaXTX %*%t(xfuturo))
elle2 <- attesa + qt(1-alpha/2,df=14)*sqrt(ridotto$varianzaStimata)*sqrt(xfuturo %*% ridotto$inversaXTX %*%t(xfuturo))
cat("Intervallo di previsione per la media condizionata: (",elle1,",",elle2,")\n")


###################################################
### chunk number 76: 
###################################################
data(esercizio.5.3.14)
dataDF <- esercizio.5.3.14


###################################################
### chunk number 77: 5-3-14-risposta1
###################################################
summary(esercizio.5.3.14$caloria)
cat("Varianza stimata: ",var(esercizio.5.3.14$caloria),"\n")


###################################################
### chunk number 78: 5-3-14-risposta2
###################################################
dataDF$fibraQ <- cut(dataDF$fibra,breaks=23:27,include.lowest=T)
table(dataDF$fibraQ)


###################################################
### chunk number 79: 5-3-14-risposta3
###################################################
boxplot(dataDF$caloria~dataDF$fibraQ,ylab="caloria",xlab="Classe-fibra")


###################################################
### chunk number 80: 5-3-14-risposta5
###################################################
cat("lm(caloria~(fibra+grass+carboidrat)^3)\n")


###################################################
### chunk number 81: 5-3-14-risposta6
###################################################
esteso <- lm(caloria~(fibra+grass+carboidrat)^3,data=dataDF)
modStep <- step(esteso,direction="backward",trace=0)
summary(modStep)


###################################################
### chunk number 82: 5-3-14-risposta7
###################################################
residui <- residuals(modStep)
attesa <- fitted(modStep)
par(mfrow=c(3,2))
qqnorm(residui)
qqline(residui,col=2,lwd=2)
plot(dataDF$fibra,residui)
abline(0,0,col=3,lwd=2)
plot(dataDF$carboidrat,residui)
abline(0,0,col=3,lwd=2)
plot(dataDF$grass,residui)
abline(0,0,col=3,lwd=2)
plot(attesa,residui)
abline(0,0,col=3,lwd=2)


###################################################
### chunk number 83: 5-3-14-risposta8
###################################################
attesa <- predict(modStep,data.frame(fibra=26.5,grass=89.5,carboidrat=120),interval="prediction",level=1-alpha)[[1]]
cat("E[caloria | fibra = 26.5, grass = 89.5, carboidrat = 120] = ",attesa,"\n")
alpha <- 1-0.98
cat("1-alpha: ",1-alpha,"\n")
elle1 <- predict(modStep,data.frame(fibra=26.5,grass=89.5,carboidrat=120),interval="prediction",level=1-alpha)[[2]]
elle2 <- predict(modStep,data.frame(fibra=26.5,grass=89.5,carboidrat=120),interval="prediction",level=1-alpha)[[3]]
cat("Intervallo di previsione per la media condizionata: (",elle1,",",elle2,")\n")


###################################################
### chunk number 84: 
###################################################
data(esercizio.5.3.15)
dataDF <- esercizio.5.3.15


###################################################
### chunk number 85: 5-3-15-risposta1
###################################################
plot(dataDF$X,dataDF$Y) 
points(dataDF$X,dataDF$Y,col=as.numeric(dataDF$Z)+2)
points(dataDF$X,dataDF$Y,pch=".")


###################################################
### chunk number 86: 5-3-15-risposta2
###################################################
vY <- dataDF$Y
matX <- cbind(beta0 = 1, X =dataDF$X)
ridotto <- FLinearMod(vY,matX)
matrix(ridotto$beta,ncol=1,dimnames=list(rownames(ridotto$beta),character(1)))
xfuturo <- cbind(1, 38.5)
attesa <- xfuturo %*% ridotto$beta
cat("E[Y | x = 38.5] = ",attesa[1,1],"\n")
alpha <- 1-0.95
cat("1-alpha: ",1-alpha,"\n")
elle1 <- attesa - qt(1-alpha/2,df=length(vY)-length(ridotto$beta))*sqrt(ridotto$varianzaStimata)*sqrt(xfuturo %*% ridotto$inversaXTX %*%t(xfuturo))
elle2 <- attesa + qt(1-alpha/2,df=length(vY)-length(ridotto$beta))*sqrt(ridotto$varianzaStimata)*sqrt(xfuturo %*% ridotto$inversaXTX %*%t(xfuturo))
cat("Intervallo di previsione per la media condizionata: (",elle1,",",elle2,")\n")


###################################################
### chunk number 87: 5-3-15-risposta3
###################################################
plot(dataDF$X,dataDF$Y) 
abline(ridotto$beta[1,1],ridotto$beta[2,1],col=4,lwd=2)


###################################################
### chunk number 88: 5-3-15-risposta4
###################################################
cat("Modello con interazione:\n")
vY <- dataDF$Y
matX <- cbind(beta0=1,X=dataDF$X,Z=dataDF$Z,XZ=dataDF$X*dataDF$Z)
esteso <- FLinearMod(vY,matX)
matrix(esteso$beta,ncol=1,dimnames=list(rownames(esteso$beta),character(1)))
cat("Modello comune:\n")
vY <- dataDF$Y
matrix(ridotto$beta,ncol=1,dimnames=list(rownames(ridotto$beta),character(1)))
cat("Regressione specifica gruppo Z = 0:\n")
m0 <- lm(dataDF$Y[dataDF$Z=="0"]~dataDF$X[dataDF$Z=="0"])
coefficientiZ0 <- as.vector(coef(m0))
names(coefficientiZ0)<-c("beta0","X")
matrix(coefficientiZ0,ncol=1,dimnames=list(names(coefficientiZ0),character(1)))
cat("Regressione specifica gruppo Z = 1:\n")
m1 <- lm(dataDF$Y[dataDF$Z=="1"]~dataDF$X[dataDF$Z=="1"])
coefficientiZ1 <- as.vector(coef(m1))
names(coefficientiZ1)<-c("beta0","X")
matrix(coefficientiZ1,ncol=1,dimnames=list(names(coefficientiZ1),character(1)))


###################################################
### chunk number 89: 5-3-15-risposta5
###################################################
plot(dataDF$X,dataDF$Y) 
points(dataDF$X,dataDF$Y,col=as.numeric(dataDF$Z)+2)
points(dataDF$X,dataDF$Y,pch=".")
abline(coef(m0),col=4,lwd=2)
abline(coef(m1),col=4,lwd=2)


###################################################
### chunk number 90: 5-3-15-risposta6
###################################################
vY <- dataDF$Y
matX <- cbind(beta0 = 1, X =dataDF$X,Z =dataDF$Z)
ridotto <- FLinearMod(vY,matX)
matX <- cbind(beta0=1,X=dataDF$X,Z=dataDF$Z,XZ=dataDF$X*dataDF$Z)
esteso <- FLinearMod(vY,matX)
prova(ridotto,esteso,displayridotto=T,displayesteso=T,displaytest=T,alpha=0.05)


###################################################
### chunk number 91: 5-3-15-risposta7
###################################################
cat("lm(formula = Y ~ X + Z + X : Z)\n")


###################################################
### chunk number 92: 5-3-15-risposta8
###################################################
par(mfrow=c(2,2))
residui <- esteso$residui
qqnorm(residui)
qqline(residui,col=2,lwd=2)
plot(dataDF$X,residui)
abline(0,0,col=3,lwd=2)
plot(dataDF$Z,residui)
abline(0,0,col=3,lwd=2)
plot(esteso$attesa,residui)
abline(0,0,col=3,lwd=2)


###################################################
### chunk number 93: 
###################################################
data(esercizio.5.3.16)
dataDF <- esercizio.5.3.16


###################################################
### chunk number 94: 5-3-16-risposta1
###################################################
esteso <- lm(pH~conservante*correttore*esaltatore-conservante:correttore:esaltatore,data=dataDF)
matrix(coefficients(esteso),ncol=1,dimnames=list(names(coefficients(esteso)),character(1)))


###################################################
### chunk number 95: 5-3-16-risposta2
###################################################
aggiornato <- update(esteso,.~. -correttore:esaltatore
                                -conservante:correttore
                                -conservante:esaltatore
                                -correttore)
cat("lm(formula = Ph ~ conservante + esaltatore)\n")


###################################################
### chunk number 96: 5-3-16-risposta3
###################################################
Anova(aggiornato,,type="III")


###################################################
### chunk number 97: 5-3-16-risposta4
###################################################
par(mfrow=c(2,2))
residui <- aggiornato$residuals
attesa <- fitted(esteso)
qqnorm(residui)
qqline(residui,col=2,lwd=2)
plot(dataDF$conservante,residui)
abline(0,0,col=3,lwd=2)
title("Conservante")
plot(dataDF$esaltatore,residui)
abline(0,0,col=3,lwd=2)
title("Esaltatore") 
plot(attesa,residui)
abline(0,0,col=3,lwd=2)


