###################################################
### chunk number 1: preliminaries
###################################################
library("LIM")
options(prompt = "> ")
options(width=70)


###################################################
### chunk number 2: 
###################################################
pars<-Ldei(LIMEcoli)


###################################################
### chunk number 3: 
###################################################
LP<-Linp(LIMEcoli)


###################################################
### chunk number 4: 
###################################################
LP$X <- LP$X[1,]


###################################################
### chunk number 5: 
###################################################
xr<-Xranges(LIMEcoli)


###################################################
### chunk number 6: 
###################################################
data.frame(simplest=pars$X, optimal=LP$X, xr)


###################################################
### chunk number 7: range
###################################################
par(mfrow=c(1,2))
nr <- LIMEcoli$NUnknowns
ii <- 1:(nr/2)
dotchart(LP$X[ii],xlim = range(xr),pch=16,cex=0.8)
segments(xr[ii,1],1:nr,xr[ii,2],1:nr)
ii <- (nr/2+1):nr
dotchart(LP$X[ii],xlim = range(xr),pch=16,cex=0.8)
segments(xr[ii,1],1:nr,xr[ii,2],1:nr)
mtext(side= 3, cex=1.5, outer = TRUE, line=-1.5,
      "E coli Core Metabolism, optimal solution and ranges")


###################################################
### chunk number 8: figrange
###################################################
par(mfrow=c(1,2))
nr <- LIMEcoli$NUnknowns
ii <- 1:(nr/2)
dotchart(LP$X[ii],xlim = range(xr),pch=16,cex=0.8)
segments(xr[ii,1],1:nr,xr[ii,2],1:nr)
ii <- (nr/2+1):nr
dotchart(LP$X[ii],xlim = range(xr),pch=16,cex=0.8)
segments(xr[ii,1],1:nr,xr[ii,2],1:nr)
mtext(side= 3, cex=1.5, outer = TRUE, line=-1.5,
      "E coli Core Metabolism, optimal solution and ranges")


###################################################
### chunk number 9: 
###################################################
print(system.time(
  xs<-Xsample(LIMEcoli,iter=1000,type="mirror",test=TRUE)  #))
))
  


###################################################
### chunk number 10: sample
###################################################
  pairs(xs[,1:12],pch=".",cex=2, gap=0, upper.panel = NULL)


###################################################
### chunk number 11: figsample
###################################################
  pairs(xs[,1:12],pch=".",cex=2, gap=0, upper.panel = NULL)


