### Name: Schur
### Title: Schur Decomposition of a Matrix
### Aliases: Schur Schur,dgeMatrix,logical-method
###   Schur,dgeMatrix,missing-method Schur,diagonalMatrix,logical-method
###   Schur,diagonalMatrix,missing-method
###   Schur,triangularMatrix,logical-method
###   Schur,triangularMatrix,missing-method Schur,dsyMatrix,ANY-method
###   Schur,generalMatrix,ANY-method Schur,symmetricMatrix,ANY-method
### Keywords: algebra

### ** Examples

Schur(Hilbert(9))              # Schur factorization (real eigenvalues)

(A <- Matrix(round(rnorm(5*5, sd = 100)), nrow = 5))
(Sch.A <- Schur(A))

eTA <- eigen(Sch.A@T)
str(SchA <- Schur(A, vectors=FALSE))# no 'T' ==> simple list
stopifnot(all.equal(eTA$values, eigen(A)$values, tol = 1e-13),
          all.equal(eTA$values,
                    local({z <- Sch.A@EValues
                           z[order(Mod(z), decreasing=TRUE)]}), tol = 1e-13),
          identical(SchA$T, Sch.A@T),
          identical(SchA$EValues, Sch.A@EValues))



