### Name: chol
### Title: Choleski Decomposition - 'Matrix' S4 Generic
### Aliases: chol chol-methods chol,Matrix-method chol,ddenseMatrix-method
###   chol,dgeMatrix-method chol,dpoMatrix-method chol,dppMatrix-method
###   chol,ddiMatrix-method chol,ldiMatrix-method chol,dsparseMatrix-method
###   chol,dsCMatrix-method chol,dsCMatrix-method chol,lsCMatrix-method
###   chol,lsCMatrix-method chol,nsCMatrix-method chol,nsCMatrix-method
### Keywords: algebra array

### ** Examples

showMethods(chol, inherited = FALSE) # show different methods

sy2 <- new("dsyMatrix", Dim = as.integer(c(2,2)), x = c(14, NA,32,77))
(c2 <- chol(sy2))#-> "Cholesky" matrix
stopifnot(all.equal(c2, chol(as(sy2, "dpoMatrix")), tol= 1e-13))
str(c2)

## An example where chol() can't work
(sy3 <- new("dsyMatrix", Dim = as.integer(c(2,2)), x = c(14, -1, 2, -7)))
try(chol(sy3)) # error, since it is not positive definite



