### Name: contrast
### Title: Contrast Matrices, Optionally Sparse
### Aliases: contr.helmert contr.poly contr.sum contr.treatment contr.SAS
### Keywords: design regression array

### ** Examples

(cH <- contr.helmert(4))
apply(cH, 2,sum) # column sums are 0!
crossprod(cH) # diagonal -- columns are orthogonal
contr.helmert(4, contrasts = FALSE) # just the 4 x 4 identity matrix

(cT <- contr.treatment(5))
all(crossprod(cT) == diag(4)) # TRUE: even orthonormal

cT. <- contr.SAS(5)
all(crossprod(cT.) == diag(4))# TRUE
(cS. <- contr.SAS(5, sparse = TRUE))
all(cT. == cS.)

(cP <- contr.poly(3)) # Linear and Quadratic
zapsmall(crossprod(cP), digits=15) # orthonormal up to fuzz



