### Name: dgTMatrix-class
### Title: Sparse matrices in triplet form
### Aliases: dgTMatrix-class +,dgTMatrix,dgTMatrix-method
###   coerce,dgTMatrix,dgCMatrix-method coerce,dgTMatrix,dgeMatrix-method
###   coerce,dgTMatrix,matrix-method coerce,dgTMatrix,dtCMatrix-method
###   coerce,dgTMatrix,dsTMatrix-method coerce,dgTMatrix,dtTMatrix-method
###   coerce,dgTMatrix,triangularMatrix-method
###   coerce,dgeMatrix,dgTMatrix-method coerce,matrix,dgTMatrix-method
###   crossprod,dgTMatrix,missing-method crossprod,dgTMatrix,matrix-method
###   crossprod,dgTMatrix,numeric-method
### Keywords: classes algebra

### ** Examples

m <- Matrix(0+1:28, nrow = 4)
m[-3,c(2,4:5,7)] <- m[ 3, 1:4] <- m[1:3, 6] <- 0
(mT <- as(m, "dgTMatrix"))
str(mT)
mT[1,]
mT[4, drop = FALSE]
stopifnot(identical(mT[lower.tri(mT)],
                    m [lower.tri(m) ]))
mT[lower.tri(mT,diag=TRUE)] <- 0
mT



