### Name: drop0
### Title: Drop "Explicit Zeroes" from a Sparse Matrix
### Aliases: drop0
### Keywords: utilities array

### ** Examples

m <- spMatrix(10,20, i= 1:8, j=2:9,
              x = c(0:2,3:-1))
m
drop0(m)

## A larger example:
t5 <- new("dtCMatrix", Dim = c(5L, 5L), uplo = "L",
          x = c(10, 1, 3, 10, 1, 10, 1, 10, 10),
          i = c(0L,2L,4L, 1L, 3L,2L,4L, 3L, 4L),
          p = c(0L, 3L, 5L, 7:9))
TT <- kronecker(t5, kronecker(kronecker(t5,t5), t5))
IT <- solve(TT)
I. <- TT %*% IT ;  nnzero(I.) # 697 ( = 625 + 72 )
I.0 <- drop0(zapsmall(I.))
stopifnot(all(I.0 == Diagonal(625)))



