### Name: dtCMatrix-class
### Title: Triangular, (compressed) sparse column matrices
### Aliases: dtCMatrix-class dtTMatrix-class
###   coerce,dtCMatrix,dgCMatrix-method coerce,dtCMatrix,dgeMatrix-method
###   coerce,dtCMatrix,dgTMatrix-method coerce,dtCMatrix,dsCMatrix-method
###   coerce,dtCMatrix,dtTMatrix-method coerce,dtCMatrix,dtrMatrix-method
###   coerce,dtCMatrix,ltCMatrix-method coerce,dtCMatrix,ntCMatrix-method
###   coerce,dtCMatrix,TsparseMatrix-method
###   coerce,dtTMatrix,dgTMatrix-method coerce,dtTMatrix,dgeMatrix-method
###   coerce,dtTMatrix,dtCMatrix-method coerce,dtTMatrix,dtrMatrix-method
###   coerce,dtTMatrix,generalMatrix-method coerce,dtTMatrix,matrix-method
###   coerce,matrix,dtCMatrix-method coerce,matrix,dtTMatrix-method
###   Arith,dtCMatrix,dtCMatrix-method solve,dtCMatrix,matrix-method
###   solve,dtCMatrix,CsparseMatrix-method solve,dtCMatrix,dgeMatrix-method
###   solve,dtCMatrix,missing-method solve,dtCMatrix,numeric-method
###   t,dtCMatrix-method t,dtTMatrix-method
### Keywords: classes algebra

### ** Examples

showClass("dtCMatrix")

showClass("dtTMatrix")
t1 <- new("dtTMatrix", x= c(3,7), i= 0:1, j=3:2, Dim= as.integer(c(4,4)))
t1
## from  0-diagonal to unit-diagonal {low-level step}:
tu <- t1 ; tu@diag <- "U"
tu
(cu <- as(tu, "dtCMatrix"))
str(cu)# only two entries in @i and @x
stopifnot(cu@i == 1:0,
          all(2 * symmpart(cu) == Diagonal(4) + forceSymmetric(cu)))

t1[1,2:3] <- -1:-2
diag(t1) <- 10*c(1:2,3:2)
t1 # still triangular
(it1 <- solve(t1))
t1. <- solve(it1)
all(abs(t1 - t1.) < 10 * .Machine$double.eps)



