### Name: externalFormats
### Title: Read and write external matrix formats
### Aliases: readHB readMM writeMM writeMM,CsparseMatrix-method
###   writeMM,TsparseMatrix-method
### Keywords: IO array algebra

### ** Examples

str(pores <- readMM(system.file("external/pores_1.mtx",
                                package = "Matrix")))
str(utm <- readHB(system.file("external/utm300.rua",
                               package = "Matrix")))
str(lundA <- readMM(system.file("external/lund_a.mtx",
                                package = "Matrix")))
str(lundA <- readHB(system.file("external/lund_a.rsa",
                                package = "Matrix")))
## Not run: 
##D ## NOTE: The following examples take quite some time
##D ## ----  even on a fast internet connection:
##D if(FALSE) # the URL has been corrected, but we need an un-tar step!
##D str(sm <-
##D  readHB(gzcon(url("http://www.cise.ufl.edu/research/sparse/RB/Boeing/msc00726.tar.gz"))))
##D 
##D str(jgl009 <-
##D  readMM(gzcon(url("ftp://math.nist.gov/pub/MatrixMarket2/Harwell-Boeing/counterx/jgl009.mtx.gz"))))
## End(Not run)
data(KNex)
writeMM(KNex$mm, "mmMM.mtx")



