### Name: rcond
### Title: Estimate the Reciprocal Condition Number
### Aliases: rcond rcond,ANY,missing-method rcond,matrix,character-method
###   rcond,Matrix,character-method rcond,ldenseMatrix,character-method
###   rcond,ndenseMatrix,character-method
### Keywords: array algebra

### ** Examples

x <- Matrix(rnorm(9), 3, 3)
rcond(x)
## typically "the same" (with more computational effort):
1 / (norm(x) * norm(solve(x)))
rcond(Hilbert(9))  # should be about 9.1e-13

## For non-square matrices:
rcond(x1 <- cbind(1,1:10))# 0.05278
rcond(x2 <- cbind(x1, 2:11))# practically 0, since x2 does not have full rank

## sparse
(S1 <- Matrix(rbind(0:1,0, diag(3:-2))))
rcond(S1)
m1 <- as(S1, "denseMatrix")
all.equal(rcond(S1), rcond(m1))

## wide and sparse
rcond(Matrix(cbind(0, diag(2:-1))))



