### Name: sparseVector-class
### Title: Sparse Vector Classes
### Aliases: sparseVector-class dsparseVector-class isparseVector-class
###   lsparseVector-class nsparseVector-class zsparseVector-class
###   xsparseVector-class Arith,sparseVector,sparseVector-method
###   Arith,dsparseVector,dsparseVector-method
###   -,dsparseVector,missing-method !,sparseVector-method
###   Logic,sparseVector,sparseVector-method
###   Logic,lsparseVector,lsparseVector-method
###   Logic,nsparseVector,nsparseVector-method Ops,ANY,sparseVector-method
###   Ops,sparseVector,ANY-method Ops,sparseVector,sparseVector-method
###   Ops,sparseVector,atomicVector-method
###   Ops,atomicVector,sparseVector-method Ops,Matrix,sparseVector-method
###   Ops,sparseVector,Matrix-method Arith,ddenseMatrix,sparseVector-method
###   Arith,dgeMatrix,sparseVector-method
###   Arith,sparseVector,ddenseMatrix-method
###   Arith,sparseVector,dgeMatrix-method Logic,dMatrix,sparseVector-method
###   Logic,lMatrix,sparseVector-method Logic,nMatrix,sparseVector-method
###   Logic,sparseVector,dMatrix-method Logic,sparseVector,lMatrix-method
###   Logic,sparseVector,nMatrix-method Summary,sparseVector-method
###   Summary,nsparseVector-method coerce,ANY,sparseVector-method
###   coerce,TsparseMatrix,sparseVector-method
###   coerce,diagonalMatrix,sparseVector-method
###   coerce,sparseMatrix,sparseVector-method
###   coerce,atomicVector,sparseVector-method
###   coerce,atomicVector,dsparseVector-method
###   coerce,triangularVector,sparseVector-method
###   coerce,sparseVector,integer-method coerce,sparseVector,logical-method
###   coerce,sparseVector,numeric-method coerce,sparseVector,vector-method
###   coerce,nsparseVector,lsparseVector-method
###   coerce,nsparseVector,dsparseVector-method
###   coerce,nsparseVector,isparseVector-method
###   coerce,nsparseVector,zsparseVector-method
###   coerce,xsparseVector,dsparseVector-method
###   coerce,xsparseVector,isparseVector-method
###   coerce,xsparseVector,lsparseVector-method
###   coerce,xsparseVector,zsparseVector-method
###   coerce,xsparseVector,nsparseVector-method
###   as.logical,sparseVector-method as.numeric,sparseVector-method
###   as.vector,sparseVector,missing-method
###   as.vector,sparseVector,character-method dim<-,sparseVector-method
###   is.na,nsparseVector-method is.na,sparseVector-method
###   length,sparseVector-method rep,sparseVector-method
###   show,sparseVector-method %*%,Matrix,sparseVector-method
###   %*%,sparseVector,Matrix-method crossprod,Matrix,sparseVector-method
###   crossprod,sparseVector,Matrix-method solve,Matrix,sparseVector-method
###   tcrossprod,Matrix,sparseVector-method
###   tcrossprod,sparseVector,Matrix-method
###   [,sparseVector,index,ANY,ANY-method
###   [,sparseVector,lsparseVector,ANY,ANY-method
###   [,sparseVector,nsparseVector,ANY,ANY-method
###   [<-,sparseVector,index,missing,replValue-method
###   [<-,sparseVector,sparseVector,missing,replValue-method
### Keywords: classes

### ** Examples

getClass("sparseVector")
getClass("dsparseVector")
getClass("xsparseVector")# those with an 'x' slot

sx <- c(0,0,3, 3.2, 0,0,0,-3:1,0,0,2,0,0,5,0,0)
(ss <- as(sx, "sparseVector"))

ix <- as.integer(round(sx))
(is <- as(ix, "sparseVector"))
## an "isparseVector" (!)

## rep() works too:
(ri <- rep(is, length.out= 25))

## Using `dim<-`  as in base R :
r <- ss
dim(r) <- c(4,5) # becomes a sparse Matrix:
r

## currently has "non-structural" FALSE -- printing as ":"
(lis <- is & FALSE)
(nn <- is[is == 0]) # all "structural" FALSE

## NA-case
sN <- sx; sN[4] <- NA
(svN <- as(sN, "sparseVector"))

stopifnot(identical(is | FALSE, is != 0),
          validObject(svN), validObject(lis), as.logical(is.na(svN[4])),
          identical(is^2 > 0,   is & TRUE),
          all(!lis), !any(lis), length(nn@i) == 0, !any(nn), all(!nn),
          sum(lis) == 0, !prod(lis), range(lis) == c(0,0))



