### Name: tcrossprod
### Title: Cross-product of transpose
### Aliases: tcrossprod-methods tcrossprod,dgCMatrix,missing-method
###   tcrossprod,dgTMatrix,missing-method tcrossprod
### Keywords: methods algebra

### ** Examples

 ## A random sparce "incidence" matrix :
 m <- matrix(0, 400, 500)
 set.seed(12)
 m[runif(314, 0, length(m))] <- 1
 mm <- as(m, "dgCMatrix")
 object.size(m) / object.size(mm) # smaller by a factor of > 200

 ## tcrossprod() is very fast:
 system.time(tCmm <- tcrossprod(mm))# 0   (PIII, 933 MHz)
 system.time(cm <- crossprod(t(m))) # 0.16
 system.time(cm. <- tcrossprod(m))  # 0.02

 stopifnot(cm == as(tCmm, "matrix"))

 ## show sparse sub matrix
 tCmm[1:16, 1:30]



