### Name: polyCutout
### Title: Cutout Grid Points within Polygon
### Aliases: polyCutout
### Keywords: manip

### ** Examples

x11()

ply <- as(cbind(c(2, 8, 9, 6, 3), c(3, 1, 4, 8, 6)), "gpc.poly")
x <- seq(0, 10, 0.1)
y <- seq(0, 10, 0.1)
z <- matrix(runif(length(x) * length(y)), 
     nrow = length(y), ncol = length(x))

dat.old <- list(x = x, y = y, z = z)
filled.contour(dat.old, 
    plot.axes = {axis(1); axis(2); plot(ply, add = TRUE)})

dat.new <- polyCutout(dat.old, ply)
filled.contour(dat.new, color.palette = terrain.colors)



