### Name: tran.import-export
### Title: Import and Export Transect Data
### Aliases: tran.import tran.export
### Keywords: file

### ** Examples

## A sample transect file:

## structure(list(id = "T1", vertices = structure(c(679163.534, 679238.561, 
## 4135735.518, 4135730.43), .Dim = c(2L, 2L), .Dimnames = list(c("1", "2"), 
## c("x", "y"))), fix.zero = "R", h.offset = 21, grid.dx = 0.05, grid.dy = 0.005, 
## asp.ratio = 5, v.origin = 11.379, v.offset = -0.18, data.file = "T1.txt"), 
## .Names = c("id", "vertices", "fix.zero", "h.offset", "grid.dx", "grid.dy", 
## "asp.ratio", "v.origin", "v.offset", "data.file"))

f <- system.file("RSurvey-ex/confluence-T1.txt", package = "RSurvey")
tran.import("transect", "T1", f)
## No test: 
f <- paste(getwd(), "/test.txt", sep="")
tran.export("transect", "T1", f)
## End(No test)

## A sample profile file including a header and two rows of data.

## Distance     Elevation
## 14   10.499
## 16   10.429
## No test: 
f <- system.file("RSurvey-ex/confluence-profile-T1.txt", package = "RSurvey")
con <- file(f, open = "r", encoding = "latin1")
tran.import(type = "profile", id = "T1", file = con)

f <- paste(getwd(), "/test.txt", sep="")
con <- file(f, open = "w")
tran.export(type = "profile", id = "T1", file = con)
## End(No test)
## A sample raster file including a header and two rows of data.

## motoX        motoY   temp    pH      SpCond
## m    m       degC    units   uS/cm
## 0    -0.11   24.55   8.00    569.38
## 2    0       24.58   7.99    646.01

f <- system.file("RSurvey-ex/confluence-raster-T1.txt", package = "RSurvey")
con <- file(f, open = "r", encoding = "latin1")
tran.import(type = "raster", id = "T1", file = con)
## No test: 
f <- paste(getwd(), "/test.txt", sep="")
con <- file(f, open = "w")
tran.export("T1", type="raster", file = con)
## End(No test)



