/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.Vector;
import weka.associations.AbstractAssociator;
import weka.associations.Associator;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;

public class HotSpot
implements Associator,
OptionHandler,
RevisionHandler,
CapabilitiesHandler,
Drawable,
Serializable {
    static final long serialVersionUID = 42972325096347677L;
    protected SingleIndex m_targetSI = new SingleIndex("last");
    protected int m_target;
    protected double m_support;
    private int m_supportCount;
    protected double m_globalTarget;
    protected double m_minImprovement;
    protected int m_globalSupport;
    protected SingleIndex m_targetIndexSI = new SingleIndex("first");
    protected int m_targetIndex;
    protected int m_maxBranchingFactor;
    protected int m_numInstances;
    protected HotNode m_head;
    protected Instances m_header;
    protected int m_lookups = 0;
    protected int m_insertions = 0;
    protected int m_hits = 0;
    protected boolean m_debug;
    protected boolean m_minimize;
    protected String m_errorMessage;
    protected HashMap<HotSpotHashKey, String> m_ruleLookup;

    public HotSpot() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "HotSpot learns a set of rules (displayed in a tree-like structure) that maximize/minimize a target variable/value of interest. With a nominal target, one might want to look for segments of the data where there is a high probability of a minority value occuring (given the constraint of a minimum support). For a numeric target, one might be interested in finding segments where this is higher on average than in the whole data set. For example, in a health insurance scenario, find which health insurance groups are at the highest risk (have the highest claim ratio), or, which groups have the highest average insurance payout.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildAssociations(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_errorMessage = null;
        this.m_targetSI.setUpper(instances.numAttributes() - 1);
        this.m_target = this.m_targetSI.getIndex();
        Instances inst = new Instances(instances);
        inst.setClassIndex(this.m_target);
        inst.deleteWithMissingClass();
        if (inst.attribute(this.m_target).isNominal()) {
            this.m_targetIndexSI.setUpper(inst.attribute(this.m_target).numValues() - 1);
            this.m_targetIndex = this.m_targetIndexSI.getIndex();
        } else {
            this.m_targetIndexSI.setUpper(1);
        }
        if (this.m_support <= 0.0) {
            throw new Exception("Support must be greater than zero.");
        }
        this.m_numInstances = inst.numInstances();
        if (this.m_support >= 1.0) {
            this.m_supportCount = (int)this.m_support;
            this.m_support /= (double)this.m_numInstances;
        }
        this.m_supportCount = (int)Math.floor(this.m_support * (double)this.m_numInstances + 0.5);
        if (this.m_supportCount < 1) {
            this.m_supportCount = 1;
        }
        this.m_header = new Instances(inst, 0);
        if (inst.attribute(this.m_target).isNumeric()) {
            if (this.m_supportCount > this.m_numInstances) {
                this.m_errorMessage = "Error: support set to more instances than there are in the data!";
                return;
            }
            this.m_globalTarget = inst.meanOrMode(this.m_target);
        } else {
            double[] probs = new double[inst.attributeStats((int)this.m_target).nominalCounts.length];
            for (int i = 0; i < probs.length; ++i) {
                probs[i] = inst.attributeStats((int)this.m_target).nominalCounts[i];
            }
            this.m_globalSupport = (int)probs[this.m_targetIndex];
            if (this.m_globalSupport < this.m_supportCount) {
                this.m_errorMessage = "Error: minimum support " + this.m_supportCount + " is too high. Target value " + this.m_header.attribute(this.m_target).value(this.m_targetIndex) + " has support " + this.m_globalSupport + ".";
            }
            Utils.normalize(probs);
            this.m_globalTarget = probs[this.m_targetIndex];
        }
        this.m_ruleLookup = new HashMap();
        double[] splitVals = new double[this.m_header.numAttributes()];
        byte[] tests = new byte[this.m_header.numAttributes()];
        this.m_head = new HotNode(inst, this.m_globalTarget, splitVals, tests);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("\nHot Spot\n========");
        if (this.m_errorMessage != null) {
            buff.append("\n\n" + this.m_errorMessage + "\n\n");
            return buff.toString();
        }
        if (this.m_head == null) {
            buff.append("No model built!");
            return buff.toString();
        }
        buff.append("\nTotal population: ");
        buff.append("" + this.m_numInstances + " instances");
        buff.append("\nTarget attribute: " + this.m_header.attribute(this.m_target).name());
        if (this.m_header.attribute(this.m_target).isNominal()) {
            buff.append("\nTarget value: " + this.m_header.attribute(this.m_target).value(this.m_targetIndex));
            buff.append(" [value count in total population: " + this.m_globalSupport + " instances (" + Utils.doubleToString(this.m_globalTarget * 100.0, 2) + "%)]");
            buff.append("\nMinimum value count for segments: ");
        } else {
            buff.append("\nMinimum segment size: ");
        }
        buff.append("" + this.m_supportCount + " instances (" + Utils.doubleToString(this.m_support * 100.0, 2) + "% of total population)");
        buff.append("\nMaximum branching factor: " + this.m_maxBranchingFactor);
        buff.append("\nMinimum improvement in target: " + Utils.doubleToString(this.m_minImprovement * 100.0, 2) + "%");
        buff.append("\n\n");
        buff.append(this.m_header.attribute(this.m_target).name());
        if (this.m_header.attribute(this.m_target).isNumeric()) {
            buff.append(" (" + Utils.doubleToString(this.m_globalTarget, 4) + ")");
        } else {
            buff.append("=" + this.m_header.attribute(this.m_target).value(this.m_targetIndex) + " (");
            buff.append("" + Utils.doubleToString(this.m_globalTarget * 100.0, 2) + "% [");
            buff.append("" + this.m_globalSupport + "/" + this.m_numInstances + "])");
        }
        this.m_head.dumpTree(0, buff);
        buff.append("\n");
        if (this.m_debug) {
            buff.append("\n=== Duplicate rule lookup hashtable stats ===\n");
            buff.append("Insertions: " + this.m_insertions);
            buff.append("\nLookups : " + this.m_lookups);
            buff.append("\nHits: " + this.m_hits);
            buff.append("\n");
        }
        return buff.toString();
    }

    @Override
    public String graph() throws Exception {
        System.err.println("Here");
        this.m_head.assignIDs(-1);
        StringBuffer text = new StringBuffer();
        text.append("digraph HotSpot {\n");
        text.append("rankdir=LR;\n");
        text.append("N0 [label=\"" + this.m_header.attribute(this.m_target).name());
        if (this.m_header.attribute(this.m_target).isNumeric()) {
            text.append("\\n(" + Utils.doubleToString(this.m_globalTarget, 4) + ")");
        } else {
            text.append("=" + this.m_header.attribute(this.m_target).value(this.m_targetIndex) + "\\n(");
            text.append("" + Utils.doubleToString(this.m_globalTarget * 100.0, 2) + "% [");
            text.append("" + this.m_globalSupport + "/" + this.m_numInstances + "])");
        }
        text.append("\" shape=plaintext]\n");
        this.m_head.graphHotSpot(text);
        text.append("}\n");
        return text.toString();
    }

    public String targetTipText() {
        return "The target attribute of interest.";
    }

    public void setTarget(String target) {
        this.m_targetSI.setSingleIndex(target);
    }

    public String getTarget() {
        return this.m_targetSI.getSingleIndex();
    }

    public String targetIndexTipText() {
        return "The value of the target (nominal attributes only) of interest.";
    }

    public void setTargetIndex(String index) {
        this.m_targetIndexSI.setSingleIndex(index);
    }

    public String getTargetIndex() {
        return this.m_targetIndexSI.getSingleIndex();
    }

    public String minimizeTargetTipText() {
        return "Minimize rather than maximize the target.";
    }

    public void setMinimizeTarget(boolean m) {
        this.m_minimize = m;
    }

    public boolean getMinimizeTarget() {
        return this.m_minimize;
    }

    public String supportTipText() {
        return "The minimum support. Values between 0 and 1 are interpreted as a percentage of the total population; values > 1 are interpreted as an absolute number of instances";
    }

    public double getSupport() {
        return this.m_support;
    }

    public void setSupport(double s) {
        this.m_support = s;
    }

    public String maxBranchingFactorTipText() {
        return "Maximum branching factor. The maximum number of children to consider extending each node with.";
    }

    public void setMaxBranchingFactor(int b) {
        this.m_maxBranchingFactor = b;
    }

    public int getMaxBranchingFactor() {
        return this.m_maxBranchingFactor;
    }

    public String minImprovementTipText() {
        return "Minimum improvement in target value in order to consider adding a new branch/test";
    }

    public void setMinImprovement(double i) {
        this.m_minImprovement = i;
    }

    public double getMinImprovement() {
        return this.m_minImprovement;
    }

    public String debugTipText() {
        return "Output debugging info (duplicate rule lookup hash table stats).";
    }

    public void setDebug(boolean d) {
        this.m_debug = d;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tThe target index. (default = last)", "c", 1, "-c <num | first | last>"));
        newVector.addElement(new Option("\tThe target value (nominal target only, default = first)", "V", 1, "-V <num | first | last>"));
        newVector.addElement(new Option("\tMinimize rather than maximize.", "L", 0, "-L"));
        newVector.addElement(new Option("\tMinimum value count (nominal target)/segment size (numeric target).\n\tValues between 0 and 1 are \n\tinterpreted as a percentage of \n\tthe total population; values > 1 are \n\tinterpreted as an absolute number of \n\tinstances (default = 0.3)", "-S", 1, "-S <num>"));
        newVector.addElement(new Option("\tMaximum branching factor (default = 2)", "-M", 1, "-M <num>"));
        newVector.addElement(new Option("\tMinimum improvement in target value in order \n\tto add a new branch/test (default = 0.01 (1%))", "-I", 1, "-I <num>"));
        newVector.addElement(new Option("\tOutput debugging info (duplicate rule lookup \n\thash table stats)", "-D", 0, "-D"));
        return newVector.elements();
    }

    public void resetOptions() {
        this.m_support = 0.33;
        this.m_minImprovement = 0.01;
        this.m_maxBranchingFactor = 2;
        this.m_minimize = false;
        this.m_debug = false;
        this.setTarget("last");
        this.setTargetIndex("first");
        this.m_errorMessage = null;
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String tempString = Utils.getOption('c', options);
        if (tempString.length() != 0) {
            this.setTarget(tempString);
        }
        if ((tempString = Utils.getOption('V', options)).length() != 0) {
            this.setTargetIndex(tempString);
        }
        this.setMinimizeTarget(Utils.getFlag('L', options));
        tempString = Utils.getOption('S', options);
        if (tempString.length() != 0) {
            this.setSupport(Double.parseDouble(tempString));
        }
        if ((tempString = Utils.getOption('M', options)).length() != 0) {
            this.setMaxBranchingFactor(Integer.parseInt(tempString));
        }
        if ((tempString = Utils.getOption('I', options)).length() != 0) {
            this.setMinImprovement(Double.parseDouble(tempString));
        }
        this.setDebug(Utils.getFlag('D', options));
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[12];
        int current = 0;
        options[current++] = "-c";
        options[current++] = this.getTarget();
        options[current++] = "-V";
        options[current++] = this.getTargetIndex();
        if (this.getMinimizeTarget()) {
            options[current++] = "-L";
        }
        options[current++] = "-S";
        options[current++] = "" + this.getSupport();
        options[current++] = "-M";
        options[current++] = "" + this.getMaxBranchingFactor();
        options[current++] = "-I";
        options[current++] = "" + this.getMinImprovement();
        if (this.getDebug()) {
            options[current++] = "-D";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6081 $");
    }

    @Override
    public int graphType() {
        return 1;
    }

    public static void main(String[] args) {
        try {
            HotSpot h = new HotSpot();
            AbstractAssociator.runAssociator(new HotSpot(), args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected class HotNode
    implements Serializable {
        protected Instances m_insts;
        protected double m_targetValue;
        protected HotNode[] m_children;
        protected HotTestDetails[] m_testDetails;
        public int m_id;

        public HotNode(Instances insts, double targetValue, double[] splitVals, byte[] tests) {
            this.m_insts = insts;
            this.m_targetValue = targetValue;
            PriorityQueue<HotTestDetails> splitQueue = new PriorityQueue<HotTestDetails>();
            for (int i = 0; i < this.m_insts.numAttributes(); ++i) {
                if (i == HotSpot.this.m_target) continue;
                if (this.m_insts.attribute(i).isNominal()) {
                    this.evaluateNominal(i, splitQueue);
                    continue;
                }
                this.evaluateNumeric(i, splitQueue);
            }
            if (splitQueue.size() > 0) {
                int i;
                int queueSize = splitQueue.size();
                ArrayList<HotTestDetails> newCandidates = new ArrayList<HotTestDetails>();
                ArrayList<HotSpotHashKey> keyList = new ArrayList<HotSpotHashKey>();
                for (i = 0; i < queueSize && newCandidates.size() < HotSpot.this.m_maxBranchingFactor; ++i) {
                    HotTestDetails temp = splitQueue.poll();
                    double[] newSplitVals = (double[])splitVals.clone();
                    byte[] newTests = (byte[])tests.clone();
                    newSplitVals[temp.m_splitAttIndex] = temp.m_splitValue + 1.0;
                    newTests[temp.m_splitAttIndex] = HotSpot.this.m_header.attribute(temp.m_splitAttIndex).isNominal() ? 2 : (temp.m_lessThan ? 1 : 3);
                    HotSpotHashKey key = new HotSpotHashKey(newSplitVals, newTests);
                    ++HotSpot.this.m_lookups;
                    if (!HotSpot.this.m_ruleLookup.containsKey(key)) {
                        HotSpot.this.m_ruleLookup.put(key, "");
                        newCandidates.add(temp);
                        keyList.add(key);
                        ++HotSpot.this.m_insertions;
                        continue;
                    }
                    ++HotSpot.this.m_hits;
                }
                this.m_children = new HotNode[newCandidates.size() < HotSpot.this.m_maxBranchingFactor ? newCandidates.size() : HotSpot.this.m_maxBranchingFactor];
                this.m_testDetails = new HotTestDetails[this.m_children.length];
                for (i = 0; i < this.m_children.length; ++i) {
                    this.m_testDetails[i] = (HotTestDetails)newCandidates.get(i);
                }
                splitQueue = null;
                newCandidates = null;
                this.m_insts = new Instances(this.m_insts, 0);
                for (i = 0; i < this.m_children.length; ++i) {
                    Instances subset = this.subset(insts, this.m_testDetails[i]);
                    HotSpotHashKey tempKey = (HotSpotHashKey)keyList.get(i);
                    this.m_children[i] = new HotNode(subset, this.m_testDetails[i].m_merit, tempKey.m_splitValues, tempKey.m_testTypes);
                }
            }
        }

        private Instances subset(Instances insts, HotTestDetails test) {
            Instances sub = new Instances(insts, insts.numInstances());
            for (int i = 0; i < insts.numInstances(); ++i) {
                Instance temp = insts.instance(i);
                if (temp.isMissing(test.m_splitAttIndex)) continue;
                if (insts.attribute(test.m_splitAttIndex).isNominal()) {
                    if (temp.value(test.m_splitAttIndex) != test.m_splitValue) continue;
                    sub.add(temp);
                    continue;
                }
                if (test.m_lessThan) {
                    if (!(temp.value(test.m_splitAttIndex) <= test.m_splitValue)) continue;
                    sub.add(temp);
                    continue;
                }
                if (!(temp.value(test.m_splitAttIndex) > test.m_splitValue)) continue;
                sub.add(temp);
            }
            sub.compactify();
            return sub;
        }

        private void evaluateNumeric(int attIndex, PriorityQueue<HotTestDetails> pq) {
            double delta;
            Instances tempInsts = this.m_insts;
            tempInsts.sort(attIndex);
            double targetLeft = 0.0;
            double targetRight = 0.0;
            int numMissing = 0;
            for (int i = tempInsts.numInstances() - 1; i >= 0; --i) {
                if (!tempInsts.instance(i).isMissing(attIndex)) {
                    targetRight += tempInsts.attribute(HotSpot.this.m_target).isNumeric() ? tempInsts.instance(i).value(HotSpot.this.m_target) : (double)(tempInsts.instance(i).value(HotSpot.this.m_target) == (double)HotSpot.this.m_targetIndex ? 1 : 0);
                    continue;
                }
                ++numMissing;
            }
            if (tempInsts.numInstances() - numMissing <= HotSpot.this.m_supportCount) {
                return;
            }
            double bestMerit = 0.0;
            double bestSplit = 0.0;
            double bestSupport = 0.0;
            double bestSubsetSize = 0.0;
            boolean lessThan = true;
            double leftCount = 0.0;
            double rightCount = tempInsts.numInstances() - numMissing;
            for (int i = 0; i < tempInsts.numInstances() - numMissing; ++i) {
                double delta2;
                Instance inst = tempInsts.instance(i);
                if (tempInsts.attribute(HotSpot.this.m_target).isNumeric()) {
                    targetLeft += inst.value(HotSpot.this.m_target);
                    targetRight -= inst.value(HotSpot.this.m_target);
                } else if ((int)inst.value(HotSpot.this.m_target) == HotSpot.this.m_targetIndex) {
                    targetLeft += 1.0;
                    targetRight -= 1.0;
                }
                leftCount += 1.0;
                rightCount -= 1.0;
                if (i < tempInsts.numInstances() - 1 && inst.value(attIndex) == tempInsts.instance(i + 1).value(attIndex)) continue;
                if (tempInsts.attribute(HotSpot.this.m_target).isNominal()) {
                    if (targetLeft >= (double)HotSpot.this.m_supportCount) {
                        double d = delta2 = HotSpot.this.m_minimize ? bestMerit - targetLeft / leftCount : targetLeft / leftCount - bestMerit;
                        if (delta2 > 0.0) {
                            bestMerit = targetLeft / leftCount;
                            bestSplit = inst.value(attIndex);
                            bestSupport = targetLeft;
                            bestSubsetSize = leftCount;
                            lessThan = true;
                        } else if (delta2 == 0.0 && targetLeft > bestSupport) {
                            bestMerit = targetLeft / leftCount;
                            bestSplit = inst.value(attIndex);
                            bestSupport = targetLeft;
                            bestSubsetSize = leftCount;
                            lessThan = true;
                        }
                    }
                    if (!(targetRight >= (double)HotSpot.this.m_supportCount)) continue;
                    double d = delta2 = HotSpot.this.m_minimize ? bestMerit - targetRight / rightCount : targetRight / rightCount - bestMerit;
                    if (delta2 > 0.0) {
                        bestMerit = targetRight / rightCount;
                        bestSplit = inst.value(attIndex);
                        bestSupport = targetRight;
                        bestSubsetSize = rightCount;
                        lessThan = false;
                        continue;
                    }
                    if (delta2 != 0.0 || !(targetRight > bestSupport)) continue;
                    bestMerit = targetRight / rightCount;
                    bestSplit = inst.value(attIndex);
                    bestSupport = targetRight;
                    bestSubsetSize = rightCount;
                    lessThan = false;
                    continue;
                }
                if (leftCount >= (double)HotSpot.this.m_supportCount) {
                    double d = delta2 = HotSpot.this.m_minimize ? bestMerit - targetLeft / leftCount : targetLeft / leftCount - bestMerit;
                    if (delta2 > 0.0) {
                        bestMerit = targetLeft / leftCount;
                        bestSplit = inst.value(attIndex);
                        bestSupport = leftCount;
                        bestSubsetSize = leftCount;
                        lessThan = true;
                    } else if (delta2 == 0.0 && leftCount > bestSupport) {
                        bestMerit = targetLeft / leftCount;
                        bestSplit = inst.value(attIndex);
                        bestSupport = leftCount;
                        bestSubsetSize = leftCount;
                        lessThan = true;
                    }
                }
                if (!(rightCount >= (double)HotSpot.this.m_supportCount)) continue;
                double d = delta2 = HotSpot.this.m_minimize ? bestMerit - targetRight / rightCount : targetRight / rightCount - bestMerit;
                if (delta2 > 0.0) {
                    bestMerit = targetRight / rightCount;
                    bestSplit = inst.value(attIndex);
                    bestSupport = rightCount;
                    bestSubsetSize = rightCount;
                    lessThan = false;
                    continue;
                }
                if (delta2 != 0.0 || !(rightCount > bestSupport)) continue;
                bestMerit = targetRight / rightCount;
                bestSplit = inst.value(attIndex);
                bestSupport = rightCount;
                bestSubsetSize = rightCount;
                lessThan = false;
            }
            double d = delta = HotSpot.this.m_minimize ? this.m_targetValue - bestMerit : bestMerit - this.m_targetValue;
            if (bestSupport > 0.0 && delta / this.m_targetValue >= HotSpot.this.m_minImprovement) {
                HotTestDetails newD = new HotTestDetails(attIndex, bestSplit, lessThan, (int)bestSupport, (int)bestSubsetSize, bestMerit);
                pq.add(newD);
            }
        }

        private void evaluateNominal(int attIndex, PriorityQueue<HotTestDetails> pq) {
            int[] counts = this.m_insts.attributeStats((int)attIndex).nominalCounts;
            boolean ok = false;
            for (int i = 0; i < this.m_insts.attribute(attIndex).numValues(); ++i) {
                if (counts[i] < HotSpot.this.m_supportCount) continue;
                ok = true;
                break;
            }
            if (ok) {
                int i;
                double[] subsetMerit = new double[this.m_insts.attribute(attIndex).numValues()];
                for (i = 0; i < this.m_insts.numInstances(); ++i) {
                    Instance temp = this.m_insts.instance(i);
                    if (temp.isMissing(attIndex)) continue;
                    int attVal = (int)temp.value(attIndex);
                    if (this.m_insts.attribute(HotSpot.this.m_target).isNumeric()) {
                        int n = attVal;
                        subsetMerit[n] = subsetMerit[n] + temp.value(HotSpot.this.m_target);
                        continue;
                    }
                    int n = attVal;
                    subsetMerit[n] = subsetMerit[n] + ((int)temp.value(HotSpot.this.m_target) == HotSpot.this.m_targetIndex ? 1.0 : 0.0);
                }
                for (i = 0; i < this.m_insts.attribute(attIndex).numValues(); ++i) {
                    double delta;
                    if (counts[i] < HotSpot.this.m_supportCount || this.m_insts.attribute(HotSpot.this.m_target).isNominal() && !(subsetMerit[i] >= (double)HotSpot.this.m_supportCount)) continue;
                    double merit = subsetMerit[i] / (double)counts[i];
                    double d = delta = HotSpot.this.m_minimize ? this.m_targetValue - merit : merit - this.m_targetValue;
                    if (!(delta / this.m_targetValue >= HotSpot.this.m_minImprovement)) continue;
                    double support = this.m_insts.attribute(HotSpot.this.m_target).isNominal() ? subsetMerit[i] : (double)counts[i];
                    HotTestDetails newD = new HotTestDetails(attIndex, i, false, (int)support, counts[i], merit);
                    pq.add(newD);
                }
            }
        }

        public int assignIDs(int lastID) {
            int currentLastID;
            this.m_id = currentLastID = lastID + 1;
            if (this.m_children != null) {
                for (int i = 0; i < this.m_children.length; ++i) {
                    currentLastID = this.m_children[i].assignIDs(currentLastID);
                }
            }
            return currentLastID;
        }

        private void addNodeDetails(StringBuffer buff, int i, String spacer) {
            buff.append(HotSpot.this.m_header.attribute(this.m_testDetails[i].m_splitAttIndex).name());
            if (HotSpot.this.m_header.attribute(this.m_testDetails[i].m_splitAttIndex).isNumeric()) {
                if (this.m_testDetails[i].m_lessThan) {
                    buff.append(" <= ");
                } else {
                    buff.append(" > ");
                }
                buff.append(Utils.doubleToString(this.m_testDetails[i].m_splitValue, 4));
            } else {
                buff.append(" = " + HotSpot.this.m_header.attribute(this.m_testDetails[i].m_splitAttIndex).value((int)this.m_testDetails[i].m_splitValue));
            }
            if (HotSpot.this.m_header.attribute(HotSpot.this.m_target).isNumeric()) {
                buff.append(spacer + "(" + Utils.doubleToString(this.m_testDetails[i].m_merit, 4) + " [" + this.m_testDetails[i].m_support + "])");
            } else {
                buff.append(spacer + "(" + Utils.doubleToString(this.m_testDetails[i].m_merit * 100.0, 2) + "% [" + this.m_testDetails[i].m_support + "/" + this.m_testDetails[i].m_subsetSize + "])");
            }
        }

        private void graphHotSpot(StringBuffer text) {
            if (this.m_children != null) {
                for (int i = 0; i < this.m_children.length; ++i) {
                    text.append("N" + this.m_children[i].m_id);
                    text.append(" [label=\"");
                    this.addNodeDetails(text, i, "\\n");
                    text.append("\" shape=plaintext]\n");
                    this.m_children[i].graphHotSpot(text);
                    text.append("N" + this.m_id + "->" + "N" + this.m_children[i].m_id + "\n");
                }
            }
        }

        protected void dumpTree(int depth, StringBuffer buff) {
            if (this.m_children != null) {
                for (int i = 0; i < this.m_children.length; ++i) {
                    buff.append("\n  ");
                    for (int j = 0; j < depth; ++j) {
                        buff.append("|   ");
                    }
                    this.addNodeDetails(buff, i, " ");
                    this.m_children[i].dumpTree(depth + 1, buff);
                }
            }
        }

        protected class HotTestDetails
        implements Comparable<HotTestDetails>,
        Serializable {
            public double m_merit;
            public int m_support;
            public int m_subsetSize;
            public int m_splitAttIndex;
            public double m_splitValue;
            public boolean m_lessThan;

            public HotTestDetails(int attIndex, double splitVal, boolean lessThan, int support, int subsetSize, double merit) {
                this.m_merit = merit;
                this.m_splitAttIndex = attIndex;
                this.m_splitValue = splitVal;
                this.m_lessThan = lessThan;
                this.m_support = support;
                this.m_subsetSize = subsetSize;
            }

            @Override
            public int compareTo(HotTestDetails comp) {
                int result = 0;
                if (HotSpot.this.m_minimize) {
                    if (this.m_merit == comp.m_merit) {
                        if (this.m_support != comp.m_support) {
                            result = this.m_support > comp.m_support ? -1 : 1;
                        }
                    } else {
                        result = this.m_merit < comp.m_merit ? -1 : 1;
                    }
                } else if (this.m_merit == comp.m_merit) {
                    if (this.m_support != comp.m_support) {
                        result = this.m_support > comp.m_support ? -1 : 1;
                    }
                } else {
                    result = this.m_merit < comp.m_merit ? 1 : -1;
                }
                return result;
            }
        }
    }

    protected class HotSpotHashKey {
        protected double[] m_splitValues;
        protected byte[] m_testTypes;
        protected boolean m_computed = false;
        protected int m_key;

        public HotSpotHashKey(double[] splitValues, byte[] testTypes) {
            this.m_splitValues = (double[])splitValues.clone();
            this.m_testTypes = (byte[])testTypes.clone();
        }

        public boolean equals(Object b) {
            if (b == null || !b.getClass().equals(this.getClass())) {
                return false;
            }
            HotSpotHashKey comp = (HotSpotHashKey)b;
            boolean ok = true;
            for (int i = 0; i < this.m_splitValues.length; ++i) {
                if (this.m_splitValues[i] == comp.m_splitValues[i] && this.m_testTypes[i] == comp.m_testTypes[i]) continue;
                ok = false;
                break;
            }
            return ok;
        }

        public int hashCode() {
            if (this.m_computed) {
                return this.m_key;
            }
            int hv = 0;
            for (int i = 0; i < this.m_splitValues.length; ++i) {
                hv = (int)((double)hv + this.m_splitValues[i] * 5.0 * (double)i);
                hv += this.m_testTypes[i] * i * 3;
            }
            this.m_computed = true;
            this.m_key = hv;
            return this.m_key;
        }
    }
}

