/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Hashtable;
import weka.associations.ItemSet;
import weka.associations.RuleGeneration;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class RuleItem
implements Comparable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -3761299128347476534L;
    protected ItemSet m_premise;
    protected ItemSet m_consequence;
    protected double m_accuracy;
    protected int m_genTime;

    public RuleItem() {
    }

    public RuleItem(RuleItem toCopy) {
        this.m_premise = toCopy.m_premise;
        this.m_consequence = toCopy.m_consequence;
        this.m_accuracy = toCopy.m_accuracy;
        this.m_genTime = toCopy.m_genTime;
    }

    public RuleItem(ItemSet premise, ItemSet consequence, int genTime, int ruleSupport, double[] m_midPoints, Hashtable m_priors) {
        this.m_premise = premise;
        this.m_consequence = consequence;
        this.m_accuracy = RuleGeneration.expectation(ruleSupport, this.m_premise.m_counter, m_midPoints, m_priors);
        if (Double.isNaN(this.m_accuracy) || this.m_accuracy < 0.0) {
            this.m_accuracy = Double.MIN_VALUE;
        }
        this.m_consequence.m_counter = ruleSupport;
        this.m_genTime = genTime;
    }

    public RuleItem generateRuleItem(ItemSet premise, ItemSet consequence, Instances instances, int genTime, int minRuleCount, double[] m_midPoints, Hashtable m_priors) {
        ItemSet rule = new ItemSet(instances.numInstances());
        rule.m_items = new int[consequence.m_items.length];
        System.arraycopy(premise.m_items, 0, rule.m_items, 0, premise.m_items.length);
        for (int k = 0; k < consequence.m_items.length; ++k) {
            if (consequence.m_items[k] == -1) continue;
            rule.m_items[k] = consequence.m_items[k];
        }
        for (int i = 0; i < instances.numInstances(); ++i) {
            rule.upDateCounter(instances.instance(i));
        }
        int ruleSupport = rule.support();
        if (ruleSupport > minRuleCount) {
            RuleItem newRule = new RuleItem(premise, consequence, genTime, ruleSupport, m_midPoints, m_priors);
            return newRule;
        }
        return null;
    }

    public int compareTo(Object o) {
        if (this.m_accuracy == ((RuleItem)o).m_accuracy) {
            if (this.m_genTime == ((RuleItem)o).m_genTime) {
                return 0;
            }
            if (this.m_genTime > ((RuleItem)o).m_genTime) {
                return -1;
            }
            if (this.m_genTime < ((RuleItem)o).m_genTime) {
                return 1;
            }
        }
        if (this.m_accuracy < ((RuleItem)o).m_accuracy) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.m_premise.equals(((RuleItem)o).m_premise) && this.m_consequence.equals(((RuleItem)o).m_consequence);
    }

    public double accuracy() {
        return this.m_accuracy;
    }

    public ItemSet premise() {
        return this.m_premise;
    }

    public ItemSet consequence() {
        return this.m_consequence;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }
}

