/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.tertius;

import weka.associations.tertius.Literal;
import weka.associations.tertius.Predicate;
import weka.core.Instance;
import weka.core.RevisionUtils;

public class AttributeValueLiteral
extends Literal {
    private static final long serialVersionUID = 4077436297281456239L;
    private String m_value;
    private int m_index;

    public AttributeValueLiteral(Predicate predicate, String value, int index, int sign, int missing) {
        super(predicate, sign, missing);
        this.m_value = value;
        this.m_index = index;
    }

    @Override
    public boolean satisfies(Instance instance) {
        if (this.m_index == -1) {
            if (this.positive()) {
                return instance.isMissing(this.getPredicate().getIndex());
            }
            return !instance.isMissing(this.getPredicate().getIndex());
        }
        if (instance.isMissing(this.getPredicate().getIndex())) {
            if (this.positive()) {
                return false;
            }
            return this.m_missing != 0;
        }
        if (this.positive()) {
            return instance.value(this.getPredicate().getIndex()) == (double)this.m_index;
        }
        return instance.value(this.getPredicate().getIndex()) != (double)this.m_index;
    }

    @Override
    public boolean negationSatisfies(Instance instance) {
        if (this.m_index == -1) {
            if (this.positive()) {
                return !instance.isMissing(this.getPredicate().getIndex());
            }
            return instance.isMissing(this.getPredicate().getIndex());
        }
        if (instance.isMissing(this.getPredicate().getIndex())) {
            if (this.positive()) {
                return this.m_missing != 0;
            }
            return false;
        }
        if (this.positive()) {
            return instance.value(this.getPredicate().getIndex()) != (double)this.m_index;
        }
        return instance.value(this.getPredicate().getIndex()) == (double)this.m_index;
    }

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.negative()) {
            text.append("not ");
        }
        text.append(this.getPredicate().toString() + " = " + this.m_value);
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }
}

