/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.OneR;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class ClassifierAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler {
    private static final long serialVersionUID = 2442390690522602284L;
    protected Instances m_trainInstances;
    protected int m_randomSeed;
    protected int m_folds;
    protected boolean m_evalUsingTrainingData;
    protected Classifier m_Classifier;

    public ClassifierAttributeEval() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "ClassifierAttributeEval :\n\nEvaluates the worth of an attribute by using a user-specified classifier.\n";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tRandom number seed for cross validation.\n\t(default = 1)", "S", 1, "-S <seed>"));
        result.addElement(new Option("\tNumber of folds for cross validation.\n\t(default = 10)", "F", 1, "-F <folds>"));
        result.addElement(new Option("\tUse training data for evaluation rather than cross validaton.", "D", 0, "-D"));
        result.addElement(new Option("\tClassifier to use.\n\t(default = OneR)", "B", 1, "-B <classname + options>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        }
        if ((tmpStr = Utils.getOption('F', options)).length() != 0) {
            this.setFolds(Integer.parseInt(tmpStr));
        }
        if ((tmpStr = Utils.getOption('B', options)).length() != 0) {
            String[] tmpOptions = Utils.splitOptions(tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setClassifier((Classifier)Utils.forName(Classifier.class, tmpStr, tmpOptions));
        }
        this.setEvalUsingTrainingData(Utils.getFlag('D', options));
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getEvalUsingTrainingData()) {
            result.add("-D");
        }
        result.add("-S");
        result.add("" + this.getSeed());
        result.add("-F");
        result.add("" + this.getFolds());
        result.add("-B");
        result.add(new String(this.m_Classifier.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.m_Classifier)).getOptions())).trim());
        return result.toArray(new String[result.size()]);
    }

    public void setSeed(int value) {
        this.m_randomSeed = value;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String seedTipText() {
        return "Set the seed for use in cross validation.";
    }

    public void setFolds(int value) {
        this.m_folds = value;
        if (this.m_folds < 2) {
            this.m_folds = 2;
        }
    }

    public int getFolds() {
        return this.m_folds;
    }

    public String foldsTipText() {
        return "Set the number of folds for cross validation.";
    }

    public void setEvalUsingTrainingData(boolean value) {
        this.m_evalUsingTrainingData = value;
    }

    public boolean getEvalUsingTrainingData() {
        return this.m_evalUsingTrainingData;
    }

    public String evalUsingTrainingDataTipText() {
        return "Use the training data to evaluate attributes rather than cross validation.";
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The classifier to use for evaluating the attribute.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.m_Classifier != null) {
            result = this.m_Classifier.getCapabilities();
            result.setOwner(this);
        } else {
            result = super.getCapabilities();
            result.disableAll();
        }
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_trainInstances = data;
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_randomSeed = 1;
        this.m_folds = 10;
        this.m_evalUsingTrainingData = false;
        this.m_Classifier = new OneR();
    }

    @Override
    public double evaluateAttribute(int attribute) throws Exception {
        int[] featArray = new int[2];
        Remove delTransform = new Remove();
        delTransform.setInvertSelection(true);
        Instances train = new Instances(this.m_trainInstances);
        featArray[0] = attribute;
        featArray[1] = train.classIndex();
        delTransform.setAttributeIndicesArray(featArray);
        delTransform.setInputFormat(train);
        train = Filter.useFilter(train, delTransform);
        Evaluation eval = new Evaluation(train);
        Classifier cls = AbstractClassifier.makeCopy(this.m_Classifier);
        if (this.m_evalUsingTrainingData) {
            cls.buildClassifier(train);
            eval.evaluateModel(cls, train, new Object[0]);
        } else {
            eval.crossValidateModel(cls, train, this.m_folds, new Random(this.m_randomSeed), new Object[0]);
        }
        double errorRate = eval.errorRate();
        return (1.0 - errorRate) * 100.0;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainInstances == null) {
            text.append("\tClassifier feature evaluator has not been built yet");
        } else {
            text.append("\tClassifier feature evaluator.\n\n");
            text.append("\tUsing ");
            if (this.m_evalUsingTrainingData) {
                text.append("training data for evaluation of attributes.\n");
            } else {
                text.append(this.getFolds() + " fold cross validation for evaluating attributes.\n");
            }
            text.append("\tClassifier in use: " + this.m_Classifier.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.m_Classifier)).getOptions()));
        }
        text.append("\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] args) {
        ClassifierAttributeEval.runEvaluator(new ClassifierAttributeEval(), args);
    }
}

