/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.classifiers.CostMatrix;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public abstract class CostSensitiveASEvaluation
extends ASEvaluation
implements OptionHandler,
Serializable {
    static final long serialVersionUID = -7045833833363396977L;
    public static final int MATRIX_ON_DEMAND = 1;
    public static final int MATRIX_SUPPLIED = 2;
    public static final Tag[] TAGS_MATRIX_SOURCE = new Tag[]{new Tag(1, "Load cost matrix on demand"), new Tag(2, "Use explicit cost matrix")};
    protected int m_MatrixSource = 1;
    protected File m_OnDemandDirectory = new File(System.getProperty("user.dir"));
    protected String m_CostFile;
    protected CostMatrix m_CostMatrix = new CostMatrix(1);
    protected ASEvaluation m_evaluator;
    protected int m_seed = 1;

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tFile name of a cost matrix to use. If this is not supplied,\n\ta cost matrix will be loaded on demand. The name of the\n\ton-demand file is the relation name of the training data\n\tplus \".cost\", and the path to the on-demand file is\n\tspecified with the -N option.", "C", 1, "-C <cost file name>"));
        newVector.addElement(new Option("\tName of a directory to search for cost files when loading\n\tcosts on demand (default current directory).", "N", 1, "-N <directory>"));
        newVector.addElement(new Option("\tThe cost matrix in Matlab single line format.", "cost-matrix", 1, "-cost-matrix <matrix>"));
        newVector.addElement(new Option("\tThe seed to use for random number generation.", "S", 1, "-S <integer>"));
        newVector.addElement(new Option("\tFull name of base evaluator. Options after -- are passed to the evaluator.\n\t(default: " + this.defaultEvaluatorString() + ")", "W", 1, "-W"));
        if (this.m_evaluator instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to evaluator " + this.m_evaluator.getClass().getName() + ":"));
            Enumeration enu = ((OptionHandler)((Object)this.m_evaluator)).listOptions();
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String seed;
        String cost_matrix;
        String costFile = Utils.getOption('C', options);
        if (costFile.length() != 0) {
            try {
                this.setCostMatrix(new CostMatrix(new BufferedReader(new FileReader(costFile))));
            }
            catch (Exception ex) {
                this.setCostMatrix(null);
            }
            this.setCostMatrixSource(new SelectedTag(2, TAGS_MATRIX_SOURCE));
            this.m_CostFile = costFile;
        } else {
            this.setCostMatrixSource(new SelectedTag(1, TAGS_MATRIX_SOURCE));
        }
        String demandDir = Utils.getOption('N', options);
        if (demandDir.length() != 0) {
            this.setOnDemandDirectory(new File(demandDir));
        }
        if ((cost_matrix = Utils.getOption("cost-matrix", options)).length() != 0) {
            StringWriter writer = new StringWriter();
            CostMatrix.parseMatlab(cost_matrix).write(writer);
            this.setCostMatrix(new CostMatrix(new StringReader(writer.toString())));
            this.setCostMatrixSource(new SelectedTag(2, TAGS_MATRIX_SOURCE));
        }
        if ((seed = Utils.getOption('S', options)).length() != 0) {
            this.setSeed(Integer.parseInt(seed));
        } else {
            this.setSeed(1);
        }
        String evaluatorName = Utils.getOption('W', options);
        if (evaluatorName.length() > 0) {
            this.setEvaluator(ASEvaluation.forName(evaluatorName, null));
            this.setEvaluator(ASEvaluation.forName(evaluatorName, Utils.partitionOptions(options)));
        } else {
            this.setEvaluator(ASEvaluation.forName(this.defaultEvaluatorString(), null));
            this.setEvaluator(ASEvaluation.forName(this.defaultEvaluatorString(), Utils.partitionOptions(options)));
        }
    }

    @Override
    public String[] getOptions() {
        String[] evaluatorOptions;
        ArrayList<String> options = new ArrayList<String>();
        if (this.m_MatrixSource == 2) {
            if (this.m_CostFile != null) {
                options.add("-C");
                options.add("" + this.m_CostFile);
            } else {
                options.add("-cost-matrix");
                options.add(this.getCostMatrix().toMatlab());
            }
        } else {
            options.add("-N");
            options.add("" + this.getOnDemandDirectory());
        }
        options.add("-S");
        options.add("" + this.getSeed());
        options.add("-W");
        options.add(this.m_evaluator.getClass().getName());
        if (this.m_evaluator instanceof OptionHandler && (evaluatorOptions = ((OptionHandler)((Object)this.m_evaluator)).getOptions()).length > 0) {
            options.add("--");
            for (int i = 0; i < evaluatorOptions.length; ++i) {
                options.add(evaluatorOptions[i]);
            }
        }
        return options.toArray(new String[0]);
    }

    public String globalInfo() {
        return "A meta subset evaluator that makes its base subset evaluator cost-sensitive. ";
    }

    public String defaultEvaluatorString() {
        return "weka.attributeSelection.CfsSubsetEval";
    }

    public String costMatrixSourceTipText() {
        return "Sets where to get the cost matrix. The two options areto use the supplied explicit cost matrix (the setting of the costMatrix property), or to load a cost matrix from a file when required (this file will be loaded from the directory set by the onDemandDirectory property and will be named relation_name" + CostMatrix.FILE_EXTENSION + ").";
    }

    public SelectedTag getCostMatrixSource() {
        return new SelectedTag(this.m_MatrixSource, TAGS_MATRIX_SOURCE);
    }

    public void setCostMatrixSource(SelectedTag newMethod) {
        if (newMethod.getTags() == TAGS_MATRIX_SOURCE) {
            this.m_MatrixSource = newMethod.getSelectedTag().getID();
        }
    }

    public String onDemandDirectoryTipText() {
        return "Sets the directory where cost files are loaded from. This option is used when the costMatrixSource is set to \"On Demand\".";
    }

    public File getOnDemandDirectory() {
        return this.m_OnDemandDirectory;
    }

    public void setOnDemandDirectory(File newDir) {
        this.m_OnDemandDirectory = newDir.isDirectory() ? newDir : new File(newDir.getParent());
        this.m_MatrixSource = 1;
    }

    protected String getEvaluatorSpec() {
        ASEvaluation ase = this.getEvaluator();
        if (ase instanceof OptionHandler) {
            return ase.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)ase)).getOptions());
        }
        return ase.getClass().getName();
    }

    public String costMatrixTipText() {
        return "Sets the cost matrix explicitly. This matrix is used if the costMatrixSource property is set to \"Supplied\".";
    }

    public CostMatrix getCostMatrix() {
        return this.m_CostMatrix;
    }

    public void setCostMatrix(CostMatrix newCostMatrix) {
        this.m_CostMatrix = newCostMatrix;
        this.m_MatrixSource = 2;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int seed) {
        this.m_seed = seed;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String evaluatorTipText() {
        return "The base evaluator to be used.";
    }

    public void setEvaluator(ASEvaluation newEvaluator) throws IllegalArgumentException {
        this.m_evaluator = newEvaluator;
    }

    public ASEvaluation getEvaluator() {
        return this.m_evaluator;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.getEvaluator() != null) {
            result = this.getEvaluator().getCapabilities();
        } else {
            result = new Capabilities(this);
            result.disableAll();
        }
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (this.m_evaluator == null) {
            throw new Exception("No base evaluator has been set!");
        }
        if (this.m_MatrixSource == 1) {
            String costName = data.relationName() + CostMatrix.FILE_EXTENSION;
            File costFile = new File(this.getOnDemandDirectory(), costName);
            if (!costFile.exists()) {
                throw new Exception("On-demand cost file doesn't exist: " + costFile);
            }
            this.setCostMatrix(new CostMatrix(new BufferedReader(new FileReader(costFile))));
        } else if (this.m_CostMatrix == null) {
            this.m_CostMatrix = new CostMatrix(data.numClasses());
            this.m_CostMatrix.readOldFormat(new BufferedReader(new FileReader(this.m_CostFile)));
        }
        Random random = null;
        if (!(this.m_evaluator instanceof WeightedInstancesHandler)) {
            random = new Random(this.m_seed);
        }
        data = this.m_CostMatrix.applyCostMatrix(data, random);
        this.m_evaluator.buildEvaluator(data);
    }

    @Override
    public int[] postProcess(int[] attributeSet) throws Exception {
        return this.m_evaluator.postProcess(attributeSet);
    }

    public String toString() {
        if (this.m_evaluator == null) {
            return "CostSensitiveASEvaluation: No model built yet.";
        }
        String result = this.m_evaluator instanceof AttributeEvaluator ? "CostSensitiveAttributeEval using " : "CostSensitiveSubsetEval using ";
        result = result + "\n\n" + this.getEvaluatorSpec() + "\n\nEvaluator\n" + this.m_evaluator.toString() + "\n\nCost Matrix\n" + this.m_CostMatrix.toString();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }
}

