/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.attributeSelection.ErrorBasedMeritEvaluator;
import weka.attributeSelection.GainRatioAttributeEval;
import weka.attributeSelection.GreedyStepwise;
import weka.attributeSelection.HoldOutSubsetEvaluator;
import weka.attributeSelection.RankedOutputSearch;
import weka.attributeSelection.Ranker;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Statistics;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.experiment.PairedStats;
import weka.experiment.Stats;

public class RaceSearch
extends ASSearch
implements RankedOutputSearch,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 4015453851212985720L;
    private Instances m_Instances = null;
    private static final int FORWARD_RACE = 0;
    private static final int BACKWARD_RACE = 1;
    private static final int SCHEMATA_RACE = 2;
    private static final int RANK_RACE = 3;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(0, "Forward selection race"), new Tag(1, "Backward elimination race"), new Tag(2, "Schemata race"), new Tag(3, "Rank race")};
    private int m_raceType = 0;
    private static final int TEN_FOLD = 0;
    private static final int LEAVE_ONE_OUT = 1;
    public static final Tag[] XVALTAGS_SELECTION = new Tag[]{new Tag(0, "10 Fold"), new Tag(1, "Leave-one-out")};
    private int m_xvalType = 0;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_totalEvals;
    private double m_bestMerit = -1.7976931348623157E308;
    private HoldOutSubsetEvaluator m_theEvaluator = null;
    private double m_sigLevel = 0.001;
    private double m_delta = 0.001;
    private int m_samples = 20;
    private int m_numFolds = 10;
    private ASEvaluation m_ASEval = new GainRatioAttributeEval();
    private int[] m_Ranking;
    private boolean m_debug = false;
    private boolean m_rankingRequested = false;
    private double[][] m_rankedAtts;
    private int m_rankedSoFar;
    private int m_numToSelect = -1;
    private int m_calculatedNumToSelect = -1;
    private double m_threshold = -1.7976931348623157E308;

    public String globalInfo() {
        return "Races the cross validation error of competing attribute subsets. Use in conjuction with a ClassifierSubsetEval. RaceSearch has four modes:\n\nforward selection races all single attribute additions to a base set (initially  no attributes), selects the winner to become the new base set and then iterates until there is no improvement over the base set. \n\nBackward elimination is similar but the initial base set has all attributes included and races all single attribute deletions. \n\nSchemata search is a bit different. Each iteration a series of races are run in parallel. Each race in a set determines whether a particular attribute should be included or not---ie the race is between the attribute being \"in\" or \"out\". The other attributes for this race are included or excluded randomly at each point in the evaluation. As soon as one race has a clear winner (ie it has been decided whether a particular attribute should be inor not) then the next set of races begins, using the result of the winning race from the previous iteration as new base set.\n\nRank race first ranks the attributes using an attribute evaluator and then races the ranking. The race includes no attributes, the top ranked attribute, the top two attributes, the top three attributes, etc.\n\nIt is also possible to generate a raked list of attributes through the forward racing process. If generateRanking is set to true then a complete forward race will be run---that is, racing continues until all attributes have been selected. The order that they are added in determines a complete ranking of all the attributes.\n\nRacing uses paired and unpaired t-tests on cross-validation errors of competing subsets. When there is a significant difference between the means of the errors of two competing subsets then the poorer of the two can be eliminated from the race. Similarly, if there is no significant difference between the mean errors of two competing subsets and they are within some threshold of each other, then one can be eliminated from the race.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Andrew W. Moore and Mary S. Lee");
        result.setValue(TechnicalInformation.Field.TITLE, "Efficient Algorithms for Minimizing Cross Validation Error");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Eleventh International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "1994");
        result.setValue(TechnicalInformation.Field.PAGES, "190-198");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        return result;
    }

    public String raceTypeTipText() {
        return "Set the type of search.";
    }

    public void setRaceType(SelectedTag d) {
        if (d.getTags() == TAGS_SELECTION) {
            this.m_raceType = d.getSelectedTag().getID();
        }
        if (this.m_raceType == 2 && !this.m_rankingRequested) {
            try {
                this.setFoldsType(new SelectedTag(1, XVALTAGS_SELECTION));
                this.setSignificanceLevel(0.01);
            }
            catch (Exception ex) {}
        } else {
            try {
                this.setFoldsType(new SelectedTag(0, XVALTAGS_SELECTION));
                this.setSignificanceLevel(0.001);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SelectedTag getRaceType() {
        return new SelectedTag(this.m_raceType, TAGS_SELECTION);
    }

    public String significanceLevelTipText() {
        return "Set the significance level to use for t-test comparisons.";
    }

    public void setSignificanceLevel(double sig) {
        this.m_sigLevel = sig;
    }

    public double getSignificanceLevel() {
        return this.m_sigLevel;
    }

    public String thresholdTipText() {
        return "Set the error threshold by which to consider two subsets equivalent.";
    }

    @Override
    public void setThreshold(double t) {
        this.m_delta = t;
    }

    @Override
    public double getThreshold() {
        return this.m_delta;
    }

    public String foldsTypeTipText() {
        return "Set the number of folds to use for x-val error estimation; leave-one-out is selected automatically for schemata search.";
    }

    public void setFoldsType(SelectedTag d) {
        if (d.getTags() == XVALTAGS_SELECTION) {
            this.m_xvalType = d.getSelectedTag().getID();
        }
    }

    public SelectedTag getFoldsType() {
        return new SelectedTag(this.m_xvalType, XVALTAGS_SELECTION);
    }

    public String debugTipText() {
        return "Turn on verbose output for monitoring the search's progress.";
    }

    public void setDebug(boolean d) {
        this.m_debug = d;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    public String attributeEvaluatorTipText() {
        return "Attribute evaluator to use for generating an initial ranking. Use in conjunction with a rank race";
    }

    public void setAttributeEvaluator(ASEvaluation newEvaluator) {
        this.m_ASEval = newEvaluator;
    }

    public ASEvaluation getAttributeEvaluator() {
        return this.m_ASEval;
    }

    public String generateRankingTipText() {
        return "Use the racing process to generate a ranked list of attributes. Using this mode forces the race to be a forward type and then races until all attributes have been added, thus giving a ranked list";
    }

    @Override
    public void setGenerateRanking(boolean doRank) {
        this.m_rankingRequested = doRank;
        if (this.m_rankingRequested) {
            try {
                this.setRaceType(new SelectedTag(0, TAGS_SELECTION));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean getGenerateRanking() {
        return this.m_rankingRequested;
    }

    public String numToSelectTipText() {
        return "Specify the number of attributes to retain. Use in conjunction with generateRanking. The default value (-1) indicates that all attributes are to be retained. Use either this option or a threshold to reduce the attribute set.";
    }

    @Override
    public void setNumToSelect(int n) {
        this.m_numToSelect = n;
    }

    @Override
    public int getNumToSelect() {
        return this.m_numToSelect;
    }

    @Override
    public int getCalculatedNumToSelect() {
        if (this.m_numToSelect >= 0) {
            this.m_calculatedNumToSelect = this.m_numToSelect;
        }
        return this.m_calculatedNumToSelect;
    }

    public String selectionThresholdTipText() {
        return "Set threshold by which attributes can be discarded. Default value results in no attributes being discarded. Use in conjunction with generateRanking";
    }

    public void setSelectionThreshold(double threshold) {
        this.m_threshold = threshold;
    }

    public double getSelectionThreshold() {
        return this.m_threshold;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tType of race to perform.\n\t(default = 0).", "R", 1, "-R <0 = forward | 1 = backward race | 2 = schemata | 3 = rank>"));
        newVector.addElement(new Option("\tSignificance level for comaparisons\n\t(default = 0.001(forward/backward/rank)/0.01(schemata)).", "L", 1, "-L <significance>"));
        newVector.addElement(new Option("\tThreshold for error comparison.\n\t(default = 0.001).", "T", 1, "-T <threshold>"));
        newVector.addElement(new Option("\tAttribute ranker to use if doing a \n\trank search. Place any\n\tevaluator options LAST on \n\tthe command line following a \"--\".\n\teg. -A weka.attributeSelection.GainRatioAttributeEval ... -- -M.\n\t(default = GainRatioAttributeEval)", "A", 1, "-A <attribute evaluator>"));
        newVector.addElement(new Option("\tFolds for cross validation\n\t(default = 0 (1 if schemata race)", "F", 1, "-F <0 = 10 fold | 1 = leave-one-out>"));
        newVector.addElement(new Option("\tGenerate a ranked list of attributes.\n\tForces the search to be forward\n\tand races until all attributes have\n\tselected, thus producing a ranking.", "Q", 0, "-Q"));
        newVector.addElement(new Option("\tSpecify number of attributes to retain from \n\tthe ranking. Overides -T. Use in conjunction with -Q", "N", 1, "-N <num to select>"));
        newVector.addElement(new Option("\tSpecify a theshold by which attributes\n\tmay be discarded from the ranking.\n\tUse in conjuction with -Q", "J", 1, "-J <threshold>"));
        newVector.addElement(new Option("\tVerbose output for monitoring the search.", "Z", 0, "-Z"));
        if (this.m_ASEval != null && this.m_ASEval instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to evaluator " + this.m_ASEval.getClass().getName() + ":"));
            Enumeration enu = ((OptionHandler)((Object)this.m_ASEval)).listOptions();
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('R', options);
        if (optionString.length() != 0) {
            this.setRaceType(new SelectedTag(Integer.parseInt(optionString), TAGS_SELECTION));
        }
        if ((optionString = Utils.getOption('F', options)).length() != 0) {
            this.setFoldsType(new SelectedTag(Integer.parseInt(optionString), XVALTAGS_SELECTION));
        }
        if ((optionString = Utils.getOption('L', options)).length() != 0) {
            this.setSignificanceLevel(Double.parseDouble(optionString));
        }
        if ((optionString = Utils.getOption('T', options)).length() != 0) {
            this.setThreshold(Double.parseDouble(optionString));
        }
        if ((optionString = Utils.getOption('A', options)).length() != 0) {
            this.setAttributeEvaluator(ASEvaluation.forName(optionString, Utils.partitionOptions(options)));
        }
        this.setGenerateRanking(Utils.getFlag('Q', options));
        optionString = Utils.getOption('J', options);
        if (optionString.length() != 0) {
            this.setSelectionThreshold(Double.parseDouble(optionString));
        }
        if ((optionString = Utils.getOption('N', options)).length() != 0) {
            this.setNumToSelect(Integer.parseInt(optionString));
        }
        this.setDebug(Utils.getFlag('Z', options));
    }

    @Override
    public String[] getOptions() {
        int current = 0;
        String[] evaluatorOptions = new String[]{};
        if (this.m_ASEval != null && this.m_ASEval instanceof OptionHandler) {
            evaluatorOptions = ((OptionHandler)((Object)this.m_ASEval)).getOptions();
        }
        String[] options = new String[17 + evaluatorOptions.length];
        options[current++] = "-R";
        options[current++] = "" + this.m_raceType;
        options[current++] = "-L";
        options[current++] = "" + this.getSignificanceLevel();
        options[current++] = "-T";
        options[current++] = "" + this.getThreshold();
        options[current++] = "-F";
        options[current++] = "" + this.m_xvalType;
        if (this.getGenerateRanking()) {
            options[current++] = "-Q";
        }
        options[current++] = "-N";
        options[current++] = "" + this.getNumToSelect();
        options[current++] = "-J";
        options[current++] = "" + this.getSelectionThreshold();
        if (this.getDebug()) {
            options[current++] = "-Z";
        }
        if (this.getAttributeEvaluator() != null) {
            options[current++] = "-A";
            options[current++] = this.getAttributeEvaluator().getClass().getName();
            options[current++] = "--";
            System.arraycopy(evaluatorOptions, 0, options, current, evaluatorOptions.length);
            current += evaluatorOptions.length;
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        if (!(ASEval instanceof SubsetEvaluator)) {
            throw new Exception(ASEval.getClass().getName() + " is not a " + "Subset evaluator! (RaceSearch)");
        }
        if (ASEval instanceof UnsupervisedSubsetEvaluator) {
            throw new Exception("Can't use an unsupervised subset evaluator (RaceSearch).");
        }
        if (!(ASEval instanceof HoldOutSubsetEvaluator)) {
            throw new Exception("Must use a HoldOutSubsetEvaluator, eg. weka.attributeSelection.ClassifierSubsetEval (RaceSearch)");
        }
        if (!(ASEval instanceof ErrorBasedMeritEvaluator)) {
            throw new Exception("Only error based subset evaluators can be used, eg. weka.attributeSelection.ClassifierSubsetEval (RaceSearch)");
        }
        this.m_Instances = new Instances(data);
        this.m_Instances.deleteWithMissingClass();
        if (this.m_Instances.numInstances() == 0) {
            throw new Exception("All train instances have missing class! (RaceSearch)");
        }
        if (this.m_rankingRequested && this.m_numToSelect > this.m_Instances.numAttributes() - 1) {
            throw new Exception("More attributes requested than exist in the data (RaceSearch).");
        }
        this.m_theEvaluator = (HoldOutSubsetEvaluator)ASEval;
        this.m_numAttribs = this.m_Instances.numAttributes();
        this.m_classIndex = this.m_Instances.classIndex();
        if (this.m_rankingRequested) {
            this.m_rankedAtts = new double[this.m_numAttribs - 1][2];
            this.m_rankedSoFar = 0;
        }
        this.m_numFolds = this.m_xvalType == 1 ? this.m_Instances.numInstances() : 10;
        Random random = new Random(1L);
        this.m_Instances.randomize(random);
        int[] bestSubset = null;
        switch (this.m_raceType) {
            case 0: 
            case 1: {
                bestSubset = this.hillclimbRace(this.m_Instances, random);
                break;
            }
            case 2: {
                bestSubset = this.schemataRace(this.m_Instances, random);
                break;
            }
            case 3: {
                bestSubset = this.rankRace(this.m_Instances, random);
            }
        }
        return bestSubset;
    }

    @Override
    public double[][] rankedAttributes() throws Exception {
        if (!this.m_rankingRequested) {
            throw new Exception("Need to request a ranked list of attributes before attributes can be ranked (RaceSearch).");
        }
        if (this.m_rankedAtts == null) {
            throw new Exception("Search must be performed before attributes can be ranked (RaceSearch).");
        }
        double[][] final_rank = new double[this.m_rankedSoFar][2];
        for (int i = 0; i < this.m_rankedSoFar; ++i) {
            final_rank[i][0] = this.m_rankedAtts[i][0];
            final_rank[i][1] = this.m_rankedAtts[i][1];
        }
        if (this.m_numToSelect <= 0) {
            if (this.m_threshold == -1.7976931348623157E308) {
                this.m_calculatedNumToSelect = final_rank.length;
            } else {
                this.determineNumToSelectFromThreshold(final_rank);
            }
        }
        return final_rank;
    }

    private void determineNumToSelectFromThreshold(double[][] ranking) {
        int count = 0;
        for (int i = 0; i < ranking.length; ++i) {
            if (!(ranking[i][1] > this.m_threshold)) continue;
            ++count;
        }
        this.m_calculatedNumToSelect = count;
    }

    private String printSets(char[][] raceSets) {
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < raceSets.length; ++i) {
            for (int j = 0; j < this.m_numAttribs; ++j) {
                temp.append(raceSets[i][j]);
            }
            temp.append('\n');
        }
        return temp.toString();
    }

    private int[] schemataRace(Instances data, Random random) throws Exception {
        int i;
        int numRaces = this.m_numAttribs - 1;
        Random r = new Random(42L);
        int numInstances = data.numInstances();
        Stats[][] raceStats = new Stats[numRaces][2];
        char[][][] parallelRaces = new char[numRaces][2][this.m_numAttribs - 1];
        char[] base = new char[this.m_numAttribs];
        for (int i2 = 0; i2 < this.m_numAttribs; ++i2) {
            base[i2] = 42;
        }
        int count = 0;
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (i == this.m_classIndex) continue;
            parallelRaces[count][0] = (char[])base.clone();
            parallelRaces[count][1] = (char[])base.clone();
            parallelRaces[count][0][i] = 49;
            parallelRaces[count++][1][i] = 48;
        }
        if (this.m_debug) {
            System.err.println("Initial sets:\n");
            for (i = 0; i < numRaces; ++i) {
                System.err.print(this.printSets(parallelRaces[i]) + "--------------\n");
            }
        }
        BitSet randomB = new BitSet(this.m_numAttribs);
        char[] randomBC = new char[this.m_numAttribs];
        boolean[] attributeConstraints = new boolean[this.m_numAttribs];
        int evaluationCount = 0;
        block3: while (numRaces > 0) {
            int i3;
            boolean won = false;
            for (int i4 = 0; i4 < numRaces; ++i4) {
                raceStats[i4][0] = new Stats();
                raceStats[i4][1] = new Stats();
            }
            int sampleCount = 0;
            block5: while (!won) {
                int i5;
                for (i3 = 0; i3 < this.m_numAttribs; ++i3) {
                    if (i3 == this.m_classIndex) continue;
                    if (!attributeConstraints[i3]) {
                        if (r.nextDouble() < 0.5) {
                            randomB.set(i3);
                            continue;
                        }
                        randomB.clear(i3);
                        continue;
                    }
                    if (base[i3] == '1') {
                        randomB.set(i3);
                        continue;
                    }
                    randomB.clear(i3);
                }
                int testIndex = Math.abs(r.nextInt() % numInstances);
                Instances trainCV = data.trainCV(numInstances, testIndex, new Random(1L));
                Instances testCV = data.testCV(numInstances, testIndex);
                Instance testInstance = testCV.instance(0);
                ++sampleCount;
                this.m_theEvaluator.buildEvaluator(trainCV);
                double error = -this.m_theEvaluator.evaluateSubset(randomB, testInstance, true);
                ++evaluationCount;
                for (i5 = 0; i5 < this.m_numAttribs; ++i5) {
                    randomBC[i5] = randomB.get(i5) ? 49 : 48;
                }
                for (i5 = 0; i5 < numRaces; ++i5) {
                    if ((raceStats[i5][0].count + raceStats[i5][1].count) / 2.0 > (double)numInstances) break block3;
                    for (int j = 0; j < 2; ++j) {
                        boolean matched = true;
                        for (int k = 0; k < this.m_numAttribs; ++k) {
                            if (parallelRaces[i5][j][k] == '*' || parallelRaces[i5][j][k] == randomBC[k]) continue;
                            matched = false;
                            break;
                        }
                        if (!matched) continue;
                        raceStats[i5][j].add(error);
                        if (!(raceStats[i5][0].count > (double)this.m_samples) || !(raceStats[i5][1].count > (double)this.m_samples)) continue;
                        raceStats[i5][0].calculateDerived();
                        raceStats[i5][1].calculateDerived();
                        double prob = this.ttest(raceStats[i5][0], raceStats[i5][1]);
                        if (!(prob < this.m_sigLevel)) continue;
                        if (raceStats[i5][0].mean < raceStats[i5][1].mean) {
                            base = (char[])parallelRaces[i5][0].clone();
                            this.m_bestMerit = raceStats[i5][0].mean;
                            if (this.m_debug) {
                                System.err.println("contender 0 won ");
                            }
                        } else {
                            base = (char[])parallelRaces[i5][1].clone();
                            this.m_bestMerit = raceStats[i5][1].mean;
                            if (this.m_debug) {
                                System.err.println("contender 1 won");
                            }
                        }
                        if (this.m_debug) {
                            System.err.println(new String(parallelRaces[i5][0]) + " " + new String(parallelRaces[i5][1]));
                            System.err.println("Means : " + raceStats[i5][0].mean + " vs" + raceStats[i5][1].mean);
                            System.err.println("Evaluations so far : " + evaluationCount);
                        }
                        won = true;
                        continue block5;
                    }
                }
            }
            if (--numRaces <= 0 || !won) continue;
            parallelRaces = new char[numRaces][2][this.m_numAttribs - 1];
            raceStats = new Stats[numRaces][2];
            for (i3 = 0; i3 < this.m_numAttribs; ++i3) {
                if (i3 == this.m_classIndex || attributeConstraints[i3] || base[i3] == '*') continue;
                attributeConstraints[i3] = true;
                break;
            }
            count = 0;
            block12: for (i3 = 0; i3 < numRaces; ++i3) {
                parallelRaces[i3][0] = (char[])base.clone();
                parallelRaces[i3][1] = (char[])base.clone();
                for (int j = count; j < this.m_numAttribs; ++j) {
                    if (j == this.m_classIndex || parallelRaces[i3][0][j] != '*') continue;
                    parallelRaces[i3][0][j] = 49;
                    parallelRaces[i3][1][j] = 48;
                    count = j + 1;
                    continue block12;
                }
            }
            if (!this.m_debug) continue;
            System.err.println("Next sets:\n");
            for (i3 = 0; i3 < numRaces; ++i3) {
                System.err.print(this.printSets(parallelRaces[i3]) + "--------------\n");
            }
        }
        if (this.m_debug) {
            System.err.println("Total evaluations : " + evaluationCount);
        }
        return this.attributeList(base);
    }

    private double ttest(Stats c1, Stats c2) throws Exception {
        double n1 = c1.count;
        double n2 = c2.count;
        double v1 = c1.stdDev * c1.stdDev;
        double v2 = c2.stdDev * c2.stdDev;
        double av1 = c1.mean;
        double av2 = c2.mean;
        double df = n1 + n2 - 2.0;
        double cv = ((n1 - 1.0) * v1 + (n2 - 1.0) * v2) / df;
        double t = (av1 - av2) / Math.sqrt(cv * (1.0 / n1 + 1.0 / n2));
        return Statistics.incompleteBeta(df / 2.0, 0.5, df / (df + t * t));
    }

    private int[] rankRace(Instances data, Random random) throws Exception {
        char[] baseSet = new char[this.m_numAttribs];
        for (int i = 0; i < this.m_numAttribs; ++i) {
            baseSet[i] = i == this.m_classIndex ? 45 : 48;
        }
        int numCompetitors = this.m_numAttribs - 1;
        char[][] raceSets = new char[numCompetitors + 1][this.m_numAttribs];
        if (this.m_ASEval instanceof AttributeEvaluator) {
            Ranker ranker = new Ranker();
            this.m_ASEval.buildEvaluator(data);
            this.m_Ranking = ranker.search(this.m_ASEval, data);
        } else {
            GreedyStepwise fs = new GreedyStepwise();
            fs.setGenerateRanking(true);
            this.m_ASEval.buildEvaluator(data);
            fs.search(this.m_ASEval, data);
            double[][] rankres = fs.rankedAttributes();
            this.m_Ranking = new int[rankres.length];
            for (int i = 0; i < rankres.length; ++i) {
                this.m_Ranking[i] = (int)rankres[i][0];
            }
        }
        raceSets[0] = (char[])baseSet.clone();
        for (int i = 0; i < this.m_Ranking.length; ++i) {
            raceSets[i + 1] = (char[])raceSets[i].clone();
            raceSets[i + 1][this.m_Ranking[i]] = 49;
        }
        if (this.m_debug) {
            System.err.println("Initial sets:\n" + this.printSets(raceSets));
        }
        double[] winnerInfo = this.raceSubsets(raceSets, data, true, random);
        double bestSetError = winnerInfo[1];
        char[] bestSet = (char[])raceSets[(int)winnerInfo[0]].clone();
        this.m_bestMerit = bestSetError;
        return this.attributeList(bestSet);
    }

    private int[] hillclimbRace(Instances data, Random random) throws Exception {
        double baseSetError;
        char[] baseSet = new char[this.m_numAttribs];
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (i != this.m_classIndex) {
                if (this.m_raceType == 0) {
                    baseSet[i] = 48;
                    continue;
                }
                baseSet[i] = 49;
                continue;
            }
            baseSet[i] = 45;
        }
        int numCompetitors = this.m_numAttribs - 1;
        char[][] raceSets = new char[numCompetitors + 1][this.m_numAttribs];
        raceSets[0] = (char[])baseSet.clone();
        int count = 1;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (i == this.m_classIndex) continue;
            raceSets[count] = (char[])baseSet.clone();
            raceSets[count++][i] = this.m_raceType == 1 ? 48 : 49;
        }
        if (this.m_debug) {
            System.err.println("Initial sets:\n" + this.printSets(raceSets));
        }
        double[] winnerInfo = this.raceSubsets(raceSets, data, true, random);
        this.m_bestMerit = baseSetError = winnerInfo[1];
        baseSet = (char[])raceSets[(int)winnerInfo[0]].clone();
        if (this.m_rankingRequested) {
            this.m_rankedAtts[this.m_rankedSoFar][0] = (int)(winnerInfo[0] - 1.0);
            this.m_rankedAtts[this.m_rankedSoFar][1] = winnerInfo[1];
            ++this.m_rankedSoFar;
        }
        boolean improved = true;
        while (improved && --numCompetitors != 0) {
            int j = 0;
            raceSets = new char[numCompetitors + 1][this.m_numAttribs];
            block3: for (int i = 0; i < numCompetitors + 1; ++i) {
                raceSets[i] = (char[])baseSet.clone();
                if (i <= 0) continue;
                for (int k = j; k < this.m_numAttribs; ++k) {
                    if (this.m_raceType == 1) {
                        if (k == this.m_classIndex || raceSets[i][k] == '0') continue;
                        raceSets[i][k] = 48;
                        j = k + 1;
                        continue block3;
                    }
                    if (k == this.m_classIndex || raceSets[i][k] == '1') continue;
                    raceSets[i][k] = 49;
                    j = k + 1;
                    continue block3;
                }
            }
            if (this.m_debug) {
                System.err.println("Next set : \n" + this.printSets(raceSets));
            }
            improved = false;
            String bs = new String(baseSet);
            winnerInfo = this.raceSubsets(raceSets, data, true, random);
            String win = new String(raceSets[(int)winnerInfo[0]]);
            if (bs.compareTo(win) == 0 || !(winnerInfo[1] < baseSetError) && !this.m_rankingRequested) continue;
            improved = true;
            this.m_bestMerit = baseSetError = winnerInfo[1];
            if (this.m_rankingRequested) {
                for (int i = 0; i < baseSet.length; ++i) {
                    if (win.charAt(i) == bs.charAt(i)) continue;
                    this.m_rankedAtts[this.m_rankedSoFar][0] = i;
                    this.m_rankedAtts[this.m_rankedSoFar][1] = winnerInfo[1];
                    ++this.m_rankedSoFar;
                }
            }
            baseSet = (char[])raceSets[(int)winnerInfo[0]].clone();
        }
        return this.attributeList(baseSet);
    }

    private int[] attributeList(char[] list) {
        int count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (list[i] != '1') continue;
            ++count;
        }
        int[] rlist = new int[count];
        count = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (list[i] != '1') continue;
            rlist[count++] = i;
        }
        return rlist;
    }

    private double[] raceSubsets(char[][] raceSets, Instances data, boolean baseSetIncluded, Random random) throws Exception {
        ASEvaluation[] evaluators = ASEvaluation.makeCopies(this.m_theEvaluator, raceSets.length);
        boolean[] eliminated = new boolean[raceSets.length];
        Stats[] individualStats = new Stats[raceSets.length];
        PairedStats[][] testers = new PairedStats[raceSets.length][raceSets.length];
        int startPt = this.m_rankingRequested ? 1 : 0;
        for (int i = 0; i < raceSets.length; ++i) {
            individualStats[i] = new Stats();
            for (int j = i + 1; j < raceSets.length; ++j) {
                testers[i][j] = new PairedStats(this.m_sigLevel);
            }
        }
        BitSet[] raceBitSets = new BitSet[raceSets.length];
        for (int i = 0; i < raceSets.length; ++i) {
            raceBitSets[i] = new BitSet(this.m_numAttribs);
            for (int j = 0; j < this.m_numAttribs; ++j) {
                if (raceSets[i][j] != '1') continue;
                raceBitSets[i].set(j);
            }
        }
        double[] errors = new double[raceSets.length];
        int eliminatedCount = 0;
        int processedCount = 0;
        processedCount = 0;
        block4: for (int i = 0; i < this.m_numFolds; ++i) {
            Instances trainCV = data.trainCV(this.m_numFolds, i, new Random(1L));
            Instances testCV = data.testCV(this.m_numFolds, i);
            for (int j = startPt; j < raceSets.length; ++j) {
                if (eliminated[j]) continue;
                evaluators[j].buildEvaluator(trainCV);
            }
            for (int z = 0; z < testCV.numInstances(); ++z) {
                int k;
                int j;
                Instance testInst = testCV.instance(z);
                ++processedCount;
                for (int zz = startPt; zz < raceSets.length; ++zz) {
                    if (eliminated[zz]) continue;
                    errors[zz] = z == 0 ? -((HoldOutSubsetEvaluator)evaluators[zz]).evaluateSubset(raceBitSets[zz], testInst, true) : -((HoldOutSubsetEvaluator)evaluators[zz]).evaluateSubset(raceBitSets[zz], testInst, false);
                }
                for (j = startPt; j < raceSets.length; ++j) {
                    if (eliminated[j]) continue;
                    individualStats[j].add(errors[j]);
                    for (k = j + 1; k < raceSets.length; ++k) {
                        if (eliminated[k]) continue;
                        testers[j][k].add(errors[j], errors[k]);
                    }
                }
                if (processedCount > this.m_samples - 1 && eliminatedCount < raceSets.length - 1) {
                    block10: for (j = 0; j < raceSets.length; ++j) {
                        if (eliminated[j]) continue;
                        for (k = j + 1; k < raceSets.length; ++k) {
                            if (eliminated[k]) continue;
                            testers[j][k].calculateDerived();
                            if (testers[j][k].differencesSignificance == 0 && (Utils.eq(testers[j][k].differencesStats.mean, 0.0) || Utils.gr(this.m_delta, Math.abs(testers[j][k].differencesStats.mean)))) {
                                if (Utils.eq(testers[j][k].differencesStats.mean, 0.0)) {
                                    if (baseSetIncluded) {
                                        if (j != 0) {
                                            eliminated[j] = true;
                                        } else {
                                            eliminated[k] = true;
                                        }
                                        ++eliminatedCount;
                                    } else {
                                        eliminated[j] = true;
                                    }
                                    if (!this.m_debug) continue;
                                    System.err.println("Eliminating (identical) " + j + " " + raceBitSets[j].toString() + " vs " + k + " " + raceBitSets[k].toString() + " after " + processedCount + " evaluations\n" + "\nerror " + j + " : " + testers[j][k].xStats.mean + " vs " + k + " : " + testers[j][k].yStats.mean + " diff : " + testers[j][k].differencesStats.mean);
                                    continue;
                                }
                                if (testers[j][k].xStats.mean > testers[j][k].yStats.mean) {
                                    eliminated[j] = true;
                                    ++eliminatedCount;
                                    if (!this.m_debug) continue block10;
                                    System.err.println("Eliminating (near identical) " + j + " " + raceBitSets[j].toString() + " vs " + k + " " + raceBitSets[k].toString() + " after " + processedCount + " evaluations\n" + "\nerror " + j + " : " + testers[j][k].xStats.mean + " vs " + k + " : " + testers[j][k].yStats.mean + " diff : " + testers[j][k].differencesStats.mean);
                                    continue block10;
                                }
                                eliminated[k] = true;
                                ++eliminatedCount;
                                if (!this.m_debug) continue;
                                System.err.println("Eliminating (near identical) " + k + " " + raceBitSets[k].toString() + " vs " + j + " " + raceBitSets[j].toString() + " after " + processedCount + " evaluations\n" + "\nerror " + k + " : " + testers[j][k].yStats.mean + " vs " + j + " : " + testers[j][k].xStats.mean + " diff : " + testers[j][k].differencesStats.mean);
                                continue;
                            }
                            if (testers[j][k].differencesSignificance == 0) continue;
                            if (testers[j][k].differencesSignificance > 0) {
                                eliminated[j] = true;
                                ++eliminatedCount;
                                if (!this.m_debug) continue block10;
                                System.err.println("Eliminating (-worse) " + j + " " + raceBitSets[j].toString() + " vs " + k + " " + raceBitSets[k].toString() + " after " + processedCount + " evaluations" + "\nerror " + j + " : " + testers[j][k].xStats.mean + " vs " + k + " : " + testers[j][k].yStats.mean);
                                continue block10;
                            }
                            eliminated[k] = true;
                            ++eliminatedCount;
                            if (!this.m_debug) continue;
                            System.err.println("Eliminating (worse) " + k + " " + raceBitSets[k].toString() + " vs " + j + " " + raceBitSets[j].toString() + " after " + processedCount + " evaluations" + "\nerror " + k + " : " + testers[j][k].yStats.mean + " vs " + j + " : " + testers[j][k].xStats.mean);
                        }
                    }
                }
                if (eliminatedCount == raceSets.length - 1 && baseSetIncluded && !eliminated[0] && !this.m_rankingRequested) break block4;
            }
        }
        if (this.m_debug) {
            System.err.println("*****eliminated count: " + eliminatedCount);
        }
        double bestError = Double.MAX_VALUE;
        int bestIndex = 0;
        for (int i = startPt; i < raceSets.length; ++i) {
            if (eliminated[i]) continue;
            individualStats[i].calculateDerived();
            if (this.m_debug) {
                System.err.println("Remaining error: " + raceBitSets[i].toString() + " " + individualStats[i].mean);
            }
            if (!(individualStats[i].mean < bestError)) continue;
            bestError = individualStats[i].mean;
            bestIndex = i;
        }
        double[] retInfo = new double[]{bestIndex, bestError};
        if (this.m_debug) {
            System.err.print("Best set from race : ");
            for (int i = 0; i < this.m_numAttribs; ++i) {
                if (raceSets[bestIndex][i] == '1') {
                    System.err.print('1');
                    continue;
                }
                System.err.print('0');
            }
            System.err.println(" :" + bestError + " Processed : " + processedCount + "\n" + individualStats[bestIndex].toString());
        }
        return retInfo;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("\tRaceSearch.\n\tRace type : ");
        switch (this.m_raceType) {
            case 0: {
                text.append("forward selection race\n\tBase set : no attributes");
                break;
            }
            case 1: {
                text.append("backward elimination race\n\tBase set : all attributes");
                break;
            }
            case 2: {
                text.append("schemata race\n\tBase set : no attributes");
                break;
            }
            case 3: {
                int i;
                text.append("rank race\n\tBase set : no attributes\n\t");
                text.append("Attribute evaluator : " + this.getAttributeEvaluator().getClass().getName() + " ");
                if (this.m_ASEval instanceof OptionHandler) {
                    String[] evaluatorOptions = new String[]{};
                    evaluatorOptions = ((OptionHandler)((Object)this.m_ASEval)).getOptions();
                    for (i = 0; i < evaluatorOptions.length; ++i) {
                        text.append(evaluatorOptions[i] + ' ');
                    }
                }
                text.append("\n");
                text.append("\tAttribute ranking : \n");
                int rlength = (int)(Math.log(this.m_Ranking.length) / Math.log(10.0) + 1.0);
                for (i = 0; i < this.m_Ranking.length; ++i) {
                    text.append("\t " + Utils.doubleToString(this.m_Ranking[i] + 1, rlength, 0) + " " + this.m_Instances.attribute(this.m_Ranking[i]).name() + '\n');
                }
                break;
            }
        }
        text.append("\n\tCross validation mode : ");
        if (this.m_xvalType == 0) {
            text.append("10 fold");
        } else {
            text.append("Leave-one-out");
        }
        text.append("\n\tMerit of best subset found : ");
        int fieldwidth = 3;
        double precision = this.m_bestMerit - (double)((int)this.m_bestMerit);
        if (Math.abs(this.m_bestMerit) > 0.0) {
            fieldwidth = (int)Math.abs(Math.log(Math.abs(this.m_bestMerit)) / Math.log(10.0)) + 2;
        }
        precision = Math.abs(precision) > 0.0 ? Math.abs(Math.log(Math.abs(precision)) / Math.log(10.0)) + 3.0 : 2.0;
        text.append(Utils.doubleToString(Math.abs(this.m_bestMerit), fieldwidth + (int)precision, (int)precision) + "\n");
        return text.toString();
    }

    protected void resetOptions() {
        this.m_sigLevel = 0.001;
        this.m_delta = 0.001;
        this.m_ASEval = new GainRatioAttributeEval();
        this.m_Ranking = null;
        this.m_raceType = 0;
        this.m_debug = false;
        this.m_theEvaluator = null;
        this.m_bestMerit = -1.7976931348623157E308;
        this.m_numFolds = 10;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.26 $");
    }
}

