/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.EnsembleLibraryModelComparator;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.gui.ensembleLibraryEditor.LibrarySerialization;

public class EnsembleLibrary
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -7987178904923706760L;
    public static final String XML_FILE_EXTENSION = ".model.xml";
    public static final String FLAT_FILE_EXTENSION = ".mlf";
    public TreeSet m_Models;
    private transient PropertyChangeSupport m_LibraryPropertySupport = new PropertyChangeSupport(this);

    public EnsembleLibrary() {
        this.m_Models = new TreeSet(new EnsembleLibraryModelComparator());
    }

    public int size() {
        if (this.m_Models != null) {
            return this.m_Models.size();
        }
        return 0;
    }

    public void addModel(EnsembleLibraryModel model) {
        this.m_Models.add(model);
        if (this.m_LibraryPropertySupport != null) {
            this.m_LibraryPropertySupport.firePropertyChange(null, null, null);
        }
    }

    public void addModel(String modelString) {
        this.m_Models.add(this.createModel(modelString));
        this.m_LibraryPropertySupport.firePropertyChange(null, null, null);
    }

    public void removeModel(EnsembleLibraryModel model) {
        this.m_Models.remove(model);
        this.m_LibraryPropertySupport.firePropertyChange(null, null, null);
    }

    public EnsembleLibraryModel createModel(Classifier classifier) {
        EnsembleLibraryModel model = new EnsembleLibraryModel(classifier);
        return model;
    }

    public EnsembleLibraryModel createModel(String modelString) {
        String[] splitString = modelString.split("\\s+");
        String className = splitString[0];
        String argString = modelString.replaceAll(splitString[0], "");
        String[] optionStrings = argString.split("\\s+");
        EnsembleLibraryModel model = null;
        try {
            model = new EnsembleLibraryModel(AbstractClassifier.forName(className, optionStrings));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public TreeSet getModels() {
        return this.m_Models;
    }

    public void setModels(TreeSet models) {
        this.m_Models = models;
        this.m_LibraryPropertySupport.firePropertyChange(null, null, null);
    }

    public void clearModels() {
        this.m_Models.clear();
        this.m_LibraryPropertySupport.firePropertyChange(null, null, null);
    }

    public static void loadLibrary(File selectedFile, JComponent dialogParent, EnsembleLibrary library) {
        try {
            EnsembleLibrary.loadLibrary(selectedFile, library);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(dialogParent, "Error reading file '" + selectedFile.getName() + "':\n" + ex.getMessage(), "Load failed", 0);
            System.err.println(ex.getMessage());
        }
    }

    public static void loadLibrary(File selectedFile, EnsembleLibrary library) throws Exception {
        if (selectedFile.getName().toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            Vector classifiers = null;
            try {
                LibrarySerialization librarySerialization = new LibrarySerialization();
                classifiers = (Vector)librarySerialization.read(selectedFile.getPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Iterator it = classifiers.iterator();
            while (it.hasNext()) {
                EnsembleLibraryModel model = library.createModel((Classifier)it.next());
                model.testOptions();
                library.addModel(model);
            }
        } else if (selectedFile.getName().toLowerCase().endsWith(FLAT_FILE_EXTENSION)) {
            String modelString;
            BufferedReader reader = null;
            reader = new BufferedReader(new FileReader(selectedFile));
            while ((modelString = reader.readLine()) != null) {
                EnsembleLibraryModel model = library.createModel(modelString);
                if (model != null) {
                    model.testOptions();
                    library.addModel(model);
                    continue;
                }
                System.err.println("Failed to create model: " + modelString);
            }
            reader.close();
        }
    }

    public static void loadLibrary(InputStream stream, EnsembleLibrary library) throws Exception {
        Vector classifiers = null;
        try {
            LibrarySerialization librarySerialization = new LibrarySerialization();
            classifiers = (Vector)librarySerialization.read(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < classifiers.size(); ++i) {
            EnsembleLibraryModel model = library.createModel((Classifier)classifiers.get(i));
            model.testOptions();
            library.addModel(model);
        }
    }

    public static void saveLibrary(File selectedFile, EnsembleLibrary library, JComponent dialogParent) {
        if (selectedFile.getName().toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            Vector<Classifier> classifiers = new Vector<Classifier>();
            for (EnsembleLibraryModel model : library.getModels()) {
                classifiers.add(model.getClassifier());
            }
            try {
                LibrarySerialization librarySerialization = new LibrarySerialization();
                librarySerialization.write(selectedFile.getPath(), classifiers);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (selectedFile.getName().toLowerCase().endsWith(FLAT_FILE_EXTENSION)) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(selectedFile));
                for (EnsembleLibraryModel model : library.getModels()) {
                    writer.write(model.getStringRepresentation() + "\n");
                }
                ((Writer)writer).close();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(dialogParent, "Error writing file '" + selectedFile.getName() + "':\n" + ex.getMessage(), "Save failed", 0);
                System.err.println(ex.getMessage());
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_LibraryPropertySupport != null) {
            this.m_LibraryPropertySupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6041 $");
    }
}

