/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import weka.classifiers.Classifier;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.gui.GenericObjectEditor;

public class EnsembleLibraryModel
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 7932816660173443200L;
    protected Classifier m_Classifier;
    protected String m_DescriptionText;
    protected String m_ErrorText;
    protected boolean m_OptionsWereValid;
    protected String m_StringRepresentation;

    public EnsembleLibraryModel() {
    }

    public EnsembleLibraryModel(Classifier classifier) {
        this.m_Classifier = classifier;
        this.m_StringRepresentation = this.toString();
        this.updateDescriptionText();
    }

    public void testOptions() {
        Classifier testClassifier = null;
        try {
            testClassifier = (Classifier)this.m_Classifier.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.setOptionsWereValid(true);
        this.setErrorText(null);
        this.updateDescriptionText();
        try {
            ((OptionHandler)((Object)testClassifier)).setOptions(((OptionHandler)((Object)this.m_Classifier)).getOptions());
        }
        catch (Exception e) {
            this.setOptionsWereValid(false);
            this.setErrorText(e.getMessage());
        }
        this.updateDescriptionText();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String getStringRepresentation() {
        return this.m_StringRepresentation;
    }

    public void setDescriptionText(String descriptionText) {
        this.m_DescriptionText = descriptionText;
    }

    public String getDescriptionText() {
        return this.m_DescriptionText;
    }

    public void setErrorText(String errorText) {
        this.m_ErrorText = errorText;
    }

    public String getErrorText() {
        return this.m_ErrorText;
    }

    public void setOptionsWereValid(boolean optionsWereValid) {
        this.m_OptionsWereValid = optionsWereValid;
    }

    public boolean getOptionsWereValid() {
        return this.m_OptionsWereValid;
    }

    public String toString() {
        String str = this.m_Classifier.getClass().getName();
        str = str + " " + Utils.joinOptions(((OptionHandler)((Object)this.m_Classifier)).getOptions());
        return str;
    }

    public Class getModelClass() {
        return this.m_Classifier.getClass();
    }

    public String[] getOptions() {
        return ((OptionHandler)((Object)this.m_Classifier)).getOptions();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.m_Classifier);
        stream.writeObject(this.m_DescriptionText);
        stream.writeObject(this.m_ErrorText);
        stream.writeObject(new Boolean(this.m_OptionsWereValid));
        stream.writeObject(this.m_StringRepresentation);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.m_Classifier = (Classifier)stream.readObject();
        this.m_DescriptionText = (String)stream.readObject();
        this.m_ErrorText = (String)stream.readObject();
        this.m_OptionsWereValid = (Boolean)stream.readObject();
        this.m_StringRepresentation = (String)stream.readObject();
    }

    public void updateDescriptionText() {
        String toolTipText = new String("<html>");
        if (!this.m_OptionsWereValid) {
            toolTipText = toolTipText + "<font COLOR=\"#FF0000\"><b>Invalid Model:</b><br>" + this.m_ErrorText + "<br></font>";
        }
        toolTipText = toolTipText + "<TABLE>";
        PropertyDescriptor[] properties = null;
        MethodDescriptor[] methods = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.m_Classifier.getClass());
            properties = bi.getPropertyDescriptors();
            methods = bi.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            System.err.println("LibraryModel: Couldn't introspect");
            return;
        }
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i].isHidden() || properties[i].isExpert()) continue;
            String name = properties[i].getDisplayName();
            Class<?> type = properties[i].getPropertyType();
            Method getter = properties[i].getReadMethod();
            Method setter = properties[i].getWriteMethod();
            if (getter == null || setter == null) continue;
            try {
                Object[] args = new Object[]{};
                Object value = getter.invoke((Object)this.m_Classifier, args);
                PropertyEditor editor = null;
                Class<?> pec = properties[i].getPropertyEditorClass();
                if (pec != null) {
                    try {
                        editor = (PropertyEditor)pec.newInstance();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (editor == null) {
                    editor = PropertyEditorManager.findEditor(type);
                }
                if (editor == null) continue;
                if (editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)editor).setClassType(type);
                }
                if (value == null) continue;
                toolTipText = toolTipText + "<TR><TD>" + name + "</TD><TD>" + value.toString() + "</TD></TR>";
                continue;
            }
            catch (InvocationTargetException ex) {
                System.err.println("Skipping property " + name + " ; exception on target: " + ex.getTargetException());
                ex.getTargetException().printStackTrace();
                continue;
            }
            catch (Exception ex) {
                System.err.println("Skipping property " + name + " ; exception: " + ex);
                ex.printStackTrace();
            }
        }
        toolTipText = toolTipText + "</TABLE>";
        this.m_DescriptionText = toolTipText = toolTipText + "</html>";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6041 $");
    }
}

