/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.blr;

import weka.classifiers.bayes.BayesianLogisticRegression;
import weka.classifiers.bayes.blr.Prior;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class LaplacePriorImpl
extends Prior {
    private static final long serialVersionUID = 2353576123257012607L;
    Instances m_Instances;
    double Beta;
    double Hyperparameter;
    double DeltaUpdate;
    double[] R;
    double Delta;

    @Override
    public double update(int j, Instances instances, double beta, double hyperparameter, double[] r, double deltaV) {
        double sign = 0.0;
        double change = 0.0;
        this.DeltaUpdate = 0.0;
        this.m_Instances = instances;
        this.Beta = beta;
        this.Hyperparameter = hyperparameter;
        this.R = r;
        this.Delta = deltaV;
        if (this.Beta == 0.0) {
            sign = 1.0;
            this.DeltaUpdate = this.laplaceUpdate(j, sign);
            if (this.DeltaUpdate <= 0.0) {
                sign = -1.0;
                this.DeltaUpdate = this.laplaceUpdate(j, sign);
                if (this.DeltaUpdate >= 0.0) {
                    this.DeltaUpdate = 0.0;
                }
            }
        } else {
            sign = this.Beta / Math.abs(this.Beta);
            this.DeltaUpdate = this.laplaceUpdate(j, sign);
            change = this.Beta + this.DeltaUpdate;
            if ((change /= Math.abs(change)) < 0.0) {
                this.DeltaUpdate = 0.0 - this.Beta;
            }
        }
        return this.DeltaUpdate;
    }

    public double laplaceUpdate(int j, double sign) {
        double value = 0.0;
        double numerator = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            Instance instance = this.m_Instances.instance(i);
            if (instance.value(j) == 0.0) continue;
            numerator += instance.value(j) * BayesianLogisticRegression.classSgn(instance.classValue()) * (1.0 / (1.0 + Math.exp(this.R[i])));
            denominator += instance.value(j) * instance.value(j) * BayesianLogisticRegression.bigF(this.R[i], this.Delta * instance.value(j));
        }
        numerator -= Math.sqrt(2.0 / this.Hyperparameter) * sign;
        if (denominator != 0.0) {
            value = numerator / denominator;
        }
        return value;
    }

    public void computeLogLikelihood(double[] betas, Instances instances) {
        super.computelogLikelihood(betas, instances);
    }

    @Override
    public void computePenalty(double[] betas, double[] hyperparameters) {
        this.penalty = 0.0;
        double lambda = 0.0;
        for (int j = 0; j < betas.length; ++j) {
            lambda = Math.sqrt(hyperparameters[j]);
            this.penalty += Math.log(2.0) - Math.log(lambda) + lambda * Math.abs(betas[j]);
        }
        this.penalty = 0.0 - this.penalty;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4899 $");
    }
}

