/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.FileReader;
import java.io.Serializable;
import weka.classifiers.bayes.net.VaryNode;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class ADNode
implements Serializable,
TechnicalInformationHandler,
RevisionHandler {
    static final long serialVersionUID = 397409728366910204L;
    static final int MIN_RECORD_SIZE = 0;
    public VaryNode[] m_VaryNodes;
    public Instance[] m_Instances;
    public int m_nCount;
    public int m_nStartNode;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Andrew W. Moore and Mary S. Lee");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Cached Sufficient Statistics for Efficient Machine Learning with Large Datasets");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Journal of Artificial Intelligence Research");
        result.setValue(TechnicalInformation.Field.VOLUME, "8");
        result.setValue(TechnicalInformation.Field.PAGES, "67-91");
        return result;
    }

    public static VaryNode makeVaryNode(int iNode, FastVector nRecords, Instances instances) {
        int iChild;
        VaryNode _VaryNode = new VaryNode(iNode);
        int nValues = instances.attribute(iNode).numValues();
        FastVector[] nChildRecords = new FastVector[nValues];
        for (int iChild2 = 0; iChild2 < nValues; ++iChild2) {
            nChildRecords[iChild2] = new FastVector();
        }
        for (int iRecord = 0; iRecord < nRecords.size(); ++iRecord) {
            int iInstance = (Integer)nRecords.elementAt(iRecord);
            nChildRecords[(int)instances.instance(iInstance).value(iNode)].addElement(new Integer(iInstance));
        }
        int nCount = nChildRecords[0].size();
        int nMCV = 0;
        for (iChild = 1; iChild < nValues; ++iChild) {
            if (nChildRecords[iChild].size() <= nCount) continue;
            nCount = nChildRecords[iChild].size();
            nMCV = iChild;
        }
        _VaryNode.m_nMCV = nMCV;
        _VaryNode.m_ADNodes = new ADNode[nValues];
        for (iChild = 0; iChild < nValues; ++iChild) {
            _VaryNode.m_ADNodes[iChild] = iChild == nMCV || nChildRecords[iChild].size() == 0 ? null : ADNode.makeADTree(iNode + 1, nChildRecords[iChild], instances);
        }
        return _VaryNode;
    }

    public static ADNode makeADTree(int iNode, FastVector nRecords, Instances instances) {
        ADNode _ADNode = new ADNode();
        _ADNode.m_nCount = nRecords.size();
        _ADNode.m_nStartNode = iNode;
        if (nRecords.size() < 0) {
            _ADNode.m_Instances = new Instance[nRecords.size()];
            for (int iInstance = 0; iInstance < nRecords.size(); ++iInstance) {
                _ADNode.m_Instances[iInstance] = instances.instance((Integer)nRecords.elementAt(iInstance));
            }
        } else {
            _ADNode.m_VaryNodes = new VaryNode[instances.numAttributes() - iNode];
            for (int iNode2 = iNode; iNode2 < instances.numAttributes(); ++iNode2) {
                _ADNode.m_VaryNodes[iNode2 - iNode] = ADNode.makeVaryNode(iNode2, nRecords, instances);
            }
        }
        return _ADNode;
    }

    public static ADNode makeADTree(Instances instances) {
        FastVector<Integer> nRecords = new FastVector<Integer>(instances.numInstances());
        for (int iRecord = 0; iRecord < instances.numInstances(); ++iRecord) {
            nRecords.addElement(new Integer(iRecord));
        }
        return ADNode.makeADTree(0, nRecords, instances);
    }

    public void getCounts(int[] nCounts, int[] nNodes, int[] nOffsets, int iNode, int iOffset, boolean bSubstract) {
        if (iNode >= nNodes.length) {
            if (bSubstract) {
                int n = iOffset;
                nCounts[n] = nCounts[n] - this.m_nCount;
            } else {
                int n = iOffset;
                nCounts[n] = nCounts[n] + this.m_nCount;
            }
            return;
        }
        if (this.m_VaryNodes != null) {
            this.m_VaryNodes[nNodes[iNode] - this.m_nStartNode].getCounts(nCounts, nNodes, nOffsets, iNode, iOffset, this, bSubstract);
        } else {
            for (int iInstance = 0; iInstance < this.m_Instances.length; ++iInstance) {
                int iOffset2 = iOffset;
                Instance instance = this.m_Instances[iInstance];
                for (int iNode2 = iNode; iNode2 < nNodes.length; ++iNode2) {
                    iOffset2 += nOffsets[iNode2] * (int)instance.value(nNodes[iNode2]);
                }
                if (bSubstract) {
                    int n = iOffset2;
                    nCounts[n] = nCounts[n] - 1;
                    continue;
                }
                int n = iOffset2;
                nCounts[n] = nCounts[n] + 1;
            }
        }
    }

    public void print() {
        String sTab = new String();
        for (int i = 0; i < this.m_nStartNode; ++i) {
            sTab = sTab + "  ";
        }
        System.out.println(sTab + "Count = " + this.m_nCount);
        if (this.m_VaryNodes != null) {
            for (int iNode = 0; iNode < this.m_VaryNodes.length; ++iNode) {
                System.out.println(sTab + "Node " + (iNode + this.m_nStartNode));
                this.m_VaryNodes[iNode].print(sTab);
            }
        } else {
            System.out.println(this.m_Instances);
        }
    }

    public static void main(String[] argv) {
        try {
            Instances instances = new Instances(new FileReader("\\iris.2.arff"));
            ADNode ADTree2 = ADNode.makeADTree(instances);
            int[] nCounts = new int[12];
            int[] nNodes = new int[3];
            int[] nOffsets = new int[3];
            nNodes[0] = 0;
            nNodes[1] = 3;
            nNodes[2] = 4;
            nOffsets[0] = 2;
            nOffsets[1] = 1;
            nOffsets[2] = 4;
            ADTree2.print();
            ADTree2.getCounts(nCounts, nNodes, nOffsets, 0, 0, false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }
}

