/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableClassifier;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibrary;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibraryModel;
import weka.classifiers.meta.ensembleSelection.ModelBag;
import weka.classifiers.trees.REPTree;
import weka.classifiers.xml.XMLClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XMLOptions;

public class EnsembleSelection
extends RandomizableClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -1744155148765058511L;
    protected EnsembleSelectionLibrary m_library = new EnsembleSelectionLibrary();
    protected EnsembleSelectionLibraryModel[] m_chosen_models = null;
    protected int[] m_chosen_model_weights = null;
    protected int m_total_weight = 0;
    protected double m_modelRatio = 0.5;
    protected double m_validationRatio = 0.25;
    public static final Tag[] TAGS_METRIC = new Tag[]{new Tag(0, "Optimize with Accuracy"), new Tag(1, "Optimize with RMSE"), new Tag(2, "Optimize with ROC"), new Tag(3, "Optimize with precision"), new Tag(4, "Optimize with recall"), new Tag(5, "Optimize with fscore"), new Tag(6, "Optimize with all metrics")};
    public static final int ALGORITHM_FORWARD = 0;
    public static final int ALGORITHM_BACKWARD = 1;
    public static final int ALGORITHM_FORWARD_BACKWARD = 2;
    public static final int ALGORITHM_BEST = 3;
    public static final int ALGORITHM_BUILD_LIBRARY = 4;
    public static final Tag[] TAGS_ALGORITHM = new Tag[]{new Tag(0, "Forward selection"), new Tag(1, "Backward elimation"), new Tag(2, "Forward Selection + Backward Elimination"), new Tag(3, "Best model"), new Tag(4, "Build Library Only")};
    private static final int MAX_DEFAULT_DIRECTORIES = 1000;
    protected String m_modelLibraryFileName = null;
    protected int m_numModelBags = 10;
    protected int m_hillclimbMetric = 1;
    protected int m_algorithm = 0;
    protected int m_hillclimbIterations = 100;
    protected double m_sortInitializationRatio = 1.0;
    protected boolean m_replacement = true;
    protected boolean m_greedySortInitialization = true;
    protected boolean m_verboseOutput = false;
    protected Map m_cachedPredictions = null;
    protected File m_workingDirectory = new File(EnsembleSelection.getDefaultWorkingDirectory());
    protected int m_NumFolds = 1;

    public String globalInfo() {
        return "Combines several classifiers using the ensemble selection method. For more information, see: Caruana, Rich, Niculescu, Alex, Crew, Geoff, and Ksikes, Alex, Ensemble Selection from Libraries of Models, The International Conference on Machine Learning (ICML'04), 2004.  Implemented in Weka by Bob Jung and David Michael.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecifies the Model Library File, continuing the list of all models.", "L", 1, "-L </path/to/modelLibrary>"));
        result.addElement(new Option("\tSpecifies the Working Directory, where all models will be stored.", "W", 1, "-W </path/to/working/directory>"));
        result.addElement(new Option("\tSet the number of bags, i.e., number of iterations to run \n\tthe ensemble selection algorithm.", "B", 1, "-B <numModelBags>"));
        result.addElement(new Option("\tSet the ratio of library models that will be randomly chosen \n\tto populate each bag of models.", "E", 1, "-E <modelRatio>"));
        result.addElement(new Option("\tSet the ratio of the training data set that will be reserved \n\tfor validation.", "V", 1, "-V <validationRatio>"));
        result.addElement(new Option("\tSet the number of hillclimbing iterations to be performed \n\ton each model bag.", "H", 1, "-H <hillClimbIterations>"));
        result.addElement(new Option("\tSet the the ratio of the ensemble library that the sort \n\tinitialization algorithm will be able to choose from while \n\tinitializing the ensemble for each model bag", "I", 1, "-I <sortInitialization>"));
        result.addElement(new Option("\tSets the number of cross-validation folds.", "X", 1, "-X <numFolds>"));
        result.addElement(new Option("\tSpecify the metric that will be used for model selection \n\tduring the hillclimbing algorithm.\n\tValid metrics are: \n\t\taccuracy, rmse, roc, precision, recall, fscore, all", "P", 1, "-P <hillclimbMettric>"));
        result.addElement(new Option("\tSpecifies the algorithm to be used for ensemble selection. \n\tValid algorithms are:\n\t\t\"forward\" (default) for forward selection.\n\t\t\"backward\" for backward elimination.\n\t\t\"both\" for both forward and backward elimination.\n\t\t\"best\" to simply print out top performer from the \n\t\t   ensemble library\n\t\t\"library\" to only train the models in the ensemble \n\t\t   library", "A", 1, "-A <algorithm>"));
        result.addElement(new Option("\tFlag whether or not models can be selected more than once \n\tfor an ensemble.", "R", 0, "-R"));
        result.addElement(new Option("\tWhether sort initialization greedily stops adding models \n\twhen performance degrades.", "G", 0, "-G"));
        result.addElement(new Option("\tFlag for verbose output. Prints out performance of all \n\tselected models.", "O", 0, "-O"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            result.addElement((Option)enu.nextElement());
        }
        return result.elements();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.BINARY_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.BINARY_CLASS);
        return result;
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('L', options);
        if (tmpStr.length() != 0) {
            this.m_modelLibraryFileName = tmpStr;
            this.m_library = new EnsembleSelectionLibrary(this.m_modelLibraryFileName);
        } else {
            this.setLibrary(new EnsembleSelectionLibrary());
        }
        tmpStr = Utils.getOption('W', options);
        this.m_workingDirectory = tmpStr.length() != 0 && this.validWorkingDirectory(tmpStr) ? new File(tmpStr) : new File(EnsembleSelection.getDefaultWorkingDirectory());
        this.m_library.setWorkingDirectory(this.m_workingDirectory);
        tmpStr = Utils.getOption('E', options);
        if (tmpStr.length() != 0) {
            this.setModelRatio(Double.parseDouble(tmpStr));
        } else {
            this.setModelRatio(1.0);
        }
        tmpStr = Utils.getOption('V', options);
        if (tmpStr.length() != 0) {
            this.setValidationRatio(Double.parseDouble(tmpStr));
        } else {
            this.setValidationRatio(0.25);
        }
        tmpStr = Utils.getOption('B', options);
        if (tmpStr.length() != 0) {
            this.setNumModelBags(Integer.parseInt(tmpStr));
        } else {
            this.setNumModelBags(10);
        }
        tmpStr = Utils.getOption('H', options);
        if (tmpStr.length() != 0) {
            this.setHillclimbIterations(Integer.parseInt(tmpStr));
        } else {
            this.setHillclimbIterations(100);
        }
        tmpStr = Utils.getOption('I', options);
        if (tmpStr.length() != 0) {
            this.setSortInitializationRatio(Double.parseDouble(tmpStr));
        } else {
            this.setSortInitializationRatio(1.0);
        }
        tmpStr = Utils.getOption('X', options);
        if (tmpStr.length() != 0) {
            this.setNumFolds(Integer.parseInt(tmpStr));
        } else {
            this.setNumFolds(10);
        }
        this.setReplacement(Utils.getFlag('R', options));
        this.setGreedySortInitialization(Utils.getFlag('G', options));
        this.setVerboseOutput(Utils.getFlag('O', options));
        tmpStr = Utils.getOption('P', options);
        if (tmpStr.toLowerCase().equals("accuracy")) {
            this.setHillclimbMetric(new SelectedTag(0, TAGS_METRIC));
        } else if (tmpStr.toLowerCase().equals("rmse")) {
            this.setHillclimbMetric(new SelectedTag(1, TAGS_METRIC));
        } else if (tmpStr.toLowerCase().equals("roc")) {
            this.setHillclimbMetric(new SelectedTag(2, TAGS_METRIC));
        } else if (tmpStr.toLowerCase().equals("precision")) {
            this.setHillclimbMetric(new SelectedTag(3, TAGS_METRIC));
        } else if (tmpStr.toLowerCase().equals("recall")) {
            this.setHillclimbMetric(new SelectedTag(4, TAGS_METRIC));
        } else if (tmpStr.toLowerCase().equals("fscore")) {
            this.setHillclimbMetric(new SelectedTag(5, TAGS_METRIC));
        } else if (tmpStr.toLowerCase().equals("all")) {
            this.setHillclimbMetric(new SelectedTag(6, TAGS_METRIC));
        } else {
            this.setHillclimbMetric(new SelectedTag(1, TAGS_METRIC));
        }
        tmpStr = Utils.getOption('A', options);
        if (tmpStr.toLowerCase().equals("forward")) {
            this.setAlgorithm(new SelectedTag(0, TAGS_ALGORITHM));
        } else if (tmpStr.toLowerCase().equals("backward")) {
            this.setAlgorithm(new SelectedTag(1, TAGS_ALGORITHM));
        } else if (tmpStr.toLowerCase().equals("both")) {
            this.setAlgorithm(new SelectedTag(2, TAGS_ALGORITHM));
        } else if (tmpStr.toLowerCase().equals("forward")) {
            this.setAlgorithm(new SelectedTag(0, TAGS_ALGORITHM));
        } else if (tmpStr.toLowerCase().equals("best")) {
            this.setAlgorithm(new SelectedTag(3, TAGS_ALGORITHM));
        } else if (tmpStr.toLowerCase().equals("library")) {
            this.setAlgorithm(new SelectedTag(4, TAGS_ALGORITHM));
        } else {
            this.setAlgorithm(new SelectedTag(0, TAGS_ALGORITHM));
        }
        super.setOptions(options);
        this.m_library.setDebug(this.m_Debug);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.m_library.getModelListFile() != null) {
            result.add("-L");
            result.add("" + this.m_library.getModelListFile());
        }
        if (!this.m_workingDirectory.equals("")) {
            result.add("-W");
            result.add("" + this.getWorkingDirectory());
        }
        result.add("-P");
        switch (this.getHillclimbMetric().getSelectedTag().getID()) {
            case 0: {
                result.add("accuracy");
                break;
            }
            case 1: {
                result.add("rmse");
                break;
            }
            case 2: {
                result.add("roc");
                break;
            }
            case 3: {
                result.add("precision");
                break;
            }
            case 4: {
                result.add("recall");
                break;
            }
            case 5: {
                result.add("fscore");
                break;
            }
            case 6: {
                result.add("all");
            }
        }
        result.add("-A");
        switch (this.getAlgorithm().getSelectedTag().getID()) {
            case 0: {
                result.add("forward");
                break;
            }
            case 1: {
                result.add("backward");
                break;
            }
            case 2: {
                result.add("both");
                break;
            }
            case 3: {
                result.add("best");
                break;
            }
            case 4: {
                result.add("library");
            }
        }
        result.add("-B");
        result.add("" + this.getNumModelBags());
        result.add("-V");
        result.add("" + this.getValidationRatio());
        result.add("-E");
        result.add("" + this.getModelRatio());
        result.add("-H");
        result.add("" + this.getHillclimbIterations());
        result.add("-I");
        result.add("" + this.getSortInitializationRatio());
        result.add("-X");
        result.add("" + this.getNumFolds());
        if (this.m_replacement) {
            result.add("-R");
        }
        if (this.m_greedySortInitialization) {
            result.add("-G");
        }
        if (this.m_verboseOutput) {
            result.add("-O");
        }
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public String numFoldsTipText() {
        return "The number of folds used for cross-validation.";
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int numFolds) throws Exception {
        if (numFolds < 0) {
            throw new IllegalArgumentException("EnsembleSelection: Number of cross-validation folds must be positive.");
        }
        this.m_NumFolds = numFolds;
    }

    public String libraryTipText() {
        return "An ensemble library.";
    }

    public EnsembleSelectionLibrary getLibrary() {
        return this.m_library;
    }

    public void setLibrary(EnsembleSelectionLibrary newLibrary) {
        this.m_library = newLibrary;
        this.m_library.setDebug(this.m_Debug);
    }

    public String modelRatioTipText() {
        return "The ratio of library models that will be randomly chosen to be used for each iteration.";
    }

    public double getModelRatio() {
        return this.m_modelRatio;
    }

    public void setModelRatio(double v) {
        this.m_modelRatio = v;
    }

    public String validationRatioTipText() {
        return "The ratio of the training data set that will be reserved for validation.";
    }

    public double getValidationRatio() {
        return this.m_validationRatio;
    }

    public void setValidationRatio(double v) {
        this.m_validationRatio = v;
    }

    public String hillclimbMetricTipText() {
        return "the metric that will be used to optimizer the chosen ensemble..";
    }

    public SelectedTag getHillclimbMetric() {
        return new SelectedTag(this.m_hillclimbMetric, TAGS_METRIC);
    }

    public void setHillclimbMetric(SelectedTag newType) {
        if (newType.getTags() == TAGS_METRIC) {
            this.m_hillclimbMetric = newType.getSelectedTag().getID();
        }
    }

    public String algorithmTipText() {
        return "the algorithm used to optimizer the ensemble";
    }

    public SelectedTag getAlgorithm() {
        return new SelectedTag(this.m_algorithm, TAGS_ALGORITHM);
    }

    public void setAlgorithm(SelectedTag newType) {
        if (newType.getTags() == TAGS_ALGORITHM) {
            this.m_algorithm = newType.getSelectedTag().getID();
        }
    }

    public String hillclimbIterationsTipText() {
        return "The number of hillclimbing iterations for the ensemble selection algorithm.";
    }

    public int getHillclimbIterations() {
        return this.m_hillclimbIterations;
    }

    public void setHillclimbIterations(int n) throws Exception {
        if (n < 0) {
            throw new IllegalArgumentException("EnsembleSelection: Number of hillclimb iterations must be positive.");
        }
        this.m_hillclimbIterations = n;
    }

    public String numModelBagsTipText() {
        return "The number of \"model bags\" used in the ensemble selection algorithm.";
    }

    public int getNumModelBags() {
        return this.m_numModelBags;
    }

    public void setNumModelBags(int n) throws Exception {
        if (n <= 0) {
            throw new IllegalArgumentException("EnsembleSelection: Number of model bags must be positive.");
        }
        this.m_numModelBags = n;
    }

    public String sortInitializationRatioTipText() {
        return "The ratio of library models to be used for sort initialization.";
    }

    public double getSortInitializationRatio() {
        return this.m_sortInitializationRatio;
    }

    public void setSortInitializationRatio(double v) {
        this.m_sortInitializationRatio = v;
    }

    public String replacementTipText() {
        return "Whether models in the library can be included more than once in an ensemble.";
    }

    public boolean getReplacement() {
        return this.m_replacement;
    }

    public void setReplacement(boolean newReplacement) {
        this.m_replacement = newReplacement;
    }

    public String greedySortInitializationTipText() {
        return "Whether sort initialization greedily stops adding models when performance degrades.";
    }

    public boolean getGreedySortInitialization() {
        return this.m_greedySortInitialization;
    }

    public void setGreedySortInitialization(boolean newGreedySortInitialization) {
        this.m_greedySortInitialization = newGreedySortInitialization;
    }

    public String verboseOutputTipText() {
        return "Whether metrics are printed for each model.";
    }

    public boolean getVerboseOutput() {
        return this.m_verboseOutput;
    }

    public void setVerboseOutput(boolean newVerboseOutput) {
        this.m_verboseOutput = newVerboseOutput;
    }

    public String workingDirectoryTipText() {
        return "The working directory of the ensemble - where trained models will be stored.";
    }

    public File getWorkingDirectory() {
        return this.m_workingDirectory;
    }

    public void setWorkingDirectory(File newWorkingDirectory) {
        if (this.m_Debug) {
            System.out.println("working directory changed to: " + newWorkingDirectory);
        }
        this.m_library.setWorkingDirectory(newWorkingDirectory);
        this.m_workingDirectory = newWorkingDirectory;
    }

    @Override
    public void buildClassifier(Instances trainData) throws Exception {
        this.getCapabilities().testWithFail(trainData);
        if (this.m_library.m_Models.size() == 0) {
            System.out.println("WARNING: No library file specified.  Using some default models.");
            System.out.println("You should specify a model list with -L <file> from the command line.");
            System.out.println("Or edit the list directly with the LibraryEditor from the GUI");
            for (int i = 0; i < 10; ++i) {
                REPTree tree = new REPTree();
                tree.setSeed(i);
                this.m_library.addModel(new EnsembleSelectionLibraryModel(tree));
            }
        }
        if (this.m_library == null) {
            this.m_library = new EnsembleSelectionLibrary();
            this.m_library.setDebug(this.m_Debug);
        }
        this.m_library.setNumFolds(this.getNumFolds());
        this.m_library.setValidationRatio(this.getValidationRatio());
        Instances data = this.m_library.trainAll(trainData, this.m_workingDirectory.getAbsolutePath(), this.m_algorithm);
        double[][][] predictions = this.m_library.getHillclimbPredictions();
        int numModels = predictions.length;
        int[] modelWeights = new int[numModels];
        this.m_total_weight = 0;
        Random rand = new Random(this.m_Seed);
        if (this.m_algorithm == 4) {
            return;
        }
        if (this.m_algorithm == 3) {
            ModelBag model_bag = new ModelBag(predictions, 1.0, this.m_Debug);
            int[] modelPicked = model_bag.sortInitialize(1, false, data, this.m_hillclimbMetric);
            modelWeights[modelPicked[0]] = 1;
        } else {
            if (this.m_Debug) {
                System.out.println("Starting hillclimbing algorithm: " + this.m_algorithm);
            }
            for (int i = 0; i < this.getNumModelBags(); ++i) {
                if (this.m_Debug) {
                    System.out.println("Starting on ensemble bag: " + i);
                }
                ModelBag modelBag = new ModelBag(predictions, this.getModelRatio(), this.m_Debug);
                modelBag.shuffle(rand);
                if (this.getSortInitializationRatio() > 0.0) {
                    modelBag.sortInitialize((int)(this.getSortInitializationRatio() * this.getModelRatio() * (double)numModels), this.getGreedySortInitialization(), data, this.m_hillclimbMetric);
                }
                if (this.m_algorithm == 1) {
                    modelBag.weightAll(1);
                }
                for (int j = 0; j < this.getHillclimbIterations(); ++j) {
                    if (this.m_algorithm == 0) {
                        modelBag.forwardSelect(this.getReplacement(), data, this.m_hillclimbMetric);
                        continue;
                    }
                    if (this.m_algorithm == 1) {
                        modelBag.backwardEliminate(data, this.m_hillclimbMetric);
                        continue;
                    }
                    if (this.m_algorithm != 2) continue;
                    modelBag.forwardSelectOrBackwardEliminate(this.getReplacement(), data, this.m_hillclimbMetric);
                }
                int[] bagWeights = modelBag.getModelWeights();
                for (int j = 0; j < bagWeights.length; ++j) {
                    int n = j;
                    modelWeights[n] = modelWeights[n] + bagWeights[j];
                }
            }
        }
        Set modelNames = this.m_library.getModelNames();
        String[] modelNamesArray = new String[this.m_library.size()];
        Iterator iter = modelNames.iterator();
        int libraryIndex = 0;
        int chosenModels = 0;
        while (iter.hasNext()) {
            modelNamesArray[libraryIndex] = (String)iter.next();
            int weightOfModel = modelWeights[libraryIndex++];
            this.m_total_weight += weightOfModel;
            if (weightOfModel <= 0) continue;
            ++chosenModels;
        }
        if (this.m_verboseOutput) {
            ModelBag bag = new ModelBag(predictions, 1.0, this.m_Debug);
            int[] modelIndexes = bag.sortInitialize(modelNamesArray.length, false, data, this.m_hillclimbMetric);
            double[] modelPerformance = bag.getIndividualPerformance(data, this.m_hillclimbMetric);
            for (int i = 0; i < modelIndexes.length; ++i) {
                System.out.println("" + modelPerformance[i] + " " + modelNamesArray[modelIndexes[i]]);
            }
        }
        this.m_chosen_models = new EnsembleSelectionLibraryModel[chosenModels];
        this.m_chosen_model_weights = new int[chosenModels];
        libraryIndex = 0;
        int chosenIndex = 0;
        iter = this.m_library.getModels().iterator();
        while (iter.hasNext()) {
            int weightOfModel = modelWeights[libraryIndex++];
            EnsembleSelectionLibraryModel model = (EnsembleSelectionLibraryModel)iter.next();
            if (weightOfModel <= 0) continue;
            this.m_chosen_models[chosenIndex] = model;
            this.m_chosen_model_weights[chosenIndex] = weightOfModel;
            ++chosenIndex;
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        int i;
        String stringInstance = instance.toString();
        double[][] cachedPreds = null;
        if (this.m_cachedPredictions != null && this.m_cachedPredictions.containsKey(stringInstance)) {
            cachedPreds = (double[][])this.m_cachedPredictions.get(stringInstance);
        }
        double[] prediction = new double[instance.numClasses()];
        for (i = 0; i < prediction.length; ++i) {
            prediction[i] = 0.0;
        }
        for (i = 0; i < this.m_chosen_models.length; ++i) {
            double[] predictionForThisModel = null;
            if (cachedPreds == null) {
                this.m_chosen_models[i].rehydrateModel(this.m_workingDirectory.getAbsolutePath());
                predictionForThisModel = this.m_chosen_models[i].getAveragePrediction(instance);
            } else {
                predictionForThisModel = cachedPreds[i];
            }
            if (predictionForThisModel == null) continue;
            for (int j = 0; j < prediction.length; ++j) {
                int n = j;
                prediction[n] = prediction[n] + (double)this.m_chosen_model_weights[i] * predictionForThisModel[j] / (double)this.m_total_weight;
            }
        }
        if (instance.classAttribute().isNominal() && Utils.sum(prediction) > 0.0) {
            Utils.normalize(prediction);
        }
        return prediction;
    }

    private boolean validWorkingDirectory(String dir) {
        boolean valid = false;
        File f = new File(dir);
        if (f.exists()) {
            if (f.isDirectory() && f.canWrite()) {
                valid = true;
            }
        } else if (f.canWrite()) {
            valid = true;
        }
        return valid;
    }

    public static String getDefaultWorkingDirectory() {
        String defaultDirectory = new String("");
        boolean success = false;
        for (int i = 1; i < 1000 && !success; ++i) {
            File f = new File(System.getProperty("user.home"), "Ensemble-" + i);
            if (f.exists() || !f.getParentFile().canWrite()) continue;
            defaultDirectory = f.getPath();
            success = true;
        }
        if (!success) {
            defaultDirectory = new String("");
        }
        return defaultDirectory;
    }

    public String toString() {
        String result = new String();
        if (this.m_chosen_models != null) {
            for (int i = 0; i < this.m_chosen_models.length; ++i) {
                result = result + this.m_chosen_model_weights[i];
                result = result + " " + this.m_chosen_models[i].getStringRepresentation() + "\n";
            }
        } else {
            result = "No models selected.";
        }
        return result;
    }

    private void cachePredictions(Instances test) throws Exception {
        this.m_cachedPredictions = new HashMap();
        Evaluation evalModel = null;
        Instances originalInstances = null;
        boolean printModelPerformances = this.getVerboseOutput();
        if (printModelPerformances) {
            originalInstances = new Instances(test);
        }
        for (int i = 0; i < this.m_chosen_models.length; ++i) {
            if (printModelPerformances) {
                evalModel = new Evaluation(originalInstances);
            }
            Date startTime = new Date();
            this.m_chosen_models[i].rehydrateModel(this.m_workingDirectory.getAbsolutePath());
            for (int j = 0; j < test.numInstances(); ++j) {
                Instance currentInstance = test.instance(j);
                currentInstance.setClassMissing();
                String stringInstance = currentInstance.toString();
                if (!this.m_cachedPredictions.containsKey(stringInstance)) {
                    int predSize = test.classAttribute().isNumeric() ? 1 : test.classAttribute().numValues();
                    double[][] predictionArray = new double[this.m_chosen_models.length][predSize];
                    this.m_cachedPredictions.put(stringInstance, predictionArray);
                }
                double[][] predictions = (double[][])this.m_cachedPredictions.get(stringInstance);
                predictions[i] = this.m_chosen_models[i].getAveragePrediction(test.instance(j));
                if (!printModelPerformances) continue;
                evalModel.evaluateModelOnceAndRecordPrediction(predictions[i], originalInstances.instance(j));
            }
            this.m_chosen_models[i].releaseModel();
            Date endTime = new Date();
            long diff = endTime.getTime() - startTime.getTime();
            if (this.m_Debug) {
                System.out.println("Test time for " + this.m_chosen_models[i].getStringRepresentation() + " was: " + diff);
            }
            if (!printModelPerformances) continue;
            String output = new String(this.m_chosen_models[i].getStringRepresentation() + ": ");
            output = output + "\tRMSE:" + evalModel.rootMeanSquaredError();
            output = output + "\tACC:" + evalModel.pctCorrect();
            if (test.numClasses() == 2) {
                output = output + "\tROC:" + evalModel.areaUnderROC(1);
                output = output + "\tPREC:" + evalModel.precision(1);
                output = output + "\tFSCR:" + evalModel.fMeasure(1);
            }
            System.out.println(output);
        }
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Rich Caruana, Alex Niculescu, Geoff Crew, and Alex Ksikes");
        result.setValue(TechnicalInformation.Field.TITLE, "Ensemble Selection from Libraries of Models");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "21st International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5480 $");
    }

    public static void main(String[] argv) {
        try {
            String[] options = (String[])argv.clone();
            String xml = Utils.getOption("xml", options);
            if (!xml.equals("")) {
                options = new XMLOptions(xml).toArray();
            }
            String trainFileName = Utils.getOption('t', options);
            String objectInputFileName = Utils.getOption('l', options);
            String testFileName = Utils.getOption('T', options);
            if (testFileName.length() != 0 && objectInputFileName.length() != 0 && trainFileName.length() == 0) {
                System.out.println("Caching predictions");
                EnsembleSelection classifier = null;
                BufferedReader testReader = new BufferedReader(new FileReader(testFileName));
                int classIndex = -1;
                String classIndexString = Utils.getOption('c', options);
                if (classIndexString.length() != 0) {
                    classIndex = Integer.parseInt(classIndexString);
                }
                Instances test = new Instances(testReader, 1);
                if (classIndex != -1) {
                    test.setClassIndex(classIndex - 1);
                } else {
                    test.setClassIndex(test.numAttributes() - 1);
                }
                if (classIndex > test.numAttributes()) {
                    throw new Exception("Index of class attribute too large.");
                }
                while (test.readInstance(testReader)) {
                }
                testReader.close();
                InputStream is = new FileInputStream(objectInputFileName);
                if (objectInputFileName.endsWith(".gz")) {
                    is = new GZIPInputStream(is);
                }
                if (!objectInputFileName.endsWith("UpdateableClassifier.koml") || !KOML.isPresent()) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(is);
                    classifier = (EnsembleSelection)objectInputStream.readObject();
                    objectInputStream.close();
                } else {
                    BufferedInputStream xmlInputStream = new BufferedInputStream(is);
                    classifier = (EnsembleSelection)KOML.read(xmlInputStream);
                    xmlInputStream.close();
                }
                String workingDir = Utils.getOption('W', argv);
                if (!workingDir.equals("")) {
                    classifier.setWorkingDirectory(new File(workingDir));
                }
                classifier.setDebug(Utils.getFlag('D', argv));
                classifier.setVerboseOutput(Utils.getFlag('O', argv));
                classifier.cachePredictions(test);
                String objectOutputFileName = objectInputFileName;
                OutputStream os = new FileOutputStream(objectOutputFileName);
                if (!(objectOutputFileName.endsWith(".xml") || objectOutputFileName.endsWith(".koml") && KOML.isPresent())) {
                    if (objectOutputFileName.endsWith(".gz")) {
                        os = new GZIPOutputStream(os);
                    }
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
                    objectOutputStream.writeObject(classifier);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                } else {
                    BufferedOutputStream xmlOutputStream = new BufferedOutputStream(os);
                    if (objectOutputFileName.endsWith(".xml")) {
                        XMLClassifier xmlSerial = new XMLClassifier();
                        xmlSerial.write(xmlOutputStream, (Object)classifier);
                    } else if (objectOutputFileName.endsWith(".koml")) {
                        KOML.write(xmlOutputStream, (Object)classifier);
                    }
                    xmlOutputStream.close();
                }
            }
            System.out.println(Evaluation.evaluateModel(new EnsembleSelection(), argv));
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf("General options") == -1) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
    }
}

