/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.meta.Bagging;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class MetaCost
extends RandomizableSingleClassifierEnhancer
implements TechnicalInformationHandler {
    static final long serialVersionUID = 1205317833344726855L;
    public static final int MATRIX_ON_DEMAND = 1;
    public static final int MATRIX_SUPPLIED = 2;
    public static final Tag[] TAGS_MATRIX_SOURCE = new Tag[]{new Tag(1, "Load cost matrix on demand"), new Tag(2, "Use explicit cost matrix")};
    protected int m_MatrixSource = 1;
    protected File m_OnDemandDirectory = new File(System.getProperty("user.dir"));
    protected String m_CostFile;
    protected CostMatrix m_CostMatrix = new CostMatrix(1);
    protected int m_NumIterations = 10;
    protected int m_BagSizePercent = 100;

    public String globalInfo() {
        return "This metaclassifier makes its base classifier cost-sensitive using the method specified in\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "This classifier should produce similar results to one created by " + "passing the base learner to Bagging, which is in turn passed to a " + "CostSensitiveClassifier operating on minimum expected cost. The difference " + "is that MetaCost produces a single cost-sensitive classifier of the " + "base learner, giving the benefits of fast classification and interpretable " + "output (if the base learner itself is interpretable). This implementation  " + "uses all bagging iterations when reclassifying training data (the MetaCost " + "paper reports a marginal improvement when only those iterations containing " + "each training instance are used in reclassifying that instance).";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Pedro Domingos");
        result.setValue(TechnicalInformation.Field.TITLE, "MetaCost: A general method for making classifiers cost-sensitive");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Fifth International Conference on Knowledge Discovery and Data Mining");
        result.setValue(TechnicalInformation.Field.YEAR, "1999");
        result.setValue(TechnicalInformation.Field.PAGES, "155-164");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(6);
        newVector.addElement(new Option("\tNumber of bagging iterations.\n\t(default 10)", "I", 1, "-I <num>"));
        newVector.addElement(new Option("\tFile name of a cost matrix to use. If this is not supplied,\n\ta cost matrix will be loaded on demand. The name of the\n\ton-demand file is the relation name of the training data\n\tplus \".cost\", and the path to the on-demand file is\n\tspecified with the -N option.", "C", 1, "-C <cost file name>"));
        newVector.addElement(new Option("\tName of a directory to search for cost files when loading\n\tcosts on demand (default current directory).", "N", 1, "-N <directory>"));
        newVector.addElement(new Option("\tThe cost matrix in Matlab single line format.", "cost-matrix", 1, "-cost-matrix <matrix>"));
        newVector.addElement(new Option("\tSize of each bag, as a percentage of the\n\ttraining set size. (default 100)", "P", 1, "-P"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String cost_matrix;
        String bagIterations = Utils.getOption('I', options);
        if (bagIterations.length() != 0) {
            this.setNumIterations(Integer.parseInt(bagIterations));
        } else {
            this.setNumIterations(10);
        }
        String bagSize = Utils.getOption('P', options);
        if (bagSize.length() != 0) {
            this.setBagSizePercent(Integer.parseInt(bagSize));
        } else {
            this.setBagSizePercent(100);
        }
        String costFile = Utils.getOption('C', options);
        if (costFile.length() != 0) {
            this.setCostMatrix(new CostMatrix(new BufferedReader(new FileReader(costFile))));
            this.setCostMatrixSource(new SelectedTag(2, TAGS_MATRIX_SOURCE));
            this.m_CostFile = costFile;
        } else {
            this.setCostMatrixSource(new SelectedTag(1, TAGS_MATRIX_SOURCE));
        }
        String demandDir = Utils.getOption('N', options);
        if (demandDir.length() != 0) {
            this.setOnDemandDirectory(new File(demandDir));
        }
        if ((cost_matrix = Utils.getOption("cost-matrix", options)).length() != 0) {
            StringWriter writer = new StringWriter();
            CostMatrix.parseMatlab(cost_matrix).write(writer);
            this.setCostMatrix(new CostMatrix(new StringReader(writer.toString())));
            this.setCostMatrixSource(new SelectedTag(2, TAGS_MATRIX_SOURCE));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 6];
        int current = 0;
        if (this.m_MatrixSource == 2) {
            if (this.m_CostFile != null) {
                options[current++] = "-C";
                options[current++] = "" + this.m_CostFile;
            } else {
                options[current++] = "-cost-matrix";
                options[current++] = this.getCostMatrix().toMatlab();
            }
        } else {
            options[current++] = "-N";
            options[current++] = "" + this.getOnDemandDirectory();
        }
        options[current++] = "-I";
        options[current++] = "" + this.getNumIterations();
        options[current++] = "-P";
        options[current++] = "" + this.getBagSizePercent();
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    public String costMatrixSourceTipText() {
        return "Gets the source location method of the cost matrix. Will be one of MATRIX_ON_DEMAND or MATRIX_SUPPLIED.";
    }

    public SelectedTag getCostMatrixSource() {
        return new SelectedTag(this.m_MatrixSource, TAGS_MATRIX_SOURCE);
    }

    public void setCostMatrixSource(SelectedTag newMethod) {
        if (newMethod.getTags() == TAGS_MATRIX_SOURCE) {
            this.m_MatrixSource = newMethod.getSelectedTag().getID();
        }
    }

    public String onDemandDirectoryTipText() {
        return "Name of directory to search for cost files when loading costs on demand.";
    }

    public File getOnDemandDirectory() {
        return this.m_OnDemandDirectory;
    }

    public void setOnDemandDirectory(File newDir) {
        this.m_OnDemandDirectory = newDir.isDirectory() ? newDir : new File(newDir.getParent());
        this.m_MatrixSource = 1;
    }

    public String bagSizePercentTipText() {
        return "The size of each bag, as a percentage of the training set size.";
    }

    public int getBagSizePercent() {
        return this.m_BagSizePercent;
    }

    public void setBagSizePercent(int newBagSizePercent) {
        this.m_BagSizePercent = newBagSizePercent;
    }

    public String numIterationsTipText() {
        return "The number of bagging iterations.";
    }

    public void setNumIterations(int numIterations) {
        this.m_NumIterations = numIterations;
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String costMatrixTipText() {
        return "A misclassification cost matrix.";
    }

    public CostMatrix getCostMatrix() {
        return this.m_CostMatrix;
    }

    public void setCostMatrix(CostMatrix newCostMatrix) {
        this.m_CostMatrix = newCostMatrix;
        this.m_MatrixSource = 2;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (this.m_MatrixSource == 1) {
            String costName = data.relationName() + CostMatrix.FILE_EXTENSION;
            File costFile = new File(this.getOnDemandDirectory(), costName);
            if (!costFile.exists()) {
                throw new Exception("On-demand cost file doesn't exist: " + costFile);
            }
            this.setCostMatrix(new CostMatrix(new BufferedReader(new FileReader(costFile))));
        }
        Bagging bagger = new Bagging();
        bagger.setClassifier(this.getClassifier());
        bagger.setSeed(this.getSeed());
        bagger.setNumIterations(this.getNumIterations());
        bagger.setBagSizePercent(this.getBagSizePercent());
        bagger.buildClassifier(data);
        Instances newData = new Instances(data);
        for (int i = 0; i < newData.numInstances(); ++i) {
            Instance current = newData.instance(i);
            double[] pred = bagger.distributionForInstance(current);
            int minCostPred = Utils.minIndex(this.m_CostMatrix.expectedCosts(pred));
            current.setClassValue(minCostPred);
        }
        this.m_Classifier.buildClassifier(newData);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_Classifier.distributionForInstance(instance);
    }

    @Override
    protected String getClassifierSpec() {
        Classifier c = this.getClassifier();
        return c.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)c)).getOptions());
    }

    public String toString() {
        if (this.m_Classifier == null) {
            return "MetaCost: No model built yet.";
        }
        String result = "MetaCost cost sensitive classifier induction";
        result = result + "\nOptions: " + Utils.joinOptions(this.getOptions());
        result = result + "\nBase learner: " + this.getClassifierSpec() + "\n\nClassifier Model\n" + this.m_Classifier.toString() + "\n\nCost Matrix\n" + this.m_CostMatrix.toString();
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] argv) {
        MetaCost.runClassifier(new MetaCost(), argv);
    }
}

