/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.meta.generators.Generator;
import weka.core.Option;
import weka.core.Utils;

public abstract class RandomizableGenerator
extends Generator {
    private static final long serialVersionUID = -4182619078970023472L;
    protected Random m_Random = new Random(1L);
    protected long m_Seed = 1L;

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            result.addElement(enu.nextElement());
        }
        result.addElement(new Option("\tSets the seed of the random number generator of the generator\t(default: 1)", "S", 1, "-S <seed>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption("S", options);
        if (tmpStr.length() != 0) {
            this.setSeed(Long.parseLong(tmpStr));
        } else {
            this.setSeed(1L);
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-S");
        result.add("" + this.m_Seed);
        return result.toArray(new String[result.size()]);
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.m_Random = new Random(this.m_Seed);
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }
}

