/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Optimization;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class MDD
extends AbstractClassifier
implements OptionHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -7273119490545290581L;
    protected int m_ClassIndex;
    protected double[] m_Par;
    protected int m_NumClasses;
    protected int[] m_Classes;
    protected double[][][] m_Data;
    protected Instances m_Attributes;
    protected Filter m_Filter = null;
    protected int m_filterType = 1;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected ReplaceMissingValues m_Missing = new ReplaceMissingValues();

    public String globalInfo() {
        return "Modified Diverse Density algorithm, with collective assumption.\n\nMore information about DD:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.PHDTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Oded Maron");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Learning from ambiguity");
        result.setValue(TechnicalInformation.Field.SCHOOL, "Massachusetts Institute of Technology");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "O. Maron and T. Lozano-Perez");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        additional.setValue(TechnicalInformation.Field.TITLE, "A Framework for Multiple Instance Learning");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Neural Information Processing Systems");
        additional.setValue(TechnicalInformation.Field.VOLUME, "10");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default 1=standardize)", "N", 1, "-N <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        String nString = Utils.getOption('N', options);
        if (nString.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(nString), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(1, TAGS_FILTER));
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getDebug()) {
            result.add("-D");
        }
        result.add("-N");
        result.add("" + this.m_filterType);
        return result.toArray(new String[result.size()]);
    }

    public String filterTypeTipText() {
        return "The filter type for transforming the training data.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    @Override
    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        this.getCapabilities().testWithFail(train);
        train = new Instances(train);
        train.deleteWithMissingClass();
        this.m_ClassIndex = train.classIndex();
        this.m_NumClasses = train.numClasses();
        int nR = train.attribute(1).relation().numAttributes();
        int nC = train.numInstances();
        int[] bagSize = new int[nC];
        Instances datasets = new Instances(train.attribute(1).relation(), 0);
        this.m_Data = new double[nC][nR][];
        this.m_Classes = new int[nC];
        this.m_Attributes = datasets.stringFreeStructure();
        double sY1 = 0.0;
        double sY0 = 0.0;
        if (this.m_Debug) {
            System.out.println("Extracting data...");
        }
        FastVector<Integer> maxSzIdx = new FastVector<Integer>();
        int maxSz = 0;
        for (int h = 0; h < nC; ++h) {
            int nI;
            Instance current = train.instance(h);
            this.m_Classes[h] = (int)current.classValue();
            Instances currInsts = current.relationalValue(1);
            bagSize[h] = nI = currInsts.numInstances();
            for (int i = 0; i < nI; ++i) {
                Instance inst = currInsts.instance(i);
                datasets.add(inst);
            }
            if (this.m_Classes[h] != 1) continue;
            if (nI > maxSz) {
                maxSz = nI;
                maxSzIdx = new FastVector(1);
                maxSzIdx.addElement(new Integer(h));
                continue;
            }
            if (nI != maxSz) continue;
            maxSzIdx.addElement(new Integer(h));
        }
        this.m_Filter = this.m_filterType == 1 ? new Standardize() : (this.m_filterType == 0 ? new Normalize() : null);
        if (this.m_Filter != null) {
            this.m_Filter.setInputFormat(datasets);
            datasets = Filter.useFilter(datasets, this.m_Filter);
        }
        this.m_Missing.setInputFormat(datasets);
        datasets = Filter.useFilter(datasets, this.m_Missing);
        int instIndex = 0;
        int start = 0;
        for (int h = 0; h < nC; ++h) {
            for (int i = 0; i < datasets.numAttributes(); ++i) {
                this.m_Data[h][i] = new double[bagSize[h]];
                instIndex = start;
                for (int k = 0; k < bagSize[h]; ++k) {
                    this.m_Data[h][i][k] = datasets.instance(instIndex).value(i);
                    ++instIndex;
                }
            }
            start = instIndex;
            if (this.m_Classes[h] == 1) {
                sY1 += 1.0;
                continue;
            }
            sY0 += 1.0;
        }
        if (this.m_Debug) {
            System.out.println("\nIteration History...");
        }
        double[] x = new double[nR * 2];
        double[] tmp = new double[x.length];
        double[][] b = new double[2][x.length];
        double bestnll = Double.MAX_VALUE;
        for (int t = 0; t < x.length; ++t) {
            b[0][t] = Double.NaN;
            b[1][t] = Double.NaN;
        }
        for (int s = 0; s < maxSzIdx.size(); ++s) {
            int exIdx = (Integer)maxSzIdx.elementAt(s);
            for (int p = 0; p < this.m_Data[exIdx][0].length; ++p) {
                for (int q = 0; q < nR; ++q) {
                    x[2 * q] = this.m_Data[exIdx][q][p];
                    x[2 * q + 1] = 1.0;
                }
                OptEng opt = new OptEng();
                tmp = opt.findArgmin(x, b);
                while (tmp == null) {
                    tmp = opt.getVarbValues();
                    if (this.m_Debug) {
                        System.out.println("200 iterations finished, not enough!");
                    }
                    tmp = opt.findArgmin(tmp, b);
                }
                double nll = opt.getMinFunction();
                if (nll < bestnll) {
                    bestnll = nll;
                    this.m_Par = tmp;
                    if (this.m_Debug) {
                        System.out.println("!!!!!!!!!!!!!!!!Smaller NLL found: " + nll);
                    }
                }
                if (!this.m_Debug) continue;
                System.out.println(exIdx + ":  -------------<Converged>--------------");
            }
        }
    }

    @Override
    public double[] distributionForInstance(Instance exmp) throws Exception {
        Instances ins = exmp.relationalValue(1);
        if (this.m_Filter != null) {
            ins = Filter.useFilter(ins, this.m_Filter);
        }
        ins = Filter.useFilter(ins, this.m_Missing);
        int nI = ins.numInstances();
        int nA = ins.numAttributes();
        double[][] dat = new double[nI][nA];
        for (int j = 0; j < nI; ++j) {
            for (int k = 0; k < nA; ++k) {
                dat[j][k] = ins.instance(j).value(k);
            }
        }
        double[] distribution = new double[2];
        distribution[1] = 0.0;
        for (int i = 0; i < nI; ++i) {
            double exp = 0.0;
            for (int r = 0; r < nA; ++r) {
                exp += (this.m_Par[r * 2] - dat[i][r]) * (this.m_Par[r * 2] - dat[i][r]) / (this.m_Par[r * 2 + 1] * this.m_Par[r * 2 + 1]);
            }
            exp = Math.exp(-exp);
            distribution[1] = distribution[1] + exp / (double)nI;
            distribution[0] = distribution[0] + (1.0 - exp) / (double)nI;
        }
        return distribution;
    }

    public String toString() {
        String result = "Modified Logistic Regression";
        if (this.m_Par == null) {
            return result + ": No model built yet.";
        }
        result = result + "\nCoefficients...\nVariable      Coeff.\n";
        int j = 0;
        int idx = 0;
        while (j < this.m_Par.length / 2) {
            result = result + this.m_Attributes.attribute(idx).name();
            result = result + " " + Utils.doubleToString(this.m_Par[j * 2], 12, 4);
            result = result + " " + Utils.doubleToString(this.m_Par[j * 2 + 1], 12, 4) + "\n";
            ++j;
            ++idx;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] argv) {
        MDD.runClassifier(new MDD(), argv);
    }

    private class OptEng
    extends Optimization {
        private OptEng() {
        }

        @Override
        protected double objectiveFunction(double[] x) {
            double nll = 0.0;
            for (int i = 0; i < MDD.this.m_Classes.length; ++i) {
                int nI = MDD.this.m_Data[i][0].length;
                double bag = 0.0;
                for (int j = 0; j < nI; ++j) {
                    double ins = 0.0;
                    for (int k = 0; k < MDD.this.m_Data[i].length; ++k) {
                        ins += (MDD.this.m_Data[i][k][j] - x[k * 2]) * (MDD.this.m_Data[i][k][j] - x[k * 2]) / (x[k * 2 + 1] * x[k * 2 + 1]);
                    }
                    ins = Math.exp(-ins);
                    if (MDD.this.m_Classes[i] == 1) {
                        bag += ins / (double)nI;
                        continue;
                    }
                    bag += (1.0 - ins) / (double)nI;
                }
                if (bag <= m_Zero) {
                    bag = m_Zero;
                }
                nll -= Math.log(bag);
            }
            return nll;
        }

        @Override
        protected double[] evaluateGradient(double[] x) {
            double[] grad = new double[x.length];
            for (int i = 0; i < MDD.this.m_Classes.length; ++i) {
                int nI = MDD.this.m_Data[i][0].length;
                double denom = 0.0;
                double[] numrt = new double[x.length];
                for (int j = 0; j < nI; ++j) {
                    double exp = 0.0;
                    for (int k = 0; k < MDD.this.m_Data[i].length; ++k) {
                        exp += (MDD.this.m_Data[i][k][j] - x[k * 2]) * (MDD.this.m_Data[i][k][j] - x[k * 2]) / (x[k * 2 + 1] * x[k * 2 + 1]);
                    }
                    exp = Math.exp(-exp);
                    denom = MDD.this.m_Classes[i] == 1 ? (denom += exp) : (denom += 1.0 - exp);
                    for (int p = 0; p < MDD.this.m_Data[i].length; ++p) {
                        int n = 2 * p;
                        numrt[n] = numrt[n] + exp * 2.0 * (x[2 * p] - MDD.this.m_Data[i][p][j]) / (x[2 * p + 1] * x[2 * p + 1]);
                        int n2 = 2 * p + 1;
                        numrt[n2] = numrt[n2] + exp * (x[2 * p] - MDD.this.m_Data[i][p][j]) * (x[2 * p] - MDD.this.m_Data[i][p][j]) / (x[2 * p + 1] * x[2 * p + 1] * x[2 * p + 1]);
                    }
                }
                if (denom <= m_Zero) {
                    denom = m_Zero;
                }
                for (int q = 0; q < MDD.this.m_Data[i].length; ++q) {
                    if (MDD.this.m_Classes[i] == 1) {
                        int n = 2 * q;
                        grad[n] = grad[n] + numrt[2 * q] / denom;
                        int n3 = 2 * q + 1;
                        grad[n3] = grad[n3] - numrt[2 * q + 1] / denom;
                        continue;
                    }
                    int n = 2 * q;
                    grad[n] = grad[n] - numrt[2 * q] / denom;
                    int n4 = 2 * q + 1;
                    grad[n4] = grad[n4] + numrt[2 * q + 1] / denom;
                }
            }
            return grad;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5928 $");
        }
    }
}

