/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class MINND
extends AbstractClassifier
implements OptionHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -4512599203273864994L;
    protected int m_Neighbour = 1;
    protected double[][] m_Mean = null;
    protected double[][] m_Variance = null;
    protected int m_Dimension = 0;
    protected Instances m_Attributes;
    protected double[] m_Class = null;
    protected int m_NumClasses = 0;
    protected double[] m_Weights = null;
    private static double m_ZERO = 1.0E-45;
    protected double m_Rate = -1.0;
    private double[] m_MinArray = null;
    private double[] m_MaxArray = null;
    private double m_STOP = 1.0E-45;
    private double[][] m_Change = null;
    private double[][] m_NoiseM = null;
    private double[][] m_NoiseV = null;
    private double[][] m_ValidM = null;
    private double[][] m_ValidV = null;
    private int m_Select = 1;
    private int m_Choose = 1;
    private double m_Decay = 0.5;

    public String globalInfo() {
        return "Multiple-Instance Nearest Neighbour with Distribution learner.\n\nIt uses gradient descent to find the weight for each dimension of each exeamplar from the starting point of 1.0. In order to avoid overfitting, it uses mean-square function (i.e. the Euclidean distance) to search for the weights.\n It then uses the weights to cleanse the training data. After that it searches for the weights again from the starting points of the weights searched before.\n Finally it uses the most updated weights to cleanse the test exemplar and then finds the nearest neighbour of the test exemplar using partly-weighted Kullback distance. But the variances in the Kullback distance are the ones before cleansing.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Xin Xu");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.TITLE, "A nearest distribution approach to multiple-instance learning");
        result.setValue(TechnicalInformation.Field.SCHOOL, "University of Waikato");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, NZ");
        result.setValue(TechnicalInformation.Field.NOTE, "0657.591B");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    @Override
    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances exs) throws Exception {
        int z;
        int i;
        Instance example;
        int x;
        this.getCapabilities().testWithFail(exs);
        Instances newData = new Instances(exs);
        newData.deleteWithMissingClass();
        int numegs = newData.numInstances();
        this.m_Dimension = newData.attribute(1).relation().numAttributes();
        this.m_Attributes = newData.stringFreeStructure();
        this.m_Change = new double[numegs][this.m_Dimension];
        this.m_NumClasses = exs.numClasses();
        this.m_Mean = new double[numegs][this.m_Dimension];
        this.m_Variance = new double[numegs][this.m_Dimension];
        this.m_Class = new double[numegs];
        this.m_Weights = new double[numegs];
        this.m_NoiseM = new double[numegs][this.m_Dimension];
        this.m_NoiseV = new double[numegs][this.m_Dimension];
        this.m_ValidM = new double[numegs][this.m_Dimension];
        this.m_ValidV = new double[numegs][this.m_Dimension];
        this.m_MinArray = new double[this.m_Dimension];
        this.m_MaxArray = new double[this.m_Dimension];
        for (int v = 0; v < this.m_Dimension; ++v) {
            this.m_MaxArray[v] = Double.NaN;
            this.m_MinArray[v] = Double.NaN;
        }
        for (int w = 0; w < numegs; ++w) {
            this.updateMinMax(newData.instance(w));
        }
        Instances data = this.m_Attributes;
        for (x = 0; x < numegs; ++x) {
            example = newData.instance(x);
            example = this.scale(example);
            for (i = 0; i < this.m_Dimension; ++i) {
                this.m_Mean[x][i] = example.relationalValue(1).meanOrMode(i);
                this.m_Variance[x][i] = example.relationalValue(1).variance(i);
                if (Utils.eq(this.m_Variance[x][i], 0.0)) {
                    this.m_Variance[x][i] = m_ZERO;
                }
                this.m_Change[x][i] = 1.0;
            }
            data.add(example);
            this.m_Class[x] = example.classValue();
            this.m_Weights[x] = example.weight();
        }
        for (z = 0; z < numegs; ++z) {
            this.findWeights(z, this.m_Mean);
        }
        for (x = 0; x < numegs; ++x) {
            example = this.preprocess(data, x);
            if (this.getDebug()) {
                System.out.println("???Exemplar " + x + " has been pre-processed:" + data.instance(x).relationalValue(1).sumOfWeights() + "|" + example.relationalValue(1).sumOfWeights() + "; class:" + this.m_Class[x]);
            }
            if (Utils.gr(example.relationalValue(1).sumOfWeights(), 0.0)) {
                for (i = 0; i < this.m_Dimension; ++i) {
                    this.m_ValidM[x][i] = example.relationalValue(1).meanOrMode(i);
                    this.m_ValidV[x][i] = example.relationalValue(1).variance(i);
                    if (!Utils.eq(this.m_ValidV[x][i], 0.0)) continue;
                    this.m_ValidV[x][i] = m_ZERO;
                }
                continue;
            }
            this.m_ValidM[x] = null;
            this.m_ValidV[x] = null;
        }
        for (z = 0; z < numegs; ++z) {
            if (this.m_ValidM[z] == null) continue;
            this.findWeights(z, this.m_ValidM);
        }
    }

    public Instance preprocess(Instances data, int pos) throws Exception {
        Instance before = data.instance(pos);
        if ((int)before.classValue() == 0) {
            this.m_NoiseM[pos] = null;
            this.m_NoiseV[pos] = null;
            return before;
        }
        Instances after_relationInsts = before.attribute(1).relation().stringFreeStructure();
        Instances noises_relationInsts = before.attribute(1).relation().stringFreeStructure();
        Instances newData = this.m_Attributes;
        DenseInstance after = new DenseInstance(before.numAttributes());
        DenseInstance noises = new DenseInstance(before.numAttributes());
        after.setDataset(newData);
        noises.setDataset(newData);
        for (int g = 0; g < before.relationalValue(1).numInstances(); ++g) {
            Instance datum = before.relationalValue(1).instance(g);
            double[] dists = new double[data.numInstances()];
            for (int i = 0; i < data.numInstances(); ++i) {
                dists[i] = i != pos ? this.distance(datum, this.m_Mean[i], this.m_Variance[i], i) : Double.POSITIVE_INFINITY;
            }
            int[] pred = new int[this.m_NumClasses];
            for (int n = 0; n < pred.length; ++n) {
                pred[n] = 0;
            }
            for (int o = 0; o < this.m_Select; ++o) {
                int index = Utils.minIndex(dists);
                int n = (int)this.m_Class[index];
                pred[n] = pred[n] + 1;
                dists[index] = Double.POSITIVE_INFINITY;
            }
            int clas = Utils.maxIndex(pred);
            if ((int)before.classValue() != clas) {
                noises_relationInsts.add(datum);
                continue;
            }
            after_relationInsts.add(datum);
        }
        int relationValue = noises.attribute(1).addRelation(noises_relationInsts);
        noises.setValue(0, before.value(0));
        noises.setValue(1, (double)relationValue);
        noises.setValue(2, before.classValue());
        relationValue = after.attribute(1).addRelation(after_relationInsts);
        after.setValue(0, before.value(0));
        after.setValue(1, (double)relationValue);
        after.setValue(2, before.classValue());
        if (Utils.gr(noises.relationalValue(1).sumOfWeights(), 0.0)) {
            for (int i = 0; i < this.m_Dimension; ++i) {
                this.m_NoiseM[pos][i] = noises.relationalValue(1).meanOrMode(i);
                this.m_NoiseV[pos][i] = noises.relationalValue(1).variance(i);
                if (!Utils.eq(this.m_NoiseV[pos][i], 0.0)) continue;
                this.m_NoiseV[pos][i] = m_ZERO;
            }
        } else {
            this.m_NoiseM[pos] = null;
            this.m_NoiseV[pos] = null;
        }
        return after;
    }

    private double distance(Instance first, double[] mean, double[] var, int pos) {
        double distance = 0.0;
        for (int i = 0; i < this.m_Dimension; ++i) {
            if (!first.attribute(i).isNumeric()) continue;
            if (!first.isMissing(i)) {
                double diff = first.value(i) - mean[i];
                if (Utils.gr(var[i], m_ZERO)) {
                    distance += this.m_Change[pos][i] * var[i] * diff * diff;
                    continue;
                }
                distance += this.m_Change[pos][i] * diff * diff;
                continue;
            }
            if (Utils.gr(var[i], m_ZERO)) {
                distance += this.m_Change[pos][i] * var[i];
                continue;
            }
            distance += this.m_Change[pos][i] * 1.0;
        }
        return distance;
    }

    private void updateMinMax(Instance ex) {
        Instances insts = ex.relationalValue(1);
        for (int j = 0; j < this.m_Dimension; ++j) {
            if (!insts.attribute(j).isNumeric()) continue;
            for (int k = 0; k < insts.numInstances(); ++k) {
                Instance ins = insts.instance(k);
                if (ins.isMissing(j)) continue;
                if (Double.isNaN(this.m_MinArray[j])) {
                    this.m_MinArray[j] = ins.value(j);
                    this.m_MaxArray[j] = ins.value(j);
                    continue;
                }
                if (ins.value(j) < this.m_MinArray[j]) {
                    this.m_MinArray[j] = ins.value(j);
                    continue;
                }
                if (!(ins.value(j) > this.m_MaxArray[j])) continue;
                this.m_MaxArray[j] = ins.value(j);
            }
        }
    }

    private Instance scale(Instance before) throws Exception {
        Instances afterInsts = before.relationalValue(1).stringFreeStructure();
        DenseInstance after = new DenseInstance(before.numAttributes());
        after.setDataset(this.m_Attributes);
        for (int i = 0; i < before.relationalValue(1).numInstances(); ++i) {
            Instance datum = before.relationalValue(1).instance(i);
            Instance inst = (Instance)datum.copy();
            for (int j = 0; j < this.m_Dimension; ++j) {
                if (!before.relationalValue(1).attribute(j).isNumeric()) continue;
                inst.setValue(j, (datum.value(j) - this.m_MinArray[j]) / (this.m_MaxArray[j] - this.m_MinArray[j]));
            }
            afterInsts.add(inst);
        }
        int attValue = after.attribute(1).addRelation(afterInsts);
        after.setValue(0, before.value(0));
        after.setValue(1, (double)attValue);
        after.setValue(2, before.value(2));
        return after;
    }

    public void findWeights(int row, double[][] mean) {
        double[] neww = new double[this.m_Dimension];
        double[] oldw = new double[this.m_Dimension];
        System.arraycopy(this.m_Change[row], 0, neww, 0, this.m_Dimension);
        double newresult = this.target(neww, mean, row, this.m_Class);
        double result = Double.POSITIVE_INFINITY;
        double rate = 0.05;
        if (this.m_Rate != -1.0) {
            rate = this.m_Rate;
        }
        block0: while (Utils.gr(result - newresult, this.m_STOP)) {
            int i;
            oldw = neww;
            neww = new double[this.m_Dimension];
            double[] delta = this.delta(oldw, mean, row, this.m_Class);
            for (i = 0; i < this.m_Dimension; ++i) {
                if (!Utils.gr(this.m_Variance[row][i], 0.0)) continue;
                neww[i] = oldw[i] + rate * delta[i];
            }
            result = newresult;
            newresult = this.target(neww, mean, row, this.m_Class);
            while (Utils.gr(newresult, result)) {
                if (this.m_Rate == -1.0) {
                    rate *= this.m_Decay;
                    for (i = 0; i < this.m_Dimension; ++i) {
                        if (!Utils.gr(this.m_Variance[row][i], 0.0)) continue;
                        neww[i] = oldw[i] + rate * delta[i];
                    }
                    newresult = this.target(neww, mean, row, this.m_Class);
                    continue;
                }
                for (i = 0; i < this.m_Dimension; ++i) {
                    neww[i] = oldw[i];
                }
                break block0;
            }
        }
        this.m_Change[row] = neww;
    }

    private double[] delta(double[] x, double[][] X, int rowpos, double[] Y) {
        double y = Y[rowpos];
        double[] delta = new double[this.m_Dimension];
        for (int h = 0; h < this.m_Dimension; ++h) {
            delta[h] = 0.0;
        }
        for (int i = 0; i < X.length; ++i) {
            if (i == rowpos || X[i] == null) continue;
            double var = y == Y[i] ? 0.0 : Math.sqrt((double)this.m_Dimension - 1.0);
            double distance = 0.0;
            for (int j = 0; j < this.m_Dimension; ++j) {
                if (!Utils.gr(this.m_Variance[rowpos][j], 0.0)) continue;
                distance += x[j] * (X[rowpos][j] - X[i][j]) * (X[rowpos][j] - X[i][j]);
            }
            if ((distance = Math.sqrt(distance)) == 0.0) continue;
            for (int k = 0; k < this.m_Dimension; ++k) {
                if (!(this.m_Variance[rowpos][k] > 0.0)) continue;
                int n = k;
                delta[n] = delta[n] + (var / distance - 1.0) * 0.5 * (X[rowpos][k] - X[i][k]) * (X[rowpos][k] - X[i][k]);
            }
        }
        return delta;
    }

    public double target(double[] x, double[][] X, int rowpos, double[] Y) {
        double y = Y[rowpos];
        double result = 0.0;
        for (int i = 0; i < X.length; ++i) {
            if (i == rowpos || X[i] == null) continue;
            double var = y == Y[i] ? 0.0 : Math.sqrt((double)this.m_Dimension - 1.0);
            double f = 0.0;
            for (int j = 0; j < this.m_Dimension; ++j) {
                if (!Utils.gr(this.m_Variance[rowpos][j], 0.0)) continue;
                f += x[j] * (X[rowpos][j] - X[i][j]) * (X[rowpos][j] - X[i][j]);
            }
            if (Double.isInfinite(f = Math.sqrt(f))) {
                System.exit(1);
            }
            result += 0.5 * (f - var) * (f - var);
        }
        return result;
    }

    @Override
    public double classifyInstance(Instance ex) throws Exception {
        int i;
        ex = this.scale(ex);
        double[] var = new double[this.m_Dimension];
        for (int i2 = 0; i2 < this.m_Dimension; ++i2) {
            var[i2] = ex.relationalValue(1).variance(i2);
        }
        double[] kullback = new double[this.m_Class.length];
        double[] predict = new double[this.m_NumClasses];
        for (int h = 0; h < predict.length; ++h) {
            predict[h] = 0.0;
        }
        if ((ex = this.cleanse(ex)).relationalValue(1).numInstances() == 0) {
            if (this.getDebug()) {
                System.out.println("???Whole exemplar falls into ambiguous area!");
            }
            return 1.0;
        }
        double[] mean = new double[this.m_Dimension];
        for (i = 0; i < this.m_Dimension; ++i) {
            mean[i] = ex.relationalValue(1).meanOrMode(i);
        }
        for (int h = 0; h < var.length; ++h) {
            if (!Utils.eq(var[h], 0.0)) continue;
            var[h] = m_ZERO;
        }
        for (i = 0; i < this.m_Class.length; ++i) {
            kullback[i] = this.m_ValidM[i] != null ? this.kullback(mean, this.m_ValidM[i], var, this.m_Variance[i], i) : Double.POSITIVE_INFINITY;
        }
        for (int j = 0; j < this.m_Neighbour; ++j) {
            int pos = Utils.minIndex(kullback);
            int n = (int)this.m_Class[pos];
            predict[n] = predict[n] + this.m_Weights[pos];
            kullback[pos] = Double.POSITIVE_INFINITY;
        }
        if (this.getDebug()) {
            System.out.println("???There are still some unambiguous instances in this exemplar! Predicted as: " + Utils.maxIndex(predict));
        }
        return Utils.maxIndex(predict);
    }

    public Instance cleanse(Instance before) throws Exception {
        Instances insts = before.relationalValue(1).stringFreeStructure();
        DenseInstance after = new DenseInstance(before.numAttributes());
        after.setDataset(this.m_Attributes);
        for (int g = 0; g < before.relationalValue(1).numInstances(); ++g) {
            Instance datum = before.relationalValue(1).instance(g);
            double[] minNoiDists = new double[this.m_Choose];
            double[] minValDists = new double[this.m_Choose];
            int noiseCount = 0;
            int validCount = 0;
            double[] nDist = new double[this.m_Mean.length];
            double[] vDist = new double[this.m_Mean.length];
            for (int h = 0; h < this.m_Mean.length; ++h) {
                vDist[h] = this.m_ValidM[h] == null ? Double.POSITIVE_INFINITY : this.distance(datum, this.m_ValidM[h], this.m_ValidV[h], h);
                nDist[h] = this.m_NoiseM[h] == null ? Double.POSITIVE_INFINITY : this.distance(datum, this.m_NoiseM[h], this.m_NoiseV[h], h);
            }
            for (int k = 0; k < this.m_Choose; ++k) {
                int pos = Utils.minIndex(vDist);
                minValDists[k] = vDist[pos];
                vDist[pos] = Double.POSITIVE_INFINITY;
                pos = Utils.minIndex(nDist);
                minNoiDists[k] = nDist[pos];
                nDist[pos] = Double.POSITIVE_INFINITY;
            }
            int x = 0;
            int y = 0;
            while (x + y < this.m_Choose) {
                if (minValDists[x] <= minNoiDists[y]) {
                    ++validCount;
                    ++x;
                    continue;
                }
                ++noiseCount;
                ++y;
            }
            if (x < y) continue;
            insts.add(datum);
        }
        after.setValue(0, before.value(0));
        after.setValue(1, (double)after.attribute(1).addRelation(insts));
        after.setValue(2, before.value(2));
        return after;
    }

    public double kullback(double[] mu1, double[] mu2, double[] var1, double[] var2, int pos) {
        int p = mu1.length;
        double result = 0.0;
        for (int y = 0; y < p; ++y) {
            if (!Utils.gr(var1[y], 0.0) || !Utils.gr(var2[y], 0.0)) continue;
            result += Math.log(Math.sqrt(var2[y] / var1[y])) + var1[y] / (2.0 * var2[y]) + this.m_Change[pos][y] * (mu1[y] - mu2[y]) * (mu1[y] - mu2[y]) / (2.0 * var2[y]) - 0.5;
        }
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSet number of nearest neighbour for prediction\n\t(default 1)", "K", 1, "-K <number of neighbours>"));
        result.addElement(new Option("\tSet number of nearest neighbour for cleansing the training data\n\t(default 1)", "S", 1, "-S <number of neighbours>"));
        result.addElement(new Option("\tSet number of nearest neighbour for cleansing the testing data\n\t(default 1)", "E", 1, "-E <number of neighbours>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        String numNeighbourString = Utils.getOption('K', options);
        if (numNeighbourString.length() != 0) {
            this.setNumNeighbours(Integer.parseInt(numNeighbourString));
        } else {
            this.setNumNeighbours(1);
        }
        numNeighbourString = Utils.getOption('S', options);
        if (numNeighbourString.length() != 0) {
            this.setNumTrainingNoises(Integer.parseInt(numNeighbourString));
        } else {
            this.setNumTrainingNoises(1);
        }
        numNeighbourString = Utils.getOption('E', options);
        if (numNeighbourString.length() != 0) {
            this.setNumTestingNoises(Integer.parseInt(numNeighbourString));
        } else {
            this.setNumTestingNoises(1);
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getDebug()) {
            result.add("-D");
        }
        result.add("-K");
        result.add("" + this.getNumNeighbours());
        result.add("-S");
        result.add("" + this.getNumTrainingNoises());
        result.add("-E");
        result.add("" + this.getNumTestingNoises());
        return result.toArray(new String[result.size()]);
    }

    public String numNeighboursTipText() {
        return "The number of nearest neighbours to the estimate the class prediction of test bags.";
    }

    public void setNumNeighbours(int numNeighbour) {
        this.m_Neighbour = numNeighbour;
    }

    public int getNumNeighbours() {
        return this.m_Neighbour;
    }

    public String numTrainingNoisesTipText() {
        return "The number of nearest neighbour instances in the selection of noises in the training data.";
    }

    public void setNumTrainingNoises(int numTraining) {
        this.m_Select = numTraining;
    }

    public int getNumTrainingNoises() {
        return this.m_Select;
    }

    public String numTestingNoisesTipText() {
        return "The number of nearest neighbour instances in the selection of noises in the test data.";
    }

    public int getNumTestingNoises() {
        return this.m_Choose;
    }

    public void setNumTestingNoises(int numTesting) {
        this.m_Choose = numTesting;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] args) {
        MINND.runClassifier(new MINND(), args);
    }
}

