/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.util.Arrays;
import weka.classifiers.misc.monotone.CumulativeDiscreteDistribution;
import weka.classifiers.misc.monotone.DiscreteDistribution;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.estimators.DiscreteEstimator;

public class DistributionUtils
implements RevisionHandler {
    private static final int MAX_CLASSES = 20;
    private static final CumulativeDiscreteDistribution[] m_minimalDistributions = new CumulativeDiscreteDistribution[21];
    private static final CumulativeDiscreteDistribution[] m_maximalDistributions = new CumulativeDiscreteDistribution[21];

    public static CumulativeDiscreteDistribution interpolate(CumulativeDiscreteDistribution cdf1, CumulativeDiscreteDistribution cdf2, double s) throws IllegalArgumentException {
        if (cdf1.getNumSymbols() != cdf2.getNumSymbols()) {
            throw new IllegalArgumentException("CumulativeDiscreteDistributions don't have the same size");
        }
        if (s < 0.0 || s > 1.0) {
            throw new IllegalArgumentException("Parameter s exceeds bounds");
        }
        double[] res = new double[cdf1.getNumSymbols()];
        int n = cdf1.getNumSymbols();
        for (int i = 0; i < n; ++i) {
            res[i] = (1.0 - s) * cdf1.getCumulativeProbability(i) + s * cdf2.getCumulativeProbability(i);
        }
        return new CumulativeDiscreteDistribution(res);
    }

    public static CumulativeDiscreteDistribution interpolate(CumulativeDiscreteDistribution cdf1, CumulativeDiscreteDistribution cdf2, double[] s) throws IllegalArgumentException {
        if (cdf1.getNumSymbols() != cdf2.getNumSymbols()) {
            throw new IllegalArgumentException("CumulativeDiscreteDistributions don't have the same size");
        }
        if (cdf1.getNumSymbols() > s.length) {
            throw new IllegalArgumentException("Array with interpolation parameters is not  long enough");
        }
        double[] res = new double[cdf1.getNumSymbols()];
        int n = cdf1.getNumSymbols();
        for (int i = 0; i < n; ++i) {
            if (s[i] < 0.0 || s[i] > 1.0) {
                throw new IllegalArgumentException("Interpolation parameter exceeds bounds");
            }
            res[i] = (1.0 - s[i]) * cdf1.getCumulativeProbability(i) + s[i] * cdf2.getCumulativeProbability(i);
        }
        return new CumulativeDiscreteDistribution(res);
    }

    public static DiscreteDistribution interpolate(DiscreteDistribution ddf1, DiscreteDistribution ddf2, double s) throws IllegalArgumentException {
        if (ddf1.getNumSymbols() != ddf2.getNumSymbols()) {
            throw new IllegalArgumentException("DiscreteDistributions don't have the same size");
        }
        if (s < 0.0 || s > 1.0) {
            throw new IllegalArgumentException("Parameter s exceeds bounds");
        }
        double[] res = new double[ddf1.getNumSymbols()];
        int n = ddf1.getNumSymbols();
        for (int i = 0; i < n; ++i) {
            res[i] = (1.0 - s) * ddf1.getProbability(i) + s * ddf2.getProbability(i);
        }
        return new DiscreteDistribution(res);
    }

    public static CumulativeDiscreteDistribution takeMin(CumulativeDiscreteDistribution cdf1, CumulativeDiscreteDistribution cdf2) throws IllegalArgumentException {
        if (cdf1.getNumSymbols() != cdf2.getNumSymbols()) {
            throw new IllegalArgumentException("Cumulative distributions don't have the same length");
        }
        double[] cdf = new double[cdf1.getNumSymbols()];
        int n = cdf.length;
        for (int i = 0; i < n; ++i) {
            cdf[i] = Math.min(cdf1.getCumulativeProbability(i), cdf2.getCumulativeProbability(i));
        }
        return new CumulativeDiscreteDistribution(cdf);
    }

    public static CumulativeDiscreteDistribution takeMax(CumulativeDiscreteDistribution cdf1, CumulativeDiscreteDistribution cdf2) throws IllegalArgumentException {
        if (cdf1.getNumSymbols() != cdf2.getNumSymbols()) {
            throw new IllegalArgumentException("Cumulative distributions don't have the same length");
        }
        double[] cdf = new double[cdf1.getNumSymbols()];
        int n = cdf.length;
        for (int i = 0; i < n; ++i) {
            cdf[i] = Math.max(cdf1.getCumulativeProbability(i), cdf2.getCumulativeProbability(i));
        }
        return new CumulativeDiscreteDistribution(cdf);
    }

    public static double[] getDistributionArray(DiscreteEstimator df) {
        double[] dfa = new double[df.getNumSymbols()];
        for (int i = 0; i < dfa.length; ++i) {
            dfa[i] = df.getProbability(i);
        }
        return dfa;
    }

    public static CumulativeDiscreteDistribution getMinimalCumulativeDiscreteDistribution(int numClasses) throws IllegalArgumentException {
        if (numClasses <= 0) {
            throw new IllegalArgumentException("Number of elements must be positive");
        }
        if (numClasses <= 20) {
            return m_minimalDistributions[numClasses];
        }
        double[] dd = new double[numClasses];
        Arrays.fill(dd, 1.0);
        return new CumulativeDiscreteDistribution(dd);
    }

    public static CumulativeDiscreteDistribution getMaximalCumulativeDiscreteDistribution(int numClasses) throws IllegalArgumentException {
        if (numClasses <= 0) {
            throw new IllegalArgumentException("Number of elements must be positive");
        }
        if (numClasses <= 20) {
            return m_maximalDistributions[numClasses];
        }
        double[] dd = new double[numClasses];
        dd[dd.length - 1] = 1.0;
        return new CumulativeDiscreteDistribution(dd);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5922 $");
    }

    static {
        for (int i = 1; i <= 20; ++i) {
            double[] dd = new double[i];
            dd[dd.length - 1] = 1.0;
            DistributionUtils.m_maximalDistributions[i] = new CumulativeDiscreteDistribution(dd);
            Arrays.fill(dd, 1.0);
            DistributionUtils.m_minimalDistributions[i] = new CumulativeDiscreteDistribution(dd);
        }
    }
}

