/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.misc.monotone.BooleanBitMatrix;
import weka.classifiers.misc.monotone.Coordinates;
import weka.classifiers.misc.monotone.CumulativeDiscreteDistribution;
import weka.classifiers.misc.monotone.EnumerationIterator;
import weka.classifiers.misc.monotone.NominalLossFunction;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;

public class InstancesUtil
implements RevisionHandler {
    public static boolean equalIgnoreClass(Instance i1, Instance i2) {
        int i;
        int n = i1.numAttributes();
        int classIndex = i1.classIndex();
        if (i2.numAttributes() != n || classIndex != i2.classIndex()) {
            return false;
        }
        for (i = 0; i < n && (i == classIndex || Utils.eq(i1.value(i), i2.value(i))); ++i) {
        }
        return i == n;
    }

    public static int containsIgnoreClass(Instances instances, Instance instance) {
        double[] dd = instance.toDoubleArray();
        int classIndex = instances.classIndex();
        int n = instances.numAttributes();
        EnumerationIterator it = new EnumerationIterator(instances.enumerateInstances());
        int index = 0;
        while (it.hasNext()) {
            int i;
            Instance tmp = (Instance)it.next();
            for (i = 0; i < n && (i == classIndex || Utils.eq(dd[i], tmp.value(i))); ++i) {
            }
            if (i == n) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static int nextOccurenceIgnoreClass(Instances instances, Instance instance, int index) {
        double[] dd = instance.toDoubleArray();
        int classIndex = instances.classIndex();
        int n = instances.numAttributes();
        int numInstances = instances.numInstances();
        for (int currentIndex = index; currentIndex < numInstances; ++currentIndex) {
            int i;
            Instance tmp = instances.instance(currentIndex);
            for (i = 0; i < n && (i == classIndex || Utils.eq(dd[i], tmp.value(i))); ++i) {
            }
            if (i != n) continue;
            return currentIndex;
        }
        return -1;
    }

    public static boolean isHomogeneous(Instances instances) {
        EnumerationIterator it = new EnumerationIterator(instances.enumerateInstances());
        if (it.hasNext()) {
            double classValue = ((Instance)it.next()).classValue();
            while (it.hasNext()) {
                if (((Instance)it.next()).classValue() == classValue) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean strictlySmaller(Instance i1, Instance i2) {
        Coordinates c1 = new Coordinates(i1);
        Coordinates c2 = new Coordinates(i2);
        return c1.strictlySmaller(c2);
    }

    public static boolean smallerOrEqual(Instance i1, Instance i2) {
        Coordinates c1 = new Coordinates(i1);
        Coordinates c2 = new Coordinates(i2);
        return c1.smallerOrEqual(c2);
    }

    public static boolean comparable(Instance i1, Instance i2) throws IllegalArgumentException {
        Coordinates c1 = new Coordinates(i1);
        Coordinates c2 = new Coordinates(i2);
        return c1.smallerOrEqual(c2) || c2.smallerOrEqual(c1);
    }

    public static boolean doubt(Instance i1, Instance i2) {
        if (i1.classValue() == i2.classValue()) {
            return false;
        }
        Coordinates c1 = new Coordinates(i1);
        Coordinates c2 = new Coordinates(i2);
        return c1.equals(c2);
    }

    public static boolean reversedPreference(Instance i1, Instance i2) throws IllegalArgumentException {
        if (i1.classValue() == i2.classValue()) {
            return false;
        }
        Coordinates c1 = new Coordinates(i1);
        Coordinates c2 = new Coordinates(i2);
        if (i1.classValue() > i2.classValue() && c1.strictlySmaller(c2)) {
            return true;
        }
        return i2.classValue() > i1.classValue() && c2.strictlySmaller(c1);
    }

    public static boolean isMonotone(Instances instances) {
        int n = instances.numInstances();
        for (int i = 0; i < n; ++i) {
            Instance i1 = instances.instance(i);
            for (int j = i + 1; j < n; ++j) {
                if (!InstancesUtil.doubt(i1, instances.instance(j)) && !InstancesUtil.reversedPreference(i1, instances.instance(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isQuasiMonotone(Instances ground, Instances other) {
        if (!InstancesUtil.isMonotone(ground)) {
            return false;
        }
        EnumerationIterator it1 = new EnumerationIterator(ground.enumerateInstances());
        while (it1.hasNext()) {
            Instance inst1 = (Instance)it1.next();
            EnumerationIterator it2 = new EnumerationIterator(other.enumerateInstances());
            while (it2.hasNext()) {
                Instance inst2 = (Instance)it2.next();
                if (!InstancesUtil.doubt(inst1, inst2) && !InstancesUtil.reversedPreference(inst1, inst2)) continue;
                return false;
            }
        }
        return true;
    }

    public static int[] nrOfReversedPreferences(Instances instances) {
        int[] stats = new int[3];
        int n = instances.numInstances();
        stats[0] = 0;
        stats[1] = 0;
        stats[2] = n * (n - 1) / 2;
        for (int i = 0; i < n; ++i) {
            Instance i1 = instances.instance(i);
            for (int j = i + 1; j < n; ++j) {
                Instance j1 = instances.instance(j);
                if (!InstancesUtil.comparable(i1, j1)) continue;
                stats[1] = stats[1] + 1;
                if (!InstancesUtil.reversedPreference(i1, j1)) continue;
                stats[0] = stats[0] + 1;
            }
        }
        return stats;
    }

    public static int[] nrStochasticReversedPreference(Instances instances) throws IllegalArgumentException {
        if (instances.classIndex() < 0) {
            throw new IllegalArgumentException("Class is not set");
        }
        Instances data = new Instances(instances);
        data.deleteWithMissingClass();
        if (data.numInstances() == 0) {
            throw new IllegalArgumentException("No instances with a class value!");
        }
        HashMap<Coordinates, DiscreteEstimator> distributions = new HashMap<Coordinates, DiscreteEstimator>(data.numInstances() / 2);
        EnumerationIterator i = new EnumerationIterator(instances.enumerateInstances());
        while (i.hasNext()) {
            Instance instance = (Instance)i.next();
            Coordinates c = new Coordinates(instance);
            DiscreteEstimator df = (DiscreteEstimator)distributions.get(c);
            if (df == null) {
                df = new DiscreteEstimator(instances.numClasses(), 0.0);
            }
            df.addValue(instance.classValue(), instance.weight());
            distributions.put(c, df);
        }
        HashMap<Coordinates, CumulativeDiscreteDistribution> cumulativeDistributions = new HashMap<Coordinates, CumulativeDiscreteDistribution>(distributions.size());
        for (Coordinates c : distributions.keySet()) {
            DiscreteEstimator df = (DiscreteEstimator)distributions.get(c);
            cumulativeDistributions.put(c, new CumulativeDiscreteDistribution(df));
        }
        int[] revPref = new int[5];
        revPref[0] = cumulativeDistributions.size();
        for (Coordinates c1 : cumulativeDistributions.keySet()) {
            CumulativeDiscreteDistribution cdf1 = (CumulativeDiscreteDistribution)cumulativeDistributions.get(c1);
            for (Coordinates c2 : cumulativeDistributions.keySet()) {
                CumulativeDiscreteDistribution cdf2 = (CumulativeDiscreteDistribution)cumulativeDistributions.get(c2);
                if (c2.equals(c1)) continue;
                revPref[4] = revPref[4] + 1;
                if (!c1.strictlySmaller(c2)) continue;
                revPref[3] = revPref[3] + 1;
                if (cdf1.stochasticDominatedBy(cdf2)) continue;
                revPref[1] = revPref[1] + 1;
                if (!cdf2.stochasticDominatedBy(cdf1)) continue;
                revPref[2] = revPref[2] + 1;
            }
        }
        revPref[4] = revPref[4] / 2;
        return revPref;
    }

    public static int nrOfRedundant(Instances instances) {
        int n = instances.numInstances();
        int nrRedundant = 0;
        for (int i = 0; i < n; ++i) {
            Instance i1 = instances.instance(i);
            for (int j = i + 1; j < n; ++j) {
                Instance j1 = instances.instance(j);
                if (j1.classValue() != i1.classValue() || !InstancesUtil.comparable(i1, j1)) continue;
                ++nrRedundant;
            }
        }
        return nrRedundant;
    }

    public static double totalLoss(Classifier classifier, Instances instances, NominalLossFunction lossFunction) {
        double loss = 0.0;
        int n = instances.numInstances();
        for (int i = 0; i < n; ++i) {
            try {
                loss += lossFunction.loss(instances.instance(i).classValue(), classifier.classifyInstance(instances.instance(i)));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return loss;
    }

    public static void classifyInstances(Instances instances, Classifier classifier) throws Exception {
        EnumerationIterator it = new EnumerationIterator(instances.enumerateInstances());
        while (it.hasNext()) {
            Instance instance = (Instance)it.next();
            instance.setClassValue(classifier.classifyInstance(instance));
        }
    }

    public static BooleanBitMatrix getBitMatrix(Instances instances) {
        int numInstances = instances.numInstances();
        BooleanBitMatrix bm = new BooleanBitMatrix(numInstances, numInstances);
        for (int i = 0; i < numInstances; ++i) {
            Instance instance1 = instances.instance(i);
            for (int j = 0; j < numInstances; ++j) {
                Instance instance2 = instances.instance(j);
                if (!InstancesUtil.strictlySmaller(instance1, instance2)) continue;
                bm.set(i, j);
            }
        }
        return bm;
    }

    public static double numberInInterval(Instance low, Instance up) throws IllegalArgumentException {
        Coordinates cLow = new Coordinates(low);
        Coordinates cUp = new Coordinates(up);
        if (!cLow.smallerOrEqual(cUp)) {
            throw new IllegalArgumentException("The given instances are not the bounds of an interval");
        }
        double number = 1.0;
        int dim = cLow.dimension();
        for (int i = 0; i < dim; ++i) {
            number *= cUp.getValue(i) - cLow.getValue(i) + 1.0;
        }
        return number;
    }

    public static double numberOfSmallerVectors(Instance instance) throws IllegalArgumentException {
        double[] values = InstancesUtil.toDataDouble(instance);
        double nr = 1.0;
        for (int i = 0; i < values.length; ++i) {
            if (instance.attribute(i).isNumeric()) {
                throw new IllegalArgumentException("Numeric attributes are not supported");
            }
            nr *= values[i] + 1.0;
        }
        return nr;
    }

    public static double numberOfGreaterVectors(Instance instance) throws IllegalArgumentException {
        double[] values = InstancesUtil.toDataDouble(instance);
        double nr = 1.0;
        for (int i = 0; i < values.length; ++i) {
            if (instance.attribute(i).isNumeric()) {
                throw new IllegalArgumentException("Numeric attributes are not supported");
            }
            nr *= (double)instance.attribute(i).numValues() - values[i];
        }
        return nr;
    }

    public static void write(Instances instances, BufferedWriter file) throws IOException {
        file.write(instances.toString());
    }

    public static DiscreteEstimator countValues(Instances instances, int attributeIndex) throws IllegalArgumentException {
        int numValues = instances.attribute(attributeIndex).numValues();
        if (numValues == 0) {
            throw new IllegalArgumentException("Can't create histogram for numeric attribute");
        }
        DiscreteEstimator de = new DiscreteEstimator(numValues, false);
        EnumerationIterator it = new EnumerationIterator(instances.enumerateInstances());
        while (it.hasNext()) {
            Instance instance = (Instance)it.next();
            if (instance.isMissing(attributeIndex)) continue;
            de.addValue(instance.value(attributeIndex), instance.weight());
        }
        return de;
    }

    public static Instances sampleWithoutReplacement(Instances instances, int size, Random random) {
        if (size > instances.numInstances()) {
            throw new IllegalArgumentException("Size of requested sample exceeds number of instances");
        }
        int numInstances = instances.numInstances();
        int[] indices = new int[instances.numInstances()];
        for (int i = 0; i < numInstances; ++i) {
            indices[i] = i;
        }
        Instances sample = new Instances(instances, size);
        for (int i = 0; i < size; ++i) {
            int index = random.nextInt(numInstances--);
            sample.add(instances.instance(indices[index]));
            InstancesUtil.swap(indices, index, numInstances);
        }
        return sample;
    }

    private static final void swap(int[] aa, int i, int j) {
        int tmp = aa[i];
        aa[i] = aa[j];
        aa[j] = tmp;
    }

    public static Instances generateRandomSample(Instances headerInfo, int numberOfExamples, Random random) throws IllegalArgumentException {
        int n = headerInfo.numAttributes();
        double[] info = new double[n];
        int classIndex = headerInfo.classIndex();
        for (int i = 0; i < n; ++i) {
            info[i] = headerInfo.attribute(i).numValues();
            if (i == classIndex || info[i] != 0.0) continue;
            throw new IllegalArgumentException("Numeric attributes are currently not supported");
        }
        Instances sample = new Instances(headerInfo, numberOfExamples);
        sample.setRelationName(headerInfo.relationName() + ".random.sample.of." + numberOfExamples);
        for (int i = 0; i < numberOfExamples; ++i) {
            sample.add(InstancesUtil.randomSample(info, classIndex, random));
        }
        return sample;
    }

    private static Instance randomSample(double[] info, int classIndex, Random random) {
        double[] attValues = new double[info.length];
        for (int i = 0; i < attValues.length; ++i) {
            if (i == classIndex) continue;
            attValues[i] = random.nextInt((int)info[i]);
        }
        return new DenseInstance(1.0, attValues);
    }

    public static double[] toDataDouble(Instance instance) {
        double[] vector = null;
        int classIndex = instance.classIndex();
        vector = classIndex >= 0 ? new double[instance.numAttributes() - 1] : new double[instance.numAttributes()];
        int index = 0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == classIndex) continue;
            vector[index++] = instance.value(i);
        }
        return vector;
    }

    public static double minimalExtension(Instances instances, Instance instance) {
        return InstancesUtil.minimalExtension(instances, instance, 0.0);
    }

    public static double minimalExtension(Instances instances, Instance instance, double minValue) {
        double value = minValue;
        EnumerationIterator it = new EnumerationIterator(instances.enumerateInstances());
        while (it.hasNext()) {
            Instance tmp = (Instance)it.next();
            if (!(tmp.classValue() > value) || !InstancesUtil.smallerOrEqual(tmp, instance)) continue;
            value = tmp.classValue();
        }
        return value;
    }

    public static double maximalExtension(Instances instances, Instance instance) {
        return InstancesUtil.maximalExtension(instances, instance, instances.numClasses() - 1);
    }

    public static double maximalExtension(Instances instances, Instance instance, double maxValue) {
        double value = maxValue;
        EnumerationIterator it = new EnumerationIterator(instances.enumerateInstances());
        while (it.hasNext()) {
            Instance tmp = (Instance)it.next();
            if (!(tmp.classValue() < value) || !InstancesUtil.smallerOrEqual(instance, tmp)) continue;
            value = tmp.classValue();
        }
        return value;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }
}

