/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.DataObject;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.EuclidianDataObject;
import weka.clusterers.forOPTICSAndDBScan.Databases.Database;
import weka.clusterers.forOPTICSAndDBScan.Databases.SequentialDatabase;
import weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI.OPTICS_Visualizer;
import weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI.SERObject;
import weka.clusterers.forOPTICSAndDBScan.Utils.EpsilonRange_ListElement;
import weka.clusterers.forOPTICSAndDBScan.Utils.UpdateQueue;
import weka.clusterers.forOPTICSAndDBScan.Utils.UpdateQueueElement;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class OPTICS
extends AbstractClusterer
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 274552680222105221L;
    private double epsilon = 0.9;
    private int minPoints = 6;
    private ReplaceMissingValues replaceMissingValues_Filter;
    private int numberOfGeneratedClusters;
    private String database_distanceType = "weka.clusterers.forOPTICSAndDBScan.DataObjects.EuclidianDataObject";
    private String database_Type = "weka.clusterers.forOPTICSAndDBScan.Databases.SequentialDatabase";
    private Database database;
    private double elapsedTime;
    private boolean writeOPTICSresults = false;
    private FastVector resultVector;
    private boolean showGUI = true;
    private File databaseOutput = new File(".");

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        return result;
    }

    @Override
    public void buildClusterer(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.resultVector = new FastVector();
        long time_1 = System.currentTimeMillis();
        this.numberOfGeneratedClusters = 0;
        this.replaceMissingValues_Filter = new ReplaceMissingValues();
        this.replaceMissingValues_Filter.setInputFormat(instances);
        Instances filteredInstances = Filter.useFilter(instances, this.replaceMissingValues_Filter);
        this.database = this.databaseForName(this.getDatabase_Type(), filteredInstances);
        for (int i = 0; i < this.database.getInstances().numInstances(); ++i) {
            DataObject dataObject = this.dataObjectForName(this.getDatabase_distanceType(), this.database.getInstances().instance(i), Integer.toString(i), this.database);
            this.database.insert(dataObject);
        }
        this.database.setMinMaxValues();
        UpdateQueue seeds = new UpdateQueue();
        Iterator iterator = this.database.dataObjectIterator();
        while (iterator.hasNext()) {
            DataObject dataObject = (DataObject)iterator.next();
            if (dataObject.isProcessed()) continue;
            this.expandClusterOrder(dataObject, seeds);
        }
        long time_2 = System.currentTimeMillis();
        this.elapsedTime = (double)(time_2 - time_1) / 1000.0;
        if (this.writeOPTICSresults) {
            String fileName = "";
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            String timeStamp = gregorianCalendar.get(5) + "-" + (gregorianCalendar.get(2) + 1) + "-" + gregorianCalendar.get(1) + "--" + gregorianCalendar.get(11) + "-" + gregorianCalendar.get(12) + "-" + gregorianCalendar.get(13);
            fileName = "OPTICS_" + timeStamp + ".TXT";
            FileWriter fileWriter = new FileWriter(fileName);
            BufferedWriter bufferedOPTICSWriter = new BufferedWriter(fileWriter);
            for (int i = 0; i < this.resultVector.size(); ++i) {
                bufferedOPTICSWriter.write(this.format_dataObject((DataObject)this.resultVector.elementAt(i)));
            }
            bufferedOPTICSWriter.flush();
            bufferedOPTICSWriter.close();
        }
        if (!this.databaseOutput.isDirectory()) {
            try {
                FileOutputStream fos = new FileOutputStream(this.databaseOutput);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this.getSERObject());
                oos.flush();
                oos.close();
                fos.close();
            }
            catch (Exception e) {
                System.err.println("Error writing generated database to file '" + this.getDatabaseOutput() + "': " + e);
                e.printStackTrace();
            }
        }
        if (this.showGUI) {
            new OPTICS_Visualizer(this.getSERObject(), "OPTICS Visualizer - Main Window");
        }
    }

    private void expandClusterOrder(DataObject dataObject, UpdateQueue seeds) {
        List list = this.database.coreDistance(this.getMinPoints(), this.getEpsilon(), dataObject);
        List epsilonRange_List = (List)list.get(1);
        dataObject.setReachabilityDistance(2.147483647E9);
        dataObject.setCoreDistance((Double)list.get(2));
        dataObject.setProcessed(true);
        this.resultVector.addElement(dataObject);
        if (dataObject.getCoreDistance() != 2.147483647E9) {
            this.update(seeds, epsilonRange_List, dataObject);
            while (seeds.hasNext()) {
                UpdateQueueElement updateQueueElement = seeds.next();
                DataObject currentDataObject = (DataObject)updateQueueElement.getObject();
                currentDataObject.setReachabilityDistance(updateQueueElement.getPriority());
                List list_1 = this.database.coreDistance(this.getMinPoints(), this.getEpsilon(), currentDataObject);
                List epsilonRange_List_1 = (List)list_1.get(1);
                currentDataObject.setCoreDistance((Double)list_1.get(2));
                currentDataObject.setProcessed(true);
                this.resultVector.addElement(currentDataObject);
                if (currentDataObject.getCoreDistance() == 2.147483647E9) continue;
                this.update(seeds, epsilonRange_List_1, currentDataObject);
            }
        }
    }

    private String format_dataObject(DataObject dataObject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(" + Utils.doubleToString(Double.parseDouble(dataObject.getKey()), Integer.toString(this.database.size()).length(), 0) + ".) " + Utils.padRight(dataObject.toString(), 40) + "  -->  c_dist: " + (dataObject.getCoreDistance() == 2.147483647E9 ? Utils.padRight("UNDEFINED", 12) : Utils.padRight(Utils.doubleToString(dataObject.getCoreDistance(), 2, 3), 12)) + " r_dist: " + (dataObject.getReachabilityDistance() == 2.147483647E9 ? Utils.padRight("UNDEFINED", 12) : Utils.doubleToString(dataObject.getReachabilityDistance(), 2, 3)) + "\n");
        return stringBuffer.toString();
    }

    private void update(UpdateQueue seeds, List epsilonRange_list, DataObject centralObject) {
        double coreDistance = centralObject.getCoreDistance();
        double new_r_dist = 2.147483647E9;
        for (int i = 0; i < epsilonRange_list.size(); ++i) {
            EpsilonRange_ListElement listElement = (EpsilonRange_ListElement)epsilonRange_list.get(i);
            DataObject neighbourhood_object = listElement.getDataObject();
            if (neighbourhood_object.isProcessed()) continue;
            new_r_dist = Math.max(coreDistance, listElement.getDistance());
            seeds.add(new_r_dist, neighbourhood_object, neighbourhood_object.getKey());
        }
    }

    @Override
    public int clusterInstance(Instance instance) throws Exception {
        throw new Exception();
    }

    @Override
    public int numberOfClusters() throws Exception {
        return this.numberOfGeneratedClusters;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tepsilon (default = 0.9)", "E", 1, "-E <double>"));
        vector.addElement(new Option("\tminPoints (default = 6)", "M", 1, "-M <int>"));
        vector.addElement(new Option("\tindex (database) used for OPTICS (default = weka.clusterers.forOPTICSAndDBScan.Databases.SequentialDatabase)", "I", 1, "-I <String>"));
        vector.addElement(new Option("\tdistance-type (default = weka.clusterers.forOPTICSAndDBScan.DataObjects.EuclidianDataObject)", "D", 1, "-D <String>"));
        vector.addElement(new Option("\twrite results to OPTICS_#TimeStamp#.TXT - File", "F", 0, "-F"));
        vector.addElement(new Option("\tsuppress the display of the GUI after building the clusterer", "no-gui", 0, "-no-gui"));
        vector.addElement(new Option("\tThe file to save the generated database to. If a directory\n\tis provided, the database doesn't get saved.\n\tThe generated file can be viewed with the OPTICS Visualizer:\n\t  java " + OPTICS_Visualizer.class.getName() + " [file.ser]\n" + "\t(default: .)", "db-output", 1, "-db-output <file>"));
        return vector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption('E', options);
        if (optionString.length() != 0) {
            this.setEpsilon(Double.parseDouble(optionString));
        } else {
            this.setEpsilon(0.9);
        }
        optionString = Utils.getOption('M', options);
        if (optionString.length() != 0) {
            this.setMinPoints(Integer.parseInt(optionString));
        } else {
            this.setMinPoints(6);
        }
        optionString = Utils.getOption('I', options);
        if (optionString.length() != 0) {
            this.setDatabase_Type(optionString);
        } else {
            this.setDatabase_Type(SequentialDatabase.class.getName());
        }
        optionString = Utils.getOption('D', options);
        if (optionString.length() != 0) {
            this.setDatabase_distanceType(optionString);
        } else {
            this.setDatabase_distanceType(EuclidianDataObject.class.getName());
        }
        this.setWriteOPTICSresults(Utils.getFlag('F', options));
        this.setShowGUI(!Utils.getFlag("no-gui", options));
        optionString = Utils.getOption("db-output", options);
        if (optionString.length() != 0) {
            this.setDatabaseOutput(new File(optionString));
        } else {
            this.setDatabaseOutput(new File("."));
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-E");
        result.add("" + this.getEpsilon());
        result.add("-M");
        result.add("" + this.getMinPoints());
        result.add("-I");
        result.add("" + this.getDatabase_Type());
        result.add("-D");
        result.add("" + this.getDatabase_distanceType());
        if (this.getWriteOPTICSresults()) {
            result.add("-F");
        }
        if (!this.getShowGUI()) {
            result.add("-no-gui");
        }
        result.add("-db-output");
        result.add("" + this.getDatabaseOutput());
        return result.toArray(new String[result.size()]);
    }

    public Database databaseForName(String database_Type, Instances instances) {
        Object o = null;
        Constructor<?> co = null;
        try {
            co = Class.forName(database_Type).getConstructor(Instances.class);
            o = co.newInstance(instances);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return o;
    }

    public DataObject dataObjectForName(String database_distanceType, Instance instance, String key, Database database) {
        Object o = null;
        Constructor<?> co = null;
        try {
            co = Class.forName(database_distanceType).getConstructor(Instance.class, String.class, Database.class);
            o = co.newInstance(instance, key, database);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return o;
    }

    public void setMinPoints(int minPoints) {
        this.minPoints = minPoints;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public int getMinPoints() {
        return this.minPoints;
    }

    public String getDatabase_distanceType() {
        return this.database_distanceType;
    }

    public String getDatabase_Type() {
        return this.database_Type;
    }

    public void setDatabase_distanceType(String database_distanceType) {
        this.database_distanceType = database_distanceType;
    }

    public void setDatabase_Type(String database_Type) {
        this.database_Type = database_Type;
    }

    public boolean getWriteOPTICSresults() {
        return this.writeOPTICSresults;
    }

    public void setWriteOPTICSresults(boolean writeOPTICSresults) {
        this.writeOPTICSresults = writeOPTICSresults;
    }

    public boolean getShowGUI() {
        return this.showGUI;
    }

    public void setShowGUI(boolean value) {
        this.showGUI = value;
    }

    public File getDatabaseOutput() {
        return this.databaseOutput;
    }

    public void setDatabaseOutput(File value) {
        this.databaseOutput = value;
    }

    public FastVector getResultVector() {
        return this.resultVector;
    }

    public String epsilonTipText() {
        return "radius of the epsilon-range-queries";
    }

    public String minPointsTipText() {
        return "minimun number of DataObjects required in an epsilon-range-query";
    }

    public String database_TypeTipText() {
        return "used database";
    }

    public String database_distanceTypeTipText() {
        return "used distance-type";
    }

    public String writeOPTICSresultsTipText() {
        return "if the -F option is set, the results are written to OPTICS_#TimeStamp#.TXT";
    }

    public String showGUITipText() {
        return "Defines whether the OPTICS Visualizer is displayed after the clusterer has been built or not.";
    }

    public String databaseOutputTipText() {
        return "The optional output file for the generated database object - can be viewed with the OPTICS Visualizer.\njava " + OPTICS_Visualizer.class.getName() + " [file.ser]";
    }

    public String globalInfo() {
        return this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Mihael Ankerst and Markus M. Breunig and Hans-Peter Kriegel and Joerg Sander");
        result.setValue(TechnicalInformation.Field.TITLE, "OPTICS: Ordering Points To Identify the Clustering Structure");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "ACM SIGMOD International Conference on Management of Data");
        result.setValue(TechnicalInformation.Field.YEAR, "1999");
        result.setValue(TechnicalInformation.Field.PAGES, "49-60");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        return result;
    }

    public SERObject getSERObject() {
        SERObject serObject = new SERObject(this.resultVector, this.database.size(), this.database.getInstances().numAttributes(), this.getEpsilon(), this.getMinPoints(), this.writeOPTICSresults, this.getDatabase_Type(), this.getDatabase_distanceType(), this.numberOfGeneratedClusters, Utils.doubleToString(this.elapsedTime, 3, 3));
        return serObject;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OPTICS clustering results\n============================================================================================\n\n");
        stringBuffer.append("Clustered DataObjects: " + this.database.size() + "\n");
        stringBuffer.append("Number of attributes: " + this.database.getInstances().numAttributes() + "\n");
        stringBuffer.append("Epsilon: " + this.getEpsilon() + "; minPoints: " + this.getMinPoints() + "\n");
        stringBuffer.append("Write results to file: " + (this.writeOPTICSresults ? "yes" : "no") + "\n");
        stringBuffer.append("Index: " + this.getDatabase_Type() + "\n");
        stringBuffer.append("Distance-type: " + this.getDatabase_distanceType() + "\n");
        stringBuffer.append("Number of generated clusters: " + this.numberOfGeneratedClusters + "\n");
        DecimalFormat decimalFormat = new DecimalFormat(".##");
        stringBuffer.append("Elapsed time: " + decimalFormat.format(this.elapsedTime) + "\n\n");
        for (int i = 0; i < this.resultVector.size(); ++i) {
            stringBuffer.append(this.format_dataObject((DataObject)this.resultVector.elementAt(i)));
        }
        return stringBuffer.toString() + "\n";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5488 $");
    }

    public static void main(String[] args) {
        OPTICS.runClusterer(new OPTICS(), args);
    }
}

