/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import weka.core.ClassDiscovery;

public class SortedTableModel
extends AbstractTableModel
implements TableModelListener {
    static final long serialVersionUID = 4030907921461127548L;
    protected TableModel mModel;
    protected int[] mIndices;
    protected int mSortColumn;
    protected boolean mAscending;

    public SortedTableModel() {
        this(null);
    }

    public SortedTableModel(TableModel model) {
        this.setModel(model);
    }

    public void setModel(TableModel value) {
        this.mModel = value;
        if (this.mModel == null) {
            this.mIndices = null;
        } else {
            this.initializeIndices();
            this.mSortColumn = -1;
            this.mAscending = true;
            this.mModel.addTableModelListener(this);
        }
    }

    protected void initializeIndices() {
        this.mIndices = new int[this.mModel.getRowCount()];
        for (int i = 0; i < this.mIndices.length; ++i) {
            this.mIndices[i] = i;
        }
    }

    public TableModel getModel() {
        return this.mModel;
    }

    public boolean isSorted() {
        return this.mSortColumn > -1;
    }

    protected boolean isInitialized() {
        return this.getModel() != null;
    }

    public int getActualRow(int visibleRow) {
        if (!this.isInitialized()) {
            return -1;
        }
        return this.mIndices[visibleRow];
    }

    public Class getColumnClass(int columnIndex) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getModel().getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        if (!this.isInitialized()) {
            return 0;
        }
        return this.getModel().getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getModel().getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        if (!this.isInitialized()) {
            return 0;
        }
        return this.getModel().getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.getModel().getValueAt(this.mIndices[rowIndex], columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.getModel().isCellEditable(this.mIndices[rowIndex], columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.isInitialized()) {
            this.getModel().setValueAt(aValue, this.mIndices[rowIndex], columnIndex);
        }
    }

    public void sort(int columnIndex) {
        this.sort(columnIndex, true);
    }

    public void sort(int columnIndex, boolean ascending) {
        int backup;
        int i;
        if (!this.isInitialized() || this.getModel().getRowCount() != this.mIndices.length) {
            System.out.println(this.getClass().getName() + ": Table model not initialized!");
            return;
        }
        this.mSortColumn = columnIndex;
        this.mAscending = ascending;
        this.initializeIndices();
        int columnType = ClassDiscovery.isSubclass(Number.class, this.getColumnClass(this.mSortColumn)) ? 1 : (ClassDiscovery.isSubclass(Date.class, this.getColumnClass(this.mSortColumn)) ? 2 : 0);
        for (i = 0; i < this.getRowCount() - 1; ++i) {
            int index = i;
            for (int n = i + 1; n < this.getRowCount(); ++n) {
                if (this.compare(this.mIndices[index], this.mIndices[n], this.mSortColumn, columnType) <= 0) continue;
                index = n;
            }
            if (index == i) continue;
            backup = this.mIndices[i];
            this.mIndices[i] = this.mIndices[index];
            this.mIndices[index] = backup;
        }
        if (!this.mAscending) {
            for (i = 0; i < this.getRowCount() / 2; ++i) {
                backup = this.mIndices[i];
                this.mIndices[i] = this.mIndices[this.getRowCount() - i - 1];
                this.mIndices[this.getRowCount() - i - 1] = backup;
            }
        }
    }

    protected int compare(int row1, int row2, int col, int type) {
        int result;
        Object o1 = this.getModel().getValueAt(row1, col);
        Object o2 = this.getModel().getValueAt(row2, col);
        if (o1 == null && o2 == null) {
            result = 0;
        } else if (o1 == null) {
            result = -1;
        } else if (o2 == null) {
            result = 1;
        } else {
            switch (type) {
                case 1: {
                    Double d1 = new Double(((Number)o1).doubleValue());
                    Double d2 = new Double(((Number)o2).doubleValue());
                    result = d1.compareTo(d2);
                    break;
                }
                case 2: {
                    result = ((Date)o1).compareTo((Date)o2);
                    break;
                }
                default: {
                    result = o1.toString().compareTo(o2.toString());
                }
            }
        }
        return result;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.initializeIndices();
        if (this.isSorted()) {
            this.sort(this.mSortColumn, this.mAscending);
        }
        this.fireTableChanged(e);
    }

    public void addMouseListenerToHeader(JTable table) {
        final SortedTableModel modelFinal = this;
        final JTable tableFinal = table;
        tableFinal.setColumnSelectionAllowed(false);
        JTableHeader header = tableFinal.getTableHeader();
        if (header != null) {
            MouseAdapter listMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TableColumnModel columnModel = tableFinal.getColumnModel();
                    int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                    int column = tableFinal.convertColumnIndexToModel(viewColumn);
                    if (e.getButton() == 1 && e.getClickCount() == 1 && !e.isAltDown() && column != -1) {
                        int shiftPressed = e.getModifiers() & 1;
                        boolean ascending = shiftPressed == 0;
                        modelFinal.sort(column, ascending);
                    }
                }
            };
            header.addMouseListener(listMouseListener);
        }
    }
}

