/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeModel;
import weka.classifiers.Classifier;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.trees.J48;
import weka.gui.GenericObjectEditor;
import weka.gui.ensembleLibraryEditor.ListModelsPanel;
import weka.gui.ensembleLibraryEditor.ModelList;
import weka.gui.ensembleLibraryEditor.tree.GenericObjectNode;
import weka.gui.ensembleLibraryEditor.tree.ModelTreeNodeEditor;
import weka.gui.ensembleLibraryEditor.tree.ModelTreeNodeRenderer;

public class AddModelsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4874639416371962573L;
    private ListModelsPanel m_ListModelsPanel;
    private JTree m_Tree;
    private DefaultTreeModel m_TreeModel;
    private JButton m_GenerateButton;
    private JLabel m_GenerateLabel;
    private JButton m_RemoveSelectedButton;
    private JButton m_RemoveInvalidButton;
    private JButton m_AddSelectedButton;
    private JButton m_AddAllButton;
    private ModelList m_ModelList;
    JScrollPane m_TreeView;

    public AddModelsPanel(ListModelsPanel listModelsPanel) {
        this.m_ListModelsPanel = listModelsPanel;
        this.createAddModelsPanel();
    }

    private void createAddModelsPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.m_TreeView = new JScrollPane();
        this.m_TreeView.setPreferredSize(new Dimension(150, 50));
        this.buildClassifierTree(new J48());
        ToolTipManager.sharedInstance().registerComponent(this.m_Tree);
        gbc.weightx = 1.0;
        gbc.weighty = 1.5;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.add((Component)this.m_TreeView, gbc);
        this.m_GenerateButton = new JButton("Generate Models");
        this.m_GenerateButton.setToolTipText("Generate a set of models from options specified in options tree");
        this.m_GenerateButton.addActionListener(this);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.add((Component)this.m_GenerateButton, gbc);
        this.m_GenerateLabel = new JLabel("");
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        this.add((Component)this.m_GenerateLabel, gbc);
        this.m_RemoveInvalidButton = new JButton("Remove Invalid");
        this.m_RemoveInvalidButton.setToolTipText("Remove all invalid (red) models from the above list");
        this.m_RemoveInvalidButton.addActionListener(this);
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.m_ModelList = new ModelList();
        this.m_ModelList.getInputMap().put(KeyStroke.getKeyStroke("released DELETE"), "deleteSelected");
        this.m_ModelList.getActionMap().put("deleteSelected", new AbstractAction("deleteSelected"){
            private static final long serialVersionUID = -3351194234735560372L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object[] currentModels = AddModelsPanel.this.m_ModelList.getSelectedValues();
                ModelList.SortedListModel dataModel = (ModelList.SortedListModel)AddModelsPanel.this.m_ModelList.getModel();
                for (int i = 0; i < currentModels.length; ++i) {
                    dataModel.removeElement((EnsembleLibraryModel)currentModels[i]);
                }
                int[] selected = new int[]{AddModelsPanel.this.m_ModelList.getSelectedIndices()[0]};
                AddModelsPanel.this.m_ModelList.setSelectedIndices(selected);
            }
        });
        this.m_ModelList.setSelectionMode(2);
        this.m_ModelList.setLayoutOrientation(0);
        this.m_ModelList.setVisibleRowCount(-1);
        JPanel modelListPanel = new JPanel();
        modelListPanel.setBorder(BorderFactory.createTitledBorder("Working Set of Newly Generated Models"));
        JScrollPane listView = new JScrollPane(this.m_ModelList);
        listView.setPreferredSize(new Dimension(150, 50));
        modelListPanel.setLayout(new BorderLayout());
        modelListPanel.add((Component)listView, "Center");
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.add((Component)modelListPanel, gbc);
        this.m_RemoveSelectedButton = new JButton("Remove Selected");
        this.m_RemoveSelectedButton.setToolTipText("Remove all currently selected models from the above list");
        this.m_RemoveSelectedButton.addActionListener(this);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.add((Component)this.m_RemoveSelectedButton, gbc);
        this.m_AddSelectedButton = new JButton("Add Selected");
        this.m_AddSelectedButton.setToolTipText("Add selected models in the above list to the model library");
        this.m_AddSelectedButton.addActionListener(this);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.add((Component)this.m_AddSelectedButton, gbc);
        this.m_AddAllButton = new JButton("Add All");
        this.m_AddAllButton.setToolTipText("Add all models in the above list to the model library");
        this.m_AddAllButton.addActionListener(this);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        this.add((Component)this.m_AddAllButton, gbc);
    }

    public void buildClassifierTree(Classifier classifier) {
        GenericObjectEditor classifierEditor = new GenericObjectEditor();
        classifierEditor.setClassType(Classifier.class);
        classifierEditor.setValue(classifier);
        GenericObjectNode rootNode = new GenericObjectNode(this, classifier, classifierEditor, "Current Classifier");
        this.m_TreeModel = new DefaultTreeModel(rootNode);
        this.m_Tree = new JTree(this.m_TreeModel);
        rootNode.setTree(this.m_Tree);
        rootNode.updateTree();
        this.m_Tree.setRootVisible(true);
        ModelTreeNodeRenderer renderer = new ModelTreeNodeRenderer();
        this.m_Tree.setCellRenderer(renderer);
        this.m_Tree.setCellEditor(new ModelTreeNodeEditor(this.m_Tree));
        this.m_Tree.setEditable(true);
        this.m_Tree.setVisibleRowCount(8);
        this.m_Tree.setRowHeight(0);
        this.m_TreeView.setViewportView(this.m_Tree);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block11: {
            ModelList.SortedListModel dataModel;
            block12: {
                block10: {
                    dataModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
                    if (e.getSource() != this.m_GenerateButton) break block10;
                    Vector models = ((GenericObjectNode)this.m_TreeModel.getRoot()).getValues();
                    int total = models.size();
                    int invalid = 0;
                    for (int i = 0; i < models.size(); ++i) {
                        Classifier classifier = (Classifier)models.get(i);
                        EnsembleLibraryModel model = this.m_ListModelsPanel.getLibrary().createModel(classifier);
                        model.testOptions();
                        if (!model.getOptionsWereValid()) {
                            ++invalid;
                        }
                        dataModel.add(model);
                    }
                    String generateString = new String("  " + total + " models generated");
                    generateString = generateString + ", " + invalid + " had errors";
                    this.m_GenerateLabel.setText(generateString);
                    break block11;
                }
                if (e.getSource() != this.m_RemoveSelectedButton) break block12;
                Object[] currentModels = this.m_ModelList.getSelectedValues();
                for (int i = 0; i < currentModels.length; ++i) {
                    dataModel.removeElement(currentModels[i]);
                }
                if (this.m_ModelList.getSelectedIndices().length <= 0) break block11;
                int[] selected = new int[]{this.m_ModelList.getSelectedIndices()[0]};
                this.m_ModelList.setSelectedIndices(selected);
                break block11;
            }
            if (e.getSource() == this.m_RemoveInvalidButton) {
                int i;
                Vector<EnsembleLibraryModel> toRemove = new Vector<EnsembleLibraryModel>();
                for (i = 0; i < dataModel.getSize(); ++i) {
                    EnsembleLibraryModel currentModel = (EnsembleLibraryModel)dataModel.getElementAt(i);
                    if (currentModel.getOptionsWereValid()) continue;
                    toRemove.add(currentModel);
                }
                for (i = 0; i < toRemove.size(); ++i) {
                    dataModel.removeElement(toRemove.get(i));
                }
            } else if (e.getSource() == this.m_AddAllButton) {
                Iterator it = dataModel.iterator();
                while (it.hasNext()) {
                    EnsembleLibraryModel currentModel = (EnsembleLibraryModel)it.next();
                    if (!currentModel.getOptionsWereValid()) continue;
                    this.m_ListModelsPanel.addModel(currentModel);
                }
                int size = dataModel.getSize();
                for (int i = 0; i < size; ++i) {
                    dataModel.removeElement(dataModel.getElementAt(0));
                }
            }
        }
    }
}

