/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.EnsembleLibraryModelComparator;

public class ModelList
extends JList {
    private static final long serialVersionUID = -421567241792939539L;

    public ModelList() {
        this.setModel(new SortedListModel());
        this.setCellRenderer(new ModelListRenderer());
    }

    public class SortedListModel
    extends AbstractListModel {
        private static final long serialVersionUID = -8334675481243839371L;
        SortedSet m_Models = new TreeSet(new EnsembleLibraryModelComparator());

        @Override
        public int getSize() {
            return this.m_Models.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.m_Models.toArray()[index];
        }

        public void add(Object element) {
            if (this.m_Models.add(element)) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
        }

        public void addAll(Object[] elements) {
            List<Object> c = Arrays.asList(elements);
            this.m_Models.addAll(c);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void clear() {
            this.m_Models.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public boolean contains(Object element) {
            return this.m_Models.contains(element);
        }

        public Object firstElement() {
            return this.m_Models.first();
        }

        public Iterator iterator() {
            return this.m_Models.iterator();
        }

        public Object lastElement() {
            return this.m_Models.last();
        }

        public boolean removeElement(Object element) {
            boolean removed = this.m_Models.remove(element);
            if (removed) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
            return removed;
        }
    }

    public class ModelListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7061163240718897794L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component modelComponent = null;
            if (value instanceof EnsembleLibraryModel) {
                EnsembleLibraryModel model = (EnsembleLibraryModel)value;
                String modelString = index + ": " + model.getStringRepresentation().replaceAll("weka.classifiers.", "");
                modelComponent = super.getListCellRendererComponent((JList<?>)list, modelString, index, isSelected, cellHasFocus);
                if (!model.getOptionsWereValid()) {
                    modelComponent.setBackground(Color.pink);
                }
                ((JComponent)modelComponent).setToolTipText(model.getDescriptionText());
            }
            return modelComponent;
        }
    }
}

