/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import weka.classifiers.Classifier;
import weka.gui.GenericObjectEditor;
import weka.gui.ensembleLibraryEditor.AddModelsPanel;
import weka.gui.ensembleLibraryEditor.tree.PropertyNode;

public class GenericObjectNode
extends DefaultMutableTreeNode
implements PropertyChangeListener {
    private static final long serialVersionUID = 688096727663132485L;
    private PropertyDescriptor[] m_Properties;
    private Vector m_UsedPropertyIndexes;
    private MethodDescriptor[] m_Methods;
    private PropertyEditor[] m_Editors;
    private Object[] m_Values;
    private String[] m_Names;
    private String[] m_TipTexts;
    private StringBuffer m_HelpText;
    private GenericObjectEditor m_GenericObjectEditor;
    private Vector m_WorkingSetCombinations;
    private String m_ToolTipText;
    private DefaultTreeModel m_TreeModel;
    private JTree m_Tree;
    private final AddModelsPanel m_ParentPanel;

    public GenericObjectNode(AddModelsPanel panel, Object value, GenericObjectEditor genericObjectEditor, String toolTipText) {
        super(value);
        this.m_ParentPanel = panel;
        this.m_GenericObjectEditor = genericObjectEditor;
        this.m_ToolTipText = toolTipText;
    }

    public void setTree(JTree tree) {
        this.m_Tree = tree;
        this.m_TreeModel = (DefaultTreeModel)this.m_Tree.getModel();
    }

    public JTree getTree() {
        return this.m_Tree;
    }

    public GenericObjectEditor getEditor() {
        return this.m_GenericObjectEditor;
    }

    public StringBuffer getHelpText() {
        return this.m_HelpText;
    }

    public String getToolTipText() {
        return this.m_ToolTipText;
    }

    public Object getObject() {
        return this.getUserObject();
    }

    public void setObject(Object newValue) {
        this.setUserObject(newValue);
    }

    @Override
    public void setUserObject(Object o) {
        if (o != null) {
            super.setUserObject(o);
        }
    }

    public JPanel getParentPanel() {
        return this.m_ParentPanel;
    }

    @Override
    public String toString() {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = ((GenericObjectEditor)evt.getSource()).getValue();
        if (!newValue.getClass().equals(this.getObject().getClass())) {
            if (this.m_TreeModel.getRoot() == this) {
                try {
                    this.m_ParentPanel.buildClassifierTree((Classifier)newValue.getClass().newInstance());
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                this.m_ParentPanel.update(this.m_ParentPanel.getGraphics());
                this.m_ParentPanel.repaint();
            } else {
                this.setObject(newValue);
                this.updateTree();
                this.updateTree();
                this.m_TreeModel.nodeChanged(this);
            }
        }
    }

    public void updateTree() {
        int childCount = this.m_TreeModel.getChildCount(this);
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.m_TreeModel.getChild(this, 0);
            this.m_TreeModel.removeNodeFromParent(child);
        }
        Object classifier = this.getUserObject();
        try {
            BeanInfo bi = Introspector.getBeanInfo(classifier.getClass());
            this.m_Properties = bi.getPropertyDescriptors();
            this.m_Methods = bi.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            System.err.println("PropertySheet: Couldn't introspect");
            return;
        }
        for (int i = 0; i < this.m_Methods.length; ++i) {
            String name = this.m_Methods[i].getDisplayName();
            Method meth = this.m_Methods[i].getMethod();
            if (!name.equals("globalInfo") || !meth.getReturnType().equals(String.class)) continue;
            try {
                String globalInfo;
                Object[] args = new Object[]{};
                String summary = globalInfo = (String)meth.invoke(this.getObject(), args);
                int ci = globalInfo.indexOf(46);
                if (ci != -1) {
                    summary = globalInfo.substring(0, ci + 1);
                }
                String className = this.getObject().getClass().getName();
                this.m_HelpText = new StringBuffer("NAME\n");
                this.m_HelpText.append(className).append("\n\n");
                this.m_HelpText.append("SYNOPSIS\n").append(globalInfo).append("\n\n");
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.m_UsedPropertyIndexes = new Vector();
        this.m_Editors = new PropertyEditor[this.m_Properties.length];
        this.m_Values = new Object[this.m_Properties.length];
        this.m_Names = new String[this.m_Properties.length];
        this.m_TipTexts = new String[this.m_Properties.length];
        boolean firstTip = true;
        for (int i = 0; i < this.m_Properties.length; ++i) {
            if (this.m_Properties[i].isHidden() || this.m_Properties[i].isExpert()) continue;
            this.m_Names[i] = this.m_Properties[i].getDisplayName();
            Class<?> type = this.m_Properties[i].getPropertyType();
            Method getter = this.m_Properties[i].getReadMethod();
            Method setter = this.m_Properties[i].getWriteMethod();
            if (getter == null || setter == null) continue;
            try {
                Object value;
                Object[] args = new Object[]{};
                this.m_Values[i] = value = getter.invoke(classifier, args);
                PropertyEditor editor = null;
                Class<?> pec = this.m_Properties[i].getPropertyEditorClass();
                if (pec != null) {
                    try {
                        editor = (PropertyEditor)pec.newInstance();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (editor == null) {
                    editor = PropertyEditorManager.findEditor(type);
                }
                this.m_Editors[i] = editor;
                if (editor == null) continue;
                if (editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)editor).setClassType(type);
                }
                if (value == null) continue;
                editor.setValue(value);
                String tipName = this.m_Names[i] + "TipText";
                for (int j = 0; j < this.m_Methods.length; ++j) {
                    String mname = this.m_Methods[j].getDisplayName();
                    Method meth = this.m_Methods[j].getMethod();
                    if (!mname.equals(tipName) || !meth.getReturnType().equals(String.class)) continue;
                    try {
                        String tempTip = (String)meth.invoke(classifier, args);
                        int ci = tempTip.indexOf(46);
                        this.m_TipTexts[i] = ci < 0 ? tempTip : tempTip.substring(0, ci);
                        if (this.m_HelpText == null) break;
                        if (firstTip) {
                            this.m_HelpText.append("OPTIONS\n");
                            firstTip = false;
                        }
                        this.m_HelpText.append(this.m_Names[i]).append(" -- ");
                        this.m_HelpText.append(tempTip).append("\n\n");
                    }
                    catch (Exception ex) {}
                    break;
                }
                this.m_UsedPropertyIndexes.add(new Integer(i));
                int currentCount = this.m_TreeModel.getChildCount(this);
                PropertyNode newNode = new PropertyNode(this.m_Tree, this.m_ParentPanel, this.m_Names[i], this.m_TipTexts[i], this.m_Values[i], this.m_Editors[i]);
                this.m_TreeModel.insertNodeInto(newNode, this, currentCount);
                continue;
            }
            catch (InvocationTargetException ex) {
                System.err.println("Skipping property " + this.m_Names[i] + " ; exception on target: " + ex.getTargetException());
                ex.getTargetException().printStackTrace();
                continue;
            }
            catch (Exception ex) {
                System.err.println("Skipping property " + this.m_Names[i] + " ; exception: " + ex);
                ex.printStackTrace();
            }
        }
        this.m_TreeModel.nodeStructureChanged(this);
    }

    public Vector getValues() {
        Vector<Vector> valuesVector = new Vector<Vector>();
        int childCount = this.m_TreeModel.getChildCount(this);
        for (int i = 0; i < childCount; ++i) {
            PropertyNode currentChild = (PropertyNode)this.m_TreeModel.getChild(this, i);
            Vector v = currentChild.getAllValues();
            valuesVector.add(v);
        }
        this.m_WorkingSetCombinations = new Vector();
        this.combineAllValues(new Vector(), valuesVector);
        Vector<Object> newGenericObjects = new Vector<Object>();
        for (int i = 0; i < this.m_WorkingSetCombinations.size(); ++i) {
            Vector current = (Vector)this.m_WorkingSetCombinations.get(i);
            Object o = this.getUserObject();
            Class<?> c = o.getClass();
            Object copy = null;
            try {
                copy = c.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            for (int j = 0; j < current.size(); ++j) {
                Object[] args = new Object[1];
                int index = (Integer)this.m_UsedPropertyIndexes.get(j);
                PropertyDescriptor property = this.m_Properties[index];
                Method setter = property.getWriteMethod();
                Class<?>[] params = setter.getParameterTypes();
                Object currentVal = current.get(j);
                if (params.length == 1 && params[0].toString().equals("boolean") && currentVal.getClass().toString().equals("class java.lang.String")) {
                    currentVal = new Boolean((String)current.get(j));
                }
                if (params.length == 1 && params[0].toString().equals("class weka.core.SelectedTag") && currentVal.getClass().toString().equals("class java.lang.String")) {
                    String tagString = (String)current.get(j);
                    this.m_Editors[index].setAsText(tagString);
                    currentVal = this.m_Editors[index].getValue();
                }
                args[0] = currentVal;
                try {
                    setter.invoke(copy, args);
                    continue;
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof PropertyVetoException) {
                        String message = "WARNING: Vetoed; reason is: " + ex.getTargetException().getMessage();
                        System.err.println(message);
                        JRootPane jf = this.m_ParentPanel.getRootPane();
                        JOptionPane.showMessageDialog(jf, message, "error", 2);
                        if (!(jf instanceof JFrame)) continue;
                        ((JFrame)((Object)jf)).dispose();
                        continue;
                    }
                    System.err.println(ex.getTargetException().getClass().getName() + " while updating " + property.getName() + ": " + ex.getTargetException().getMessage());
                    JRootPane jf = this.m_ParentPanel.getRootPane();
                    JOptionPane.showMessageDialog(jf, ex.getTargetException().getClass().getName() + " while updating " + property.getName() + ":\n" + ex.getTargetException().getMessage(), "error", 2);
                    if (!(jf instanceof JFrame)) continue;
                    ((JFrame)((Object)jf)).dispose();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            newGenericObjects.add(copy);
        }
        return newGenericObjects;
    }

    public void combineAllValues(Vector previouslySelected, Vector remainingValues) {
        if (remainingValues.isEmpty()) {
            this.m_WorkingSetCombinations.add(previouslySelected);
            return;
        }
        Vector currentSet = new Vector((Vector)remainingValues.get(0));
        Vector tmpRemaining = new Vector(remainingValues);
        tmpRemaining.removeElementAt(0);
        for (int i = 0; i < currentSet.size(); ++i) {
            Vector tmpPreviouslySelected = new Vector(previouslySelected);
            tmpPreviouslySelected.add(currentSet.get(i));
            this.combineAllValues(tmpPreviouslySelected, tmpRemaining);
        }
    }
}

