/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import weka.gui.GenericObjectEditor;
import weka.gui.ensembleLibraryEditor.tree.GenericObjectNode;

public class GenericObjectNodeEditor
extends JPanel
implements PropertyChangeListener,
ActionListener,
PopupMenuListener {
    private static final long serialVersionUID = -2382339640932830323L;
    private GenericObjectEditor m_GenericObjectEditor;
    private JLabel m_Label;
    private JButton m_ChooseClassButton;
    private JButton m_MoreInfoButton;
    private JFrame m_HelpFrame;
    private PropertyChangeSupport m_propertyChangeSupport = new PropertyChangeSupport(this);
    private Color textForeground;
    private Color textBackground;
    private GenericObjectNode m_Node;
    private JPopupMenu m_popup;

    public GenericObjectNodeEditor(GenericObjectNode node) {
        this.m_GenericObjectEditor = node.getEditor();
        this.m_GenericObjectEditor.setValue(node.getObject());
        this.m_GenericObjectEditor.addPropertyChangeListener(node);
        this.m_GenericObjectEditor.addPropertyChangeListener(this);
        this.m_Node = node;
        this.updateEditor();
    }

    public void updateEditor() {
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
        this.setForeground(this.textForeground);
        this.setBackground(this.textBackground);
        this.m_ChooseClassButton = new JButton("Choose");
        this.m_ChooseClassButton.addActionListener(this);
        this.m_ChooseClassButton.setForeground(this.textForeground);
        this.m_ChooseClassButton.setBackground(this.textBackground);
        Font fontValue = UIManager.getFont("Tree.font");
        String labelString = null;
        boolean replaceName = false;
        String className = this.m_Node.getObject().getClass().toString();
        if (className.length() > 23 && className.substring(0, 23).equals("class weka.classifiers.")) {
            replaceName = true;
        }
        labelString = replaceName ? new String(this.m_Node.getObject().getClass().toString().replaceAll("class weka.classifiers.", "")) : new String(this.m_Node.getObject().getClass().toString());
        this.m_Label = new JLabel(labelString);
        if (fontValue != null) {
            this.m_Label.setFont(fontValue);
        }
        this.m_Label.setForeground(this.textForeground);
        this.m_Label.setBackground(this.textBackground);
        this.m_MoreInfoButton = new JButton("More Info");
        this.m_MoreInfoButton.addActionListener(this);
        this.m_MoreInfoButton.setForeground(this.textForeground);
        this.m_MoreInfoButton.setBackground(this.textBackground);
        this.add(this.m_ChooseClassButton);
        this.add(this.m_Label);
        this.add(this.m_MoreInfoButton);
    }

    public void setPropertyChangeListener(PropertyChangeListener al) {
        if (this.m_GenericObjectEditor != null) {
            this.m_GenericObjectEditor.addPropertyChangeListener(al);
        }
        this.m_propertyChangeSupport.addPropertyChangeListener(al);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateEditor();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_ChooseClassButton) {
            this.m_popup = this.m_GenericObjectEditor.getChooseClassPopupMenu();
            this.m_popup.addPopupMenuListener(this);
            this.m_popup.show(this.m_ChooseClassButton, this.m_ChooseClassButton.getX(), this.m_ChooseClassButton.getY());
            this.m_popup.pack();
        } else if (e.getSource() == this.m_MoreInfoButton) {
            this.openHelpFrame();
        }
    }

    protected void openHelpFrame() {
        JTextArea ta = new JTextArea();
        ta.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        ta.setText(this.m_Node.getHelpText().toString());
        ta.setCaretPosition(0);
        final JFrame jf = new JFrame("Information");
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                jf.dispose();
                if (GenericObjectNodeEditor.this.m_HelpFrame == jf) {
                    GenericObjectNodeEditor.this.m_MoreInfoButton.setEnabled(true);
                }
            }
        });
        jf.getContentPane().setLayout(new BorderLayout());
        jf.getContentPane().add((Component)new JScrollPane(ta), "Center");
        jf.pack();
        jf.setSize(400, 350);
        jf.setLocation(this.getTopLevelAncestor().getLocationOnScreen().x + this.getTopLevelAncestor().getSize().width, this.getTopLevelAncestor().getLocationOnScreen().y);
        jf.setVisible(true);
        this.m_HelpFrame = jf;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.m_propertyChangeSupport.firePropertyChange(null, null, null);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }
}

