/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import weka.gui.EnsembleLibraryEditor;
import weka.gui.GenericObjectEditor;
import weka.gui.ensembleLibraryEditor.tree.CheckBoxNode;
import weka.gui.ensembleLibraryEditor.tree.CheckBoxNodeEditor;
import weka.gui.ensembleLibraryEditor.tree.DefaultNode;
import weka.gui.ensembleLibraryEditor.tree.GenericObjectNode;
import weka.gui.ensembleLibraryEditor.tree.GenericObjectNodeEditor;
import weka.gui.ensembleLibraryEditor.tree.NumberNode;
import weka.gui.ensembleLibraryEditor.tree.NumberNodeEditor;
import weka.gui.ensembleLibraryEditor.tree.PropertyNode;

public class ModelTreeNodeEditor
extends AbstractCellEditor
implements TreeCellEditor,
ItemListener,
PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 7057924814405386358L;
    private JTree m_Tree;

    public ModelTreeNodeEditor(JTree tree) {
        this.m_Tree = tree;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        Object node;
        MouseEvent mouseEvent;
        TreePath path;
        boolean returnValue = false;
        if (event instanceof MouseEvent && (path = this.m_Tree.getPathForLocation((mouseEvent = (MouseEvent)event).getX(), mouseEvent.getY())) != null && (node = path.getLastPathComponent()) != null && node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            returnValue = !(treeNode instanceof PropertyNode);
        }
        return returnValue;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        JComponent customRenderer = null;
        if (value instanceof GenericObjectNode) {
            GenericObjectNode node = (GenericObjectNode)value;
            customRenderer = new GenericObjectNodeEditor(node);
            customRenderer.setToolTipText(node.getToolTipText());
            ((GenericObjectNodeEditor)customRenderer).setPropertyChangeListener(this);
        } else if (value instanceof PropertyNode) {
            PropertyNode node = (PropertyNode)value;
            JLabel label = new JLabel(node.getName());
            label.setToolTipText(node.getToolTipText());
            customRenderer = label;
            customRenderer.setToolTipText(node.getToolTipText());
        } else if (value instanceof CheckBoxNode) {
            CheckBoxNode node = (CheckBoxNode)value;
            customRenderer = new CheckBoxNodeEditor(node);
            customRenderer.setToolTipText(node.getToolTipText());
            ((CheckBoxNodeEditor)customRenderer).setItemListener(this);
        } else if (value instanceof NumberNode) {
            NumberNode node = (NumberNode)value;
            customRenderer = new NumberNodeEditor(node);
            customRenderer.setToolTipText(node.getToolTipText());
            ((NumberNodeEditor)customRenderer).setPropertyChangeListener(this);
            ((NumberNodeEditor)customRenderer).setItemListener(this);
            ((NumberNodeEditor)customRenderer).setActionListener(this);
        } else if (value instanceof DefaultNode) {
            DefaultNode node = (DefaultNode)value;
            PropertyEditor nodeEditor = node.getEditor();
            customRenderer = (JComponent)EnsembleLibraryEditor.getDefaultRenderer(nodeEditor);
            customRenderer.setToolTipText(node.getToolTipText());
            nodeEditor.addPropertyChangeListener(this);
        }
        return customRenderer;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.stopCellEditing()) {
            this.fireEditingStopped();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof GenericObjectEditor || evt.getSource() instanceof GenericObjectNodeEditor) {
            if (this.stopCellEditing()) {
                this.fireEditingStopped();
            }
        } else if (evt.getPropertyName() != null && evt.getPropertyName().equals("value") && this.stopCellEditing()) {
            this.fireEditingStopped();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.stopCellEditing()) {
            this.fireEditingStopped();
        }
    }
}

