/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.swing.tree.DefaultMutableTreeNode;
import weka.gui.ensembleLibraryEditor.tree.NumberClassNotFoundException;

public class NumberNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -2505599954089243851L;
    public static final int NOT_ITERATOR = 0;
    public static final int TIMES_EQUAL = 1;
    public static final int PLUS_EQUAL = 2;
    private String m_Name;
    private int m_IteratorType;
    private boolean m_Checkable;
    private boolean m_Selected;
    private String m_ToolTipText;
    public static final int scale = 7;
    public static final double epsilon = 1.0E-6;

    public static double roundDouble(double a) {
        return new BigDecimal("" + a).setScale(7, 4).doubleValue();
    }

    public static float roundFloat(float a) {
        return new BigDecimal("" + a).setScale(7, 4).floatValue();
    }

    public NumberNode(String text, Number value, int iteratorType, boolean checkable, String toolTipText) {
        this.m_Name = text;
        this.setValue(value);
        this.m_IteratorType = iteratorType;
        this.m_Checkable = checkable;
        this.m_Selected = false;
        this.m_ToolTipText = toolTipText;
    }

    public boolean getSelected() {
        return this.m_Selected;
    }

    public void setSelected(boolean newValue) {
        this.m_Selected = newValue;
    }

    public Number getValue() {
        return (Number)this.getUserObject();
    }

    public void setValue(Number newValue) {
        this.userObject = newValue;
    }

    public int getIteratorType() {
        return this.m_IteratorType;
    }

    public void setIteratorType(int newValue) {
        this.m_IteratorType = newValue;
    }

    public boolean getCheckable() {
        return this.m_Checkable;
    }

    public String getText() {
        return this.m_Name;
    }

    public String getToolTipText() {
        return this.m_ToolTipText;
    }

    @Override
    public void setUserObject(Object o) {
        if (o != null) {
            super.setUserObject(o);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.m_Name + ": " + this.getUserObject().toString() + "]";
    }

    public Number getZeroValue() throws NumberClassNotFoundException {
        Number value = this.getValue();
        Number zero = null;
        if (value instanceof Double) {
            zero = new Double(0.0);
        } else if (value instanceof Integer) {
            zero = new Integer(0);
        } else if (value instanceof Float) {
            zero = new Float(0.0);
        } else if (value instanceof Long) {
            zero = new Long(0L);
        } else {
            throw new NumberClassNotFoundException(value.getClass() + " not currently supported.");
        }
        return zero;
    }

    public Number getOneValue() throws NumberClassNotFoundException {
        Number value = this.getValue();
        Number one = null;
        if (value instanceof Double) {
            one = new Double(1.0);
        } else if (value instanceof Integer) {
            one = new Integer(1);
        } else if (value instanceof Float) {
            one = new Float(1.0);
        } else if (value instanceof Long) {
            one = new Long(1L);
        } else {
            throw new NumberClassNotFoundException(value.getClass() + " not currently supported.");
        }
        return one;
    }

    public Number getTwoValue() throws NumberClassNotFoundException {
        Number value = this.getValue();
        Number two = null;
        if (value instanceof Double) {
            two = new Double(2.0);
        } else if (value instanceof Integer) {
            two = new Integer(2);
        } else if (value instanceof Float) {
            two = new Float(2.0);
        } else if (value instanceof Long) {
            two = new Long(2L);
        } else {
            throw new NumberClassNotFoundException(value.getClass() + " not currently supported.");
        }
        return two;
    }

    public Number addNumbers(Number a, Number b) throws NumberClassNotFoundException {
        Number sum = null;
        if (a instanceof Double && b instanceof Double) {
            sum = new Double(NumberNode.roundDouble(a.doubleValue() + b.doubleValue()));
        } else if (a instanceof Integer && b instanceof Integer) {
            sum = new Integer(a.intValue() + b.intValue());
        } else if (a instanceof Float && b instanceof Float) {
            sum = new Float(NumberNode.roundFloat(a.floatValue() + b.floatValue()));
        } else if (a instanceof Long && b instanceof Long) {
            sum = new Long(a.longValue() + b.longValue());
        } else {
            throw new NumberClassNotFoundException(a.getClass() + " and " + b.getClass() + " not currently supported.");
        }
        return sum;
    }

    public Number multiplyNumbers(Number a, Number b) throws NumberClassNotFoundException {
        Number product = null;
        if (a instanceof Double && b instanceof Double) {
            product = new Double(NumberNode.roundDouble(a.doubleValue() * b.doubleValue()));
        } else if (a instanceof Integer && b instanceof Integer) {
            product = new Integer(a.intValue() * b.intValue());
        } else if (a instanceof Float && b instanceof Float) {
            product = new Float(NumberNode.roundFloat(a.floatValue() * b.floatValue()));
        } else if (a instanceof Long && b instanceof Long) {
            product = new Long(a.longValue() * b.longValue());
        } else {
            throw new NumberClassNotFoundException(a.getClass() + " and " + b.getClass() + " not currently supported.");
        }
        return product;
    }

    public boolean lessThan(Number a, Number b) throws NumberClassNotFoundException {
        boolean greater = false;
        if (a instanceof Double && b instanceof Double) {
            if (a.doubleValue() < b.doubleValue()) {
                greater = true;
            }
        } else if (a instanceof Integer && b instanceof Integer) {
            if (a.intValue() < b.intValue()) {
                greater = true;
            }
        } else if (a instanceof Float && b instanceof Float) {
            if (a.floatValue() < b.floatValue()) {
                greater = true;
            }
        } else if (a instanceof Long && b instanceof Long) {
            if (a.longValue() < b.longValue()) {
                greater = true;
            }
        } else {
            throw new NumberClassNotFoundException(a.getClass() + " and " + b.getClass() + " not currently supported.");
        }
        return greater;
    }

    public boolean equals(Number a, Number b) throws NumberClassNotFoundException {
        boolean equals = false;
        if (a instanceof Double && b instanceof Double) {
            if (Math.abs(a.doubleValue() - b.doubleValue()) < 1.0E-6) {
                equals = true;
            }
        } else if (a instanceof Integer && b instanceof Integer) {
            if (a.intValue() == b.intValue()) {
                equals = true;
            }
        } else if (a instanceof Float && b instanceof Float) {
            if ((double)Math.abs(a.floatValue() - b.floatValue()) < 1.0E-6) {
                equals = true;
            }
        } else if (a instanceof Long && b instanceof Long) {
            if (a.longValue() == b.longValue()) {
                equals = true;
            }
        } else {
            throw new NumberClassNotFoundException(a.getClass() + " and " + b.getClass() + " not currently supported.");
        }
        return equals;
    }

    public NumberFormat getNumberFormat() throws NumberClassNotFoundException {
        NumberFormat numberFormat = null;
        Number value = this.getValue();
        if (value instanceof Double) {
            numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(7);
        } else if (value instanceof Integer) {
            numberFormat = NumberFormat.getIntegerInstance();
        } else if (value instanceof Float) {
            numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(7);
        } else if (value instanceof Long) {
            numberFormat = NumberFormat.getIntegerInstance();
        } else {
            throw new NumberClassNotFoundException(value.getClass() + " not currently supported.");
        }
        return numberFormat;
    }
}

